/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.domain.dto.ade;

import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.controller.dto.AnalysisAttributionReqDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.schema.SchemaAnalysisAttributionResDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class AdeAnalysisAttributionReqDTO
implements Serializable {
    private String userId;
    private String tenantId;
    private String locale;
    private String appCode;
    private String userToken;
    private String productVersion;
    private String method;
    private List<Map<String, Object>> groupedSolutionSteps;
    private List<Map<String, Object>> datasetList;

    public static AdeAnalysisAttributionReqDTO BuildAnalysisAttributionReq(SchemaAnalysisAttributionResDTO scrumAnalysis, AnalysisAttributionReqDTO req, SnapShotDTO orgSnapshotDTO, AuthoredUser user) {
        AdeAnalysisAttributionReqDTO attribution = new AdeAnalysisAttributionReqDTO();
        attribution.setGroupedSolutionSteps(scrumAnalysis.getData().getGroupedSolutionSteps());
        attribution.setUserId(user.getUserId());
        attribution.setTenantId(user.getTenantId());
        attribution.setUserToken(user.getToken());
        attribution.setMethod(AgileDataEnum.DATASET.getCode());
        attribution.setProductVersion("V2");
        attribution.setAppCode(req.getAppCode());
        attribution.setDatasetList(orgSnapshotDTO.getContext().getBizParams().getDatasetList());
        return attribution;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public String getUserToken() {
        return this.userToken;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getMethod() {
        return this.method;
    }

    public List<Map<String, Object>> getGroupedSolutionSteps() {
        return this.groupedSolutionSteps;
    }

    public List<Map<String, Object>> getDatasetList() {
        return this.datasetList;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setGroupedSolutionSteps(List<Map<String, Object>> groupedSolutionSteps) {
        this.groupedSolutionSteps = groupedSolutionSteps;
    }

    public void setDatasetList(List<Map<String, Object>> datasetList) {
        this.datasetList = datasetList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdeAnalysisAttributionReqDTO)) {
            return false;
        }
        AdeAnalysisAttributionReqDTO other = (AdeAnalysisAttributionReqDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        String this$appCode = this.getAppCode();
        String other$appCode = other.getAppCode();
        if (this$appCode == null ? other$appCode != null : !this$appCode.equals(other$appCode)) {
            return false;
        }
        String this$userToken = this.getUserToken();
        String other$userToken = other.getUserToken();
        if (this$userToken == null ? other$userToken != null : !this$userToken.equals(other$userToken)) {
            return false;
        }
        String this$productVersion = this.getProductVersion();
        String other$productVersion = other.getProductVersion();
        if (this$productVersion == null ? other$productVersion != null : !this$productVersion.equals(other$productVersion)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        List this$groupedSolutionSteps = this.getGroupedSolutionSteps();
        List other$groupedSolutionSteps = other.getGroupedSolutionSteps();
        if (this$groupedSolutionSteps == null ? other$groupedSolutionSteps != null : !((Object)this$groupedSolutionSteps).equals(other$groupedSolutionSteps)) {
            return false;
        }
        List this$datasetList = this.getDatasetList();
        List other$datasetList = other.getDatasetList();
        return !(this$datasetList == null ? other$datasetList != null : !((Object)this$datasetList).equals(other$datasetList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdeAnalysisAttributionReqDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        String $appCode = this.getAppCode();
        result = result * 59 + ($appCode == null ? 43 : $appCode.hashCode());
        String $userToken = this.getUserToken();
        result = result * 59 + ($userToken == null ? 43 : $userToken.hashCode());
        String $productVersion = this.getProductVersion();
        result = result * 59 + ($productVersion == null ? 43 : $productVersion.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        List $groupedSolutionSteps = this.getGroupedSolutionSteps();
        result = result * 59 + ($groupedSolutionSteps == null ? 43 : ((Object)$groupedSolutionSteps).hashCode());
        List $datasetList = this.getDatasetList();
        result = result * 59 + ($datasetList == null ? 43 : ((Object)$datasetList).hashCode());
        return result;
    }

    public String toString() {
        return "AdeAnalysisAttributionReqDTO(userId=" + this.getUserId() + ", tenantId=" + this.getTenantId() + ", locale=" + this.getLocale() + ", appCode=" + this.getAppCode() + ", userToken=" + this.getUserToken() + ", productVersion=" + this.getProductVersion() + ", method=" + this.getMethod() + ", groupedSolutionSteps=" + this.getGroupedSolutionSteps() + ", datasetList=" + this.getDatasetList() + ")";
    }
}

