/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.domain.dto.agileReport;

import com.digiwin.athena.adt.domain.dto.agileReport.PullDataDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class AamDataResDTO
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(AamDataResDTO.class);
    private String sceneCode;

    public static AamDataResDTO builderAamDataBySnapShotDTO(SnapShotDTO snapShotDTO, StringRedisTemplate stringRedisTemplate) {
        AamDataResDTO aamDataResDTO = new AamDataResDTO();
        Optional.ofNullable(snapShotDTO).map(SnapShotDTO::getContext).filter(context -> !CollectionUtils.isEmpty((Collection)context.getPullData())).ifPresent(context -> {
            String sceneCode = ((PullDataDTO)context.getPullData().get(0)).getSceneCode();
            if (StringUtils.isEmpty((CharSequence)sceneCode)) {
                return;
            }
            aamDataResDTO.setSceneCode(sceneCode);
            stringRedisTemplate.opsForValue().set((Object)snapShotDTO.getSnapshotId(), (Object)sceneCode, 86400000L, TimeUnit.SECONDS);
            log.info("adt builderAamDataBySnapShotDTO sceneCode:{}", (Object)sceneCode);
        });
        return aamDataResDTO;
    }

    public String getSceneCode() {
        return this.sceneCode;
    }

    public void setSceneCode(String sceneCode) {
        this.sceneCode = sceneCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AamDataResDTO)) {
            return false;
        }
        AamDataResDTO other = (AamDataResDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$sceneCode = this.getSceneCode();
        String other$sceneCode = other.getSceneCode();
        return !(this$sceneCode == null ? other$sceneCode != null : !this$sceneCode.equals(other$sceneCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AamDataResDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sceneCode = this.getSceneCode();
        result = result * 59 + ($sceneCode == null ? 43 : $sceneCode.hashCode());
        return result;
    }

    public String toString() {
        return "AamDataResDTO(sceneCode=" + this.getSceneCode() + ")";
    }
}

