/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.domain.dto.schema;

import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class QuerySchemaDebugDTO
implements Serializable {
    private String sceneCode;
    private String applicationCode;
    private String question;
    private String dimensionName;
    private String dimensionValue;
    private String timeName;
    private String timeStart;
    private String timeEnd;
    private String sortName;
    private String sortValue;
    private String limitName;
    private String limitValue;
    private String templateCodeName;
    private String templateCodeValue;
    private String targetName;
    private String targetValue;
    private String exDimensionName;
    private List<String> exDimensionValue;

    public static QuerySchemaDebugDTO builderDebugByParams(List<String> partList) {
        QuerySchemaDebugDTO querySchemaDebugDTO = new QuerySchemaDebugDTO();
        try {
            if (CollectionUtils.isEmpty(partList)) {
                return querySchemaDebugDTO;
            }
            if (StringUtils.isNotEmpty((CharSequence)partList.get(0)) && (partList.get(0).equals("debug") || partList.get(0).equals("test"))) {
                querySchemaDebugDTO.setQuestion(partList.get(2));
            }
            if (partList.get(0).equals("metric")) {
                if (partList.size() > 2) {
                    querySchemaDebugDTO.setQuestion(partList.get(2));
                    querySchemaDebugDTO.setApplicationCode(partList.get(1));
                } else {
                    querySchemaDebugDTO.setQuestion(partList.get(1));
                }
            }
            querySchemaDebugDTO.setSceneCode(partList.get(1));
            partList.forEach(dto -> {
                if (dto.contains(":")) {
                    String[] parts = dto.split(":");
                    String key = parts[0];
                    String value = parts[1];
                    switch (key) {
                        case "time": {
                            String[] params;
                            String[] timeValue = parts[1].split("\\|");
                            if (timeValue.length < 1 || (params = timeValue[1].split("#")).length != 2) break;
                            querySchemaDebugDTO.setTimeName(timeValue[0]);
                            querySchemaDebugDTO.setTimeStart(params[0]);
                            querySchemaDebugDTO.setTimeEnd(params[1]);
                            break;
                        }
                        case "dimension": {
                            querySchemaDebugDTO.setDimensionName(key);
                            querySchemaDebugDTO.setDimensionValue(value);
                            break;
                        }
                        case "sort": {
                            String[] sortValue = parts[1].split("\\|");
                            if (sortValue.length < 1) break;
                            querySchemaDebugDTO.setSortName(sortValue[0]);
                            querySchemaDebugDTO.setSortValue(sortValue[1]);
                            break;
                        }
                        case "limit": {
                            querySchemaDebugDTO.setLimitName(key);
                            querySchemaDebugDTO.setLimitValue(value);
                            break;
                        }
                        case "exDimension": {
                            String[] exDimensions = parts[1].split("\\|");
                            querySchemaDebugDTO.setExDimensionName(key);
                            querySchemaDebugDTO.setExDimensionValue(Arrays.asList(exDimensions));
                            break;
                        }
                        case "templateCode": {
                            querySchemaDebugDTO.setTemplateCodeName(key);
                            querySchemaDebugDTO.setTemplateCodeValue(value);
                            break;
                        }
                        case "target": {
                            querySchemaDebugDTO.setTargetName(key);
                            querySchemaDebugDTO.setTargetValue(value);
                            break;
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"analysisQuestion", (String)TroubleToolCodeEnum.ADT_901_0107.getErrCode(), (String)JsonUtils.objectToString(partList), (String)TroubleToolCodeEnum.ADT_901_0107.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0107.getSuggestion());
        }
        LogUtils.buildAgileLog((String)"adt", (String)"analysisQuestion", (String)"1", (String)JsonUtils.objectToString(partList), (String)JsonUtils.objectToString((Object)querySchemaDebugDTO), (String)"");
        return querySchemaDebugDTO;
    }

    public static QuerySchemaDebugDTO builderParamByParams(List<String> partList) {
        QuerySchemaDebugDTO querySchemaDebugDTO = new QuerySchemaDebugDTO();
        try {
            if (CollectionUtils.isEmpty(partList)) {
                return querySchemaDebugDTO;
            }
            if (StringUtils.isNotEmpty((CharSequence)partList.get(0))) {
                if (partList.size() > 1) {
                    querySchemaDebugDTO.setQuestion(partList.get(1));
                }
                if (partList.size() > 2) {
                    querySchemaDebugDTO.setSceneCode(partList.size() > 2 ? partList.get(2) : null);
                }
            }
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"analysisQuestion", (String)TroubleToolCodeEnum.ADT_901_0108.getErrCode(), (String)JsonUtils.objectToString(partList), (String)TroubleToolCodeEnum.ADT_901_0108.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0108.getSuggestion());
        }
        LogUtils.buildAgileLog((String)"adt", (String)"analysisQuestion", (String)"1", (String)JsonUtils.objectToString(partList), (String)JsonUtils.objectToString((Object)querySchemaDebugDTO), (String)"");
        return querySchemaDebugDTO;
    }

    public String getSceneCode() {
        return this.sceneCode;
    }

    public String getApplicationCode() {
        return this.applicationCode;
    }

    public String getQuestion() {
        return this.question;
    }

    public String getDimensionName() {
        return this.dimensionName;
    }

    public String getDimensionValue() {
        return this.dimensionValue;
    }

    public String getTimeName() {
        return this.timeName;
    }

    public String getTimeStart() {
        return this.timeStart;
    }

    public String getTimeEnd() {
        return this.timeEnd;
    }

    public String getSortName() {
        return this.sortName;
    }

    public String getSortValue() {
        return this.sortValue;
    }

    public String getLimitName() {
        return this.limitName;
    }

    public String getLimitValue() {
        return this.limitValue;
    }

    public String getTemplateCodeName() {
        return this.templateCodeName;
    }

    public String getTemplateCodeValue() {
        return this.templateCodeValue;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getTargetValue() {
        return this.targetValue;
    }

    public String getExDimensionName() {
        return this.exDimensionName;
    }

    public List<String> getExDimensionValue() {
        return this.exDimensionValue;
    }

    public void setSceneCode(String sceneCode) {
        this.sceneCode = sceneCode;
    }

    public void setApplicationCode(String applicationCode) {
        this.applicationCode = applicationCode;
    }

    public void setQuestion(String question2) {
        this.question = question2;
    }

    public void setDimensionName(String dimensionName) {
        this.dimensionName = dimensionName;
    }

    public void setDimensionValue(String dimensionValue) {
        this.dimensionValue = dimensionValue;
    }

    public void setTimeName(String timeName) {
        this.timeName = timeName;
    }

    public void setTimeStart(String timeStart) {
        this.timeStart = timeStart;
    }

    public void setTimeEnd(String timeEnd) {
        this.timeEnd = timeEnd;
    }

    public void setSortName(String sortName) {
        this.sortName = sortName;
    }

    public void setSortValue(String sortValue) {
        this.sortValue = sortValue;
    }

    public void setLimitName(String limitName) {
        this.limitName = limitName;
    }

    public void setLimitValue(String limitValue) {
        this.limitValue = limitValue;
    }

    public void setTemplateCodeName(String templateCodeName) {
        this.templateCodeName = templateCodeName;
    }

    public void setTemplateCodeValue(String templateCodeValue) {
        this.templateCodeValue = templateCodeValue;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public void setTargetValue(String targetValue) {
        this.targetValue = targetValue;
    }

    public void setExDimensionName(String exDimensionName) {
        this.exDimensionName = exDimensionName;
    }

    public void setExDimensionValue(List<String> exDimensionValue) {
        this.exDimensionValue = exDimensionValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuerySchemaDebugDTO)) {
            return false;
        }
        QuerySchemaDebugDTO other = (QuerySchemaDebugDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$sceneCode = this.getSceneCode();
        String other$sceneCode = other.getSceneCode();
        if (this$sceneCode == null ? other$sceneCode != null : !this$sceneCode.equals(other$sceneCode)) {
            return false;
        }
        String this$applicationCode = this.getApplicationCode();
        String other$applicationCode = other.getApplicationCode();
        if (this$applicationCode == null ? other$applicationCode != null : !this$applicationCode.equals(other$applicationCode)) {
            return false;
        }
        String this$question = this.getQuestion();
        String other$question = other.getQuestion();
        if (this$question == null ? other$question != null : !this$question.equals(other$question)) {
            return false;
        }
        String this$dimensionName = this.getDimensionName();
        String other$dimensionName = other.getDimensionName();
        if (this$dimensionName == null ? other$dimensionName != null : !this$dimensionName.equals(other$dimensionName)) {
            return false;
        }
        String this$dimensionValue = this.getDimensionValue();
        String other$dimensionValue = other.getDimensionValue();
        if (this$dimensionValue == null ? other$dimensionValue != null : !this$dimensionValue.equals(other$dimensionValue)) {
            return false;
        }
        String this$timeName = this.getTimeName();
        String other$timeName = other.getTimeName();
        if (this$timeName == null ? other$timeName != null : !this$timeName.equals(other$timeName)) {
            return false;
        }
        String this$timeStart = this.getTimeStart();
        String other$timeStart = other.getTimeStart();
        if (this$timeStart == null ? other$timeStart != null : !this$timeStart.equals(other$timeStart)) {
            return false;
        }
        String this$timeEnd = this.getTimeEnd();
        String other$timeEnd = other.getTimeEnd();
        if (this$timeEnd == null ? other$timeEnd != null : !this$timeEnd.equals(other$timeEnd)) {
            return false;
        }
        String this$sortName = this.getSortName();
        String other$sortName = other.getSortName();
        if (this$sortName == null ? other$sortName != null : !this$sortName.equals(other$sortName)) {
            return false;
        }
        String this$sortValue = this.getSortValue();
        String other$sortValue = other.getSortValue();
        if (this$sortValue == null ? other$sortValue != null : !this$sortValue.equals(other$sortValue)) {
            return false;
        }
        String this$limitName = this.getLimitName();
        String other$limitName = other.getLimitName();
        if (this$limitName == null ? other$limitName != null : !this$limitName.equals(other$limitName)) {
            return false;
        }
        String this$limitValue = this.getLimitValue();
        String other$limitValue = other.getLimitValue();
        if (this$limitValue == null ? other$limitValue != null : !this$limitValue.equals(other$limitValue)) {
            return false;
        }
        String this$templateCodeName = this.getTemplateCodeName();
        String other$templateCodeName = other.getTemplateCodeName();
        if (this$templateCodeName == null ? other$templateCodeName != null : !this$templateCodeName.equals(other$templateCodeName)) {
            return false;
        }
        String this$templateCodeValue = this.getTemplateCodeValue();
        String other$templateCodeValue = other.getTemplateCodeValue();
        if (this$templateCodeValue == null ? other$templateCodeValue != null : !this$templateCodeValue.equals(other$templateCodeValue)) {
            return false;
        }
        String this$targetName = this.getTargetName();
        String other$targetName = other.getTargetName();
        if (this$targetName == null ? other$targetName != null : !this$targetName.equals(other$targetName)) {
            return false;
        }
        String this$targetValue = this.getTargetValue();
        String other$targetValue = other.getTargetValue();
        if (this$targetValue == null ? other$targetValue != null : !this$targetValue.equals(other$targetValue)) {
            return false;
        }
        String this$exDimensionName = this.getExDimensionName();
        String other$exDimensionName = other.getExDimensionName();
        if (this$exDimensionName == null ? other$exDimensionName != null : !this$exDimensionName.equals(other$exDimensionName)) {
            return false;
        }
        List this$exDimensionValue = this.getExDimensionValue();
        List other$exDimensionValue = other.getExDimensionValue();
        return !(this$exDimensionValue == null ? other$exDimensionValue != null : !((Object)this$exDimensionValue).equals(other$exDimensionValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QuerySchemaDebugDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sceneCode = this.getSceneCode();
        result = result * 59 + ($sceneCode == null ? 43 : $sceneCode.hashCode());
        String $applicationCode = this.getApplicationCode();
        result = result * 59 + ($applicationCode == null ? 43 : $applicationCode.hashCode());
        String $question = this.getQuestion();
        result = result * 59 + ($question == null ? 43 : $question.hashCode());
        String $dimensionName = this.getDimensionName();
        result = result * 59 + ($dimensionName == null ? 43 : $dimensionName.hashCode());
        String $dimensionValue = this.getDimensionValue();
        result = result * 59 + ($dimensionValue == null ? 43 : $dimensionValue.hashCode());
        String $timeName = this.getTimeName();
        result = result * 59 + ($timeName == null ? 43 : $timeName.hashCode());
        String $timeStart = this.getTimeStart();
        result = result * 59 + ($timeStart == null ? 43 : $timeStart.hashCode());
        String $timeEnd = this.getTimeEnd();
        result = result * 59 + ($timeEnd == null ? 43 : $timeEnd.hashCode());
        String $sortName = this.getSortName();
        result = result * 59 + ($sortName == null ? 43 : $sortName.hashCode());
        String $sortValue = this.getSortValue();
        result = result * 59 + ($sortValue == null ? 43 : $sortValue.hashCode());
        String $limitName = this.getLimitName();
        result = result * 59 + ($limitName == null ? 43 : $limitName.hashCode());
        String $limitValue = this.getLimitValue();
        result = result * 59 + ($limitValue == null ? 43 : $limitValue.hashCode());
        String $templateCodeName = this.getTemplateCodeName();
        result = result * 59 + ($templateCodeName == null ? 43 : $templateCodeName.hashCode());
        String $templateCodeValue = this.getTemplateCodeValue();
        result = result * 59 + ($templateCodeValue == null ? 43 : $templateCodeValue.hashCode());
        String $targetName = this.getTargetName();
        result = result * 59 + ($targetName == null ? 43 : $targetName.hashCode());
        String $targetValue = this.getTargetValue();
        result = result * 59 + ($targetValue == null ? 43 : $targetValue.hashCode());
        String $exDimensionName = this.getExDimensionName();
        result = result * 59 + ($exDimensionName == null ? 43 : $exDimensionName.hashCode());
        List $exDimensionValue = this.getExDimensionValue();
        result = result * 59 + ($exDimensionValue == null ? 43 : ((Object)$exDimensionValue).hashCode());
        return result;
    }

    public String toString() {
        return "QuerySchemaDebugDTO(sceneCode=" + this.getSceneCode() + ", applicationCode=" + this.getApplicationCode() + ", question=" + this.getQuestion() + ", dimensionName=" + this.getDimensionName() + ", dimensionValue=" + this.getDimensionValue() + ", timeName=" + this.getTimeName() + ", timeStart=" + this.getTimeStart() + ", timeEnd=" + this.getTimeEnd() + ", sortName=" + this.getSortName() + ", sortValue=" + this.getSortValue() + ", limitName=" + this.getLimitName() + ", limitValue=" + this.getLimitValue() + ", templateCodeName=" + this.getTemplateCodeName() + ", templateCodeValue=" + this.getTemplateCodeValue() + ", targetName=" + this.getTargetName() + ", targetValue=" + this.getTargetValue() + ", exDimensionName=" + this.getExDimensionName() + ", exDimensionValue=" + this.getExDimensionValue() + ")";
    }
}

