/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.domain.echo.impl;

import com.digiwin.athena.adt.agileReport.constant.ErrorCodeEnum;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.domain.dto.AgileDataFileShowDTO;
import com.digiwin.athena.adt.domain.dto.SnapDataInfoDTO;
import com.digiwin.athena.adt.domain.dto.aiBoard.AIBoardDTO;
import com.digiwin.athena.adt.domain.dto.autoData.AgileDataAutoDataDTO;
import com.digiwin.athena.adt.domain.dto.echo.AgileDataFileDTO;
import com.digiwin.athena.adt.domain.dto.echo.EchoSubmitReq;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Service
public class EchoServiceImpl
implements EchoService {
    private static final Logger log = LoggerFactory.getLogger(EchoServiceImpl.class);
    @Autowired(required=false)
    private RestTemplate restTemplate;
    @Value(value="${agiledataecho.url:}")
    private String echoUrl;

    public void echoSubmit(EchoSubmitReq echoSubmitReq, String token, String tenantId) {
        long getQuerySchemaTook = System.currentTimeMillis();
        LogDto logDto = new LogDto("\u4e0a\u62a5echo \u4e1a\u52a1\u65e5\u5fd7 \u5165\u53c2 echoSubmit :{} ", JsonUtils.objectToString((Object)echoSubmitReq));
        log.info(logDto.toString());
        String url = this.echoUrl + "/api/ai/agile/echo/exception/submit";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", token);
        headers.set("Routerkey", tenantId);
        HttpEntity httpEntity = new HttpEntity((Object)echoSubmitReq, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LogDto logReturnDto = new LogDto("\u4e0a\u62a5echo \u4e1a\u52a1\u65e5\u5fd7 \u8fd4\u53c2\uff1a" + response);
            log.info(logReturnDto.toString());
        }
        catch (ResourceAccessException e) {
            log.error("agiledata_ADT_ :\u8017\u65f6:{},\u95ee\u9898\u4f4d\u7f6e:{},\u95ee\u9898\u63cf\u8ff0:{},\u9519\u8bef\u5185\u5bb9:{},\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\u5bfc:{}", new Object[]{System.currentTimeMillis() - getQuerySchemaTook, "\u654f\u6377\u6570\u636e\u52a9\u7406\u5165\u53e3(ADT)->\u4e0a\u62a5echo \u4e1a\u52a1\u65e5\u5fd7(ECHO) echoSubmit", "\u8c03\u7528ADE\u63a5\u53e3\u8d85\u65f6 ResourceAccessException", JsonUtils.objectToString((Object)echoSubmitReq), "\u8bf7\u8054\u7cfb\u5e73\u53f0\u5904\u7406"});
            throw ErrorCodeEnum.ECHO_REALTIME_FAIL.getBusinessException();
        }
        catch (Exception e) {
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.ECHO_GET_FAIL.getErrCode(), JsonUtils.objectToString((Object)echoSubmitReq), e.getMessage()});
            throw ErrorCodeEnum.ECHO_GET_FAIL.getBusinessException();
        }
    }

    public void echoMongodbSubmit(EchoSubmitReq echoSubmitReq, String token, String tenantId) {
        long getQuerySchemaTook = System.currentTimeMillis();
        LogDto logDto = new LogDto("\u4e0a\u62a5echo mongodb \u5165\u53c2 echoSubmitReq :{} ", JsonUtils.objectToString((Object)echoSubmitReq));
        log.info(logDto.toString());
        String url = this.echoUrl + "/api/ai/agile/echo/exception/mongo/submit";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", token);
        headers.set("Routerkey", tenantId);
        HttpEntity httpEntity = new HttpEntity((Object)echoSubmitReq, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LogDto logReturnDto = new LogDto("\u4e0a\u62a5echo mongodb \u8fd4\u53c2\uff1a" + response);
            log.info(logReturnDto.toString());
        }
        catch (ResourceAccessException e) {
            log.error("agiledata_ADT_ :\u8017\u65f6:{},\u95ee\u9898\u4f4d\u7f6e:{},\u95ee\u9898\u63cf\u8ff0:{},\u9519\u8bef\u5185\u5bb9:{},\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\u5bfc:{}", new Object[]{System.currentTimeMillis() - getQuerySchemaTook, "\u654f\u6377\u6570\u636e\u52a9\u7406\u5165\u53e3(ADT)->\u4e0a\u62a5echo \u4e1a\u52a1\u65e5\u5fd7(ECHO) echoMongodbSubmit", "\u8c03\u7528ADE\u63a5\u53e3\u8d85\u65f6 ResourceAccessException", JsonUtils.objectToString((Object)echoSubmitReq), "\u8bf7\u8054\u7cfb\u5e73\u53f0\u5904\u7406"});
            throw ErrorCodeEnum.ECHO_REALTIME_FAIL.getBusinessException();
        }
        catch (Exception e) {
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.ECHO_GET_FAIL.getErrCode(), JsonUtils.objectToString((Object)echoSubmitReq), e.getMessage()});
            throw ErrorCodeEnum.ECHO_GET_FAIL.getBusinessException();
        }
    }

    public Boolean echoChangeCharging(String token, String tenantId) {
        String url = this.echoUrl + "/api/ai/agile/echo/lite/changeCharging";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", token);
        headers.set("Routerkey", tenantId);
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LogDto logReturnDto = new LogDto("lite\u7248\u672c\u4f53\u9a8c\u6b21\u6570\u6263\u51cf \u8fd4\u53c2\uff1a" + response);
            log.info(logReturnDto.toString());
            return (Boolean)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"liteDeduction", (String)TroubleToolCodeEnum.ADT_901_0120.getErrCode(), (String)JsonUtils.objectToString((Object)tenantId), (String)TroubleToolCodeEnum.ADT_901_0120.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0120.getSuggestion());
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.ECHO_GET_FAIL.getErrCode(), tenantId, e.getMessage()});
            return false;
        }
    }

    public void sendMetricDebugMessage(Map<String, Object> request, String token, String tenantId) {
        long getQuerySchemaTook = System.currentTimeMillis();
        LogDto logDto = new LogDto("metric debug \u4e0a\u62a5\u6d88\u606f :{} ", JsonUtils.objectToString(request));
        log.info(logDto.toString());
        String url = this.echoUrl + "/api/ai/agile/echo/exception/mongo/metric/check";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", token);
        headers.set("Routerkey", tenantId);
        HttpEntity httpEntity = new HttpEntity(request, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LogDto logReturnDto = new LogDto("metric debug \u4e0a\u62a5\u6d88\u606f \u8fd4\u53c2\uff1a" + response);
            log.info(logReturnDto.toString());
            LogUtils.buildAgileLog((String)"adt", (String)"debugInfo", (String)"1", (String)JsonUtils.objectToString(request), (String)JsonUtils.objectToString((Object)response), (String)"");
        }
        catch (ResourceAccessException e) {
            LogUtils.buildAgileLog((String)"adt", (String)"debugInfo", (String)TroubleToolCodeEnum.ADT_901_0125.getErrCode(), (String)JsonUtils.objectToString(request), (String)TroubleToolCodeEnum.ADT_901_0125.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0125.getSuggestion());
            log.error("agiledata_ADT_ :\u8017\u65f6:{},\u95ee\u9898\u4f4d\u7f6e:{},\u95ee\u9898\u63cf\u8ff0:{},\u9519\u8bef\u5185\u5bb9:{},\u53ef\u80fd\u539f\u56e0\u53ca\u6392\u9519\u6307\u5f15\u5bfc:{}", new Object[]{System.currentTimeMillis() - getQuerySchemaTook, "\u654f\u6377\u6570\u636e\u52a9\u7406\u5165\u53e3(ADT)->\u4e0a\u62a5echo \u4e1a\u52a1\u65e5\u5fd7(ECHO) echoMongodbSubmit", "\u8c03\u7528ADE\u63a5\u53e3\u8d85\u65f6 ResourceAccessException", JsonUtils.objectToString(request), "\u8bf7\u8054\u7cfb\u5e73\u53f0\u5904\u7406"});
            throw ErrorCodeEnum.ECHO_REALTIME_FAIL.getBusinessException();
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"debugInfo", (String)TroubleToolCodeEnum.ADT_901_0124.getErrCode(), (String)JsonUtils.objectToString(request), (String)TroubleToolCodeEnum.ADT_901_0124.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0124.getSuggestion());
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.ECHO_GET_FAIL.getErrCode(), JsonUtils.objectToString(request), e.getMessage()});
            throw ErrorCodeEnum.ECHO_GET_FAIL.getBusinessException();
        }
    }

    public Boolean addAgileDataFile(AgileDataFileDTO agileDataFileDTO, String token, String tenantId) {
        String url = this.echoUrl + "/api/ai/v1/file/addAgileDataFile";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", token);
        headers.set("Routerkey", tenantId);
        HttpEntity httpEntity = new HttpEntity((Object)agileDataFileDTO, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LogDto logReturnDto = new LogDto("ppt\u95ee\u53e5\u5206\u6790\u65b0\u589e \u8fd4\u53c2\uff1a" + response);
            log.info(logReturnDto.toString());
            return (Boolean)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"pptAnalyzeADD", (String)TroubleToolCodeEnum.ADT_901_0120.getErrCode(), (String)JsonUtils.objectToString((Object)tenantId), (String)TroubleToolCodeEnum.ADT_901_0120.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0120.getSuggestion());
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.ECHO_GET_FAIL.getErrCode(), tenantId, e.getMessage()});
            return false;
        }
    }

    public Boolean updateAgileDataFile(AgileDataFileDTO agileDataFileDTO, String token, String tenantId) {
        String url = this.echoUrl + "/api/ai/v1/file/updateAgileDataFile";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", token);
        headers.set("Routerkey", tenantId);
        HttpEntity httpEntity = new HttpEntity((Object)agileDataFileDTO, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LogDto logReturnDto = new LogDto("ppt\u95ee\u53e5\u5206\u6790\u65b0\u589e \u8fd4\u53c2\uff1a" + response);
            log.info(logReturnDto.toString());
            return (Boolean)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"pptAnalyzeADD", (String)TroubleToolCodeEnum.ADT_901_0120.getErrCode(), (String)JsonUtils.objectToString((Object)tenantId), (String)TroubleToolCodeEnum.ADT_901_0120.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0120.getSuggestion());
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.ECHO_GET_FAIL.getErrCode(), tenantId, e.getMessage()});
            return false;
        }
    }

    public AgileDataFileDTO getAgileDataFile(Map<String, Object> params, String token, String tenantId) {
        String url = this.echoUrl + "/api/ai/v1/file/getAgileDataFile";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", token);
        headers.set("Routerkey", tenantId);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LogDto logReturnDto = new LogDto("ppt\u83b7\u53d6\u5206\u6790\u7ed3\u679c \u8fd4\u53c2\uff1a" + JsonUtils.objectToString((Object)((BaseResultDTO)response.getBody()).getResponse()));
            log.info(logReturnDto.toString());
            return (AgileDataFileDTO)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"pptAnalyzeGet", (String)TroubleToolCodeEnum.ADT_901_0120.getErrCode(), (String)JsonUtils.objectToString((Object)tenantId), (String)TroubleToolCodeEnum.ADT_901_0120.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0120.getSuggestion());
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.ECHO_GET_FAIL.getErrCode(), tenantId, e.getMessage()});
            return null;
        }
    }

    public Boolean deleteAgileDataFile(Map<String, Object> params, String token, String tenantId) {
        String url = this.echoUrl + "/api/ai/v1/file/deleteAgileDataFile";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", token);
        headers.set("Routerkey", tenantId);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LogDto logReturnDto = new LogDto("ppt\u95ee\u53e5\u5206\u6790\u5220\u9664 \u8fd4\u53c2\uff1a" + response);
            log.info(logReturnDto.toString());
            return (Boolean)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"pptAnalyzeDelete", (String)TroubleToolCodeEnum.ADT_901_0120.getErrCode(), (String)JsonUtils.objectToString((Object)tenantId), (String)TroubleToolCodeEnum.ADT_901_0120.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0120.getSuggestion());
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.ECHO_GET_FAIL.getErrCode(), tenantId, e.getMessage()});
            return false;
        }
    }

    public AgileDataFileShowDTO getAgileDataFileShow(Map<String, Object> params, String token, String tenantId) {
        String url = this.echoUrl + "/api/ai/v1/agile/standard/agileDataStandard/show";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", token);
        headers.set("Routerkey", tenantId);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LogDto logReturnDto = new LogDto("ppt\u83b7\u53d6\u5448\u73b0\u7ed3\u6784 \u8fd4\u53c2\uff1a" + JsonUtils.objectToString((Object)((BaseResultDTO)response.getBody()).getResponse()));
            log.info(logReturnDto.toString());
            return (AgileDataFileShowDTO)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"pptAnalyzeGet", (String)TroubleToolCodeEnum.ADT_901_0120.getErrCode(), (String)JsonUtils.objectToString((Object)tenantId), (String)TroubleToolCodeEnum.ADT_901_0120.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0120.getSuggestion());
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.ECHO_GET_FAIL.getErrCode(), tenantId, e.getMessage()});
            return null;
        }
    }

    public Boolean updateAutoDataReport(AuthoredUser authoredUser, AgileDataAutoDataDTO agileDataAutoDataDTO) {
        String url = this.echoUrl + "/api/ai/agile/echo/autoData/updateReport";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", authoredUser.getToken());
        headers.set("Routerkey", authoredUser.getTenantId());
        HttpEntity httpEntity = new HttpEntity((Object)agileDataAutoDataDTO, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LogDto logReturnDto = new LogDto("autoData\u5206\u6790\u5e08\u66f4\u65b0 \u8fd4\u53c2\uff1a" + response);
            log.info(logReturnDto.toString());
            return (Boolean)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"autoDataReportUpdate", (String)TroubleToolCodeEnum.ADT_901_0120.getErrCode(), (String)JsonUtils.objectToString((Object)authoredUser.getTenantId()), (String)TroubleToolCodeEnum.ADT_901_0120.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0120.getSuggestion());
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.ECHO_GET_FAIL.getErrCode(), authoredUser.getTenantId(), e.getMessage()});
            return false;
        }
    }

    public AgileDataAutoDataDTO getAutoDataReport(AuthoredUser authoredUser, AgileDataAutoDataDTO autoDataDTO) {
        String url = this.echoUrl + "/api/ai/agile/echo/autoData/getReport";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", authoredUser.getToken());
        headers.set("Routerkey", authoredUser.getTenantId());
        HttpEntity httpEntity = new HttpEntity((Object)autoDataDTO, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LogDto logReturnDto = new LogDto("autoData\u5206\u6790\u5e08\u83b7\u53d6\u5df2\u5b8c\u6210\u62a5\u544a \u8fd4\u53c2\uff1a" + JsonUtils.objectToString((Object)((BaseResultDTO)response.getBody()).getResponse()));
            log.info(logReturnDto.toString());
            return (AgileDataAutoDataDTO)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"autoDataReport", (String)TroubleToolCodeEnum.ADT_901_0120.getErrCode(), (String)JsonUtils.objectToString((Object)authoredUser.getTenantId()), (String)TroubleToolCodeEnum.ADT_901_0120.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0120.getSuggestion());
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.ECHO_GET_FAIL.getErrCode(), authoredUser.getTenantId(), e.getMessage()});
            return null;
        }
    }

    public Boolean saveAutoDataReport(AuthoredUser authoredUser, AgileDataAutoDataDTO agileDataAutoDataDTO) {
        String url = this.echoUrl + "/api/ai/agile/echo/autoData/saveReport";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", authoredUser.getToken());
        headers.set("Routerkey", authoredUser.getTenantId());
        HttpEntity httpEntity = new HttpEntity((Object)agileDataAutoDataDTO, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LogDto logReturnDto = new LogDto("autoData\u5206\u6790\u5e08\u4fdd\u5b58 \u8fd4\u53c2\uff1a" + response);
            log.info(logReturnDto.toString());
            return (Boolean)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"saveAutoDataReport", (String)TroubleToolCodeEnum.ADT_901_0120.getErrCode(), (String)JsonUtils.objectToString((Object)authoredUser.getTenantId()), (String)TroubleToolCodeEnum.ADT_901_0120.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0120.getSuggestion());
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.ECHO_GET_FAIL.getErrCode(), authoredUser.getTenantId(), e.getMessage()});
            return false;
        }
    }

    public Boolean updateAIBoard(AIBoardDTO aiBoardDTO, String token, String tenantId) {
        String url = this.echoUrl + "/api/ai/agile/echo/aiBoard/updateBoard";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", token);
        headers.set("Routerkey", tenantId);
        HttpEntity httpEntity = new HttpEntity((Object)aiBoardDTO, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LogDto logReturnDto = new LogDto("\u5bf9\u8bdd\u770b\u677f\u66f4\u65b0 \u8fd4\u53c2\uff1a" + JsonUtils.objectToString((Object)response));
            log.info(logReturnDto.toString());
            return (Boolean)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"aiBoardADD", (String)TroubleToolCodeEnum.ADT_901_0120.getErrCode(), (String)JsonUtils.objectToString((Object)tenantId), (String)TroubleToolCodeEnum.ADT_901_0120.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0120.getSuggestion());
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.ECHO_GET_FAIL.getErrCode(), tenantId, e.getMessage()});
            return false;
        }
    }

    public AIBoardDTO getAIBoard(Map<String, Object> params, String token, String tenantId) {
        String url = this.echoUrl + "/api/ai/agile/echo/aiBoard/getBoard";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", token);
        headers.set("Routerkey", tenantId);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LogDto logReturnDto = new LogDto("\u5bf9\u8bdd\u770b\u677f\u83b7\u53d6 \u8fd4\u53c2\uff1a" + JsonUtils.objectToString((Object)((BaseResultDTO)response.getBody()).getResponse()));
            log.info(logReturnDto.toString());
            return (AIBoardDTO)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"autoDataReport", (String)TroubleToolCodeEnum.ADT_901_0120.getErrCode(), (String)tenantId, (String)TroubleToolCodeEnum.ADT_901_0120.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0120.getSuggestion());
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.ECHO_GET_FAIL.getErrCode(), tenantId, e.getMessage()});
            return null;
        }
    }

    public Boolean deleteAIBoard(Map<String, Object> params, String token, String tenantId) {
        String url = this.echoUrl + "/api/ai/agile/echo/aiBoard/deleteBoard";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", token);
        headers.set("Routerkey", tenantId);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LogDto logReturnDto = new LogDto("\u5bf9\u8bdd\u770b\u677f\u5220\u9664 \u8fd4\u53c2\uff1a" + response);
            log.info(logReturnDto.toString());
            return (Boolean)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"aiBoardDelete", (String)TroubleToolCodeEnum.ADT_901_0120.getErrCode(), (String)JsonUtils.objectToString((Object)tenantId), (String)TroubleToolCodeEnum.ADT_901_0120.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0120.getSuggestion());
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.ECHO_GET_FAIL.getErrCode(), tenantId, e.getMessage()});
            return false;
        }
    }

    public Boolean addAIBoard(AIBoardDTO aiBoardDTO, String token, String tenantId) {
        String url = this.echoUrl + "/api/ai/agile/echo/aiBoard/saveBoard";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", token);
        headers.set("Routerkey", tenantId);
        HttpEntity httpEntity = new HttpEntity((Object)aiBoardDTO, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LogDto logReturnDto = new LogDto("\u5bf9\u8bdd\u770b\u677f\u65b0\u589e \u8fd4\u53c2\uff1a" + response);
            log.info(logReturnDto.toString());
            return (Boolean)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"aiBoardADD", (String)TroubleToolCodeEnum.ADT_901_0120.getErrCode(), (String)JsonUtils.objectToString((Object)tenantId), (String)TroubleToolCodeEnum.ADT_901_0120.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0120.getSuggestion());
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.ECHO_GET_FAIL.getErrCode(), tenantId, e.getMessage()});
            return false;
        }
    }

    public Integer getSceneShowType(SnapDataInfoDTO snapDataInfoDTO, String token, String tenantId) {
        String url = this.echoUrl + "/api/ai/v1/agile/getSceneShowType";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", token);
        headers.set("Routerkey", tenantId);
        HttpEntity httpEntity = new HttpEntity((Object)snapDataInfoDTO, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            LogDto logReturnDto = new LogDto("\u83b7\u53d6\u573a\u666f\u5448\u73b0\u7c7b\u578b \u8fd4\u53c2\uff1a" + response);
            log.info(logReturnDto.toString());
            return (Integer)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"getSceneShowType", (String)TroubleToolCodeEnum.ADT_901_0120.getErrCode(), (String)JsonUtils.objectToString((Object)tenantId), (String)TroubleToolCodeEnum.ADT_901_0120.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0120.getSuggestion());
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.ECHO_GET_FAIL.getErrCode(), tenantId, e.getMessage()});
            return null;
        }
    }
}

