/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.domain.report.impl;

import cn.hutool.json.JSONObject;
import com.digiwin.athena.adt.agileReport.constant.AgileDataSourceEnum;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataDetailUrlDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataEngineFileDownModel;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataSummarizeReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataSummarizeResDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AnalysisAttributionReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AnalysisAttributionResDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AnalysisFluctuateReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AnalysisFluctuateResDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AniaAssistantChatReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AthenaMessageDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.ChatReqAIBoardDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.ChatReqPPTReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.excel.ExcelSheet;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataMessageService;
import com.digiwin.athena.adt.agileReport.service.AgileDataSnapRelationMappingService;
import com.digiwin.athena.adt.agileReport.service.ModulePermissionService;
import com.digiwin.athena.adt.agileReport.service.SnapShotDataService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.app.config.executor.ExecutorConfig;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.adt.domain.chatbi.ChatbiService;
import com.digiwin.athena.adt.domain.dmc.DmcService;
import com.digiwin.athena.adt.domain.dto.AgileDataPanelResDTO;
import com.digiwin.athena.adt.domain.dto.UploadAttachmentResp;
import com.digiwin.athena.adt.domain.dto.UploadParamDTO;
import com.digiwin.athena.adt.domain.dto.ade.AdeAnalysisAttributionReqDTO;
import com.digiwin.athena.adt.domain.dto.ade.AdeAnalysisAttributionResDTO;
import com.digiwin.athena.adt.domain.dto.ade.AdeDatasetReqDTO;
import com.digiwin.athena.adt.domain.dto.agileDataProcess.AgileDataMCPDTO;
import com.digiwin.athena.adt.domain.dto.agileDataProcess.AgileDataPanelResult;
import com.digiwin.athena.adt.domain.dto.agileDataProcess.AgileDataProcessResDTO;
import com.digiwin.athena.adt.domain.dto.agileDataProcess.AgileFilterProcessResDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.BizParamsDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.ContextDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.PullDataDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.aiBoard.AIBoardDTO;
import com.digiwin.athena.adt.domain.dto.echo.AgileDataFileDTO;
import com.digiwin.athena.adt.domain.dto.km.KMCollectStepResDTO;
import com.digiwin.athena.adt.domain.dto.km.KMDatasetCommandIntentionsResDTO;
import com.digiwin.athena.adt.domain.dto.km.ThemeMapBoardDTO;
import com.digiwin.athena.adt.domain.dto.mongo.AgileDataSummarizeMsg;
import com.digiwin.athena.adt.domain.dto.schema.SchemaAnalysisAttributionResDTO;
import com.digiwin.athena.adt.domain.dto.schema.SchemaFluctuateResDTO;
import com.digiwin.athena.adt.domain.dto.schema.SchemaMetricShowDefine;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.file.FileParsingService;
import com.digiwin.athena.adt.domain.knowledge.KmService;
import com.digiwin.athena.adt.domain.report.AgileReportDataService;
import com.digiwin.athena.adt.domain.report.impl.AgileReportProcessServiceImpl;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.domain.uibot.UIBOTService;
import com.digiwin.athena.adt.sse.api.SSEManagerService;
import com.digiwin.athena.adt.sse.domain.EventData;
import com.digiwin.athena.adt.sse.domain.SseAniaEventEnum;
import com.digiwin.athena.adt.sse.dto.SSEBaseEvent;
import com.digiwin.athena.adt.sse.utils.SseEmitterUtils;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.adt.util.agileData.AgileDataSnapShotUtils;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.atmc.http.restful.iam.UserService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.AsyncEventBus;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Service
public class AgileReportProcessServiceImpl
extends AbsAgileDataProcess
implements AgileReportDataService {
    private static final Logger log = LoggerFactory.getLogger(AgileReportProcessServiceImpl.class);
    @Autowired
    private AsyncEventBus localEventBus;
    @Resource
    private UIBOTService uibotService;
    @Autowired
    private AgileDataMessageService agileDataMessageService;
    @Resource
    private SSEManagerService sseManagerService;
    @Autowired
    private ExecutorConfig executorConfig;
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy/MM/dd HH:mm:ss";
    @Autowired
    private SnapShotDataService snapShotDataService;
    @Autowired
    private MessageUtil messageUtil;
    @Autowired
    private FileParsingService fileParsingService;
    @Autowired
    private DmcService dmcService;
    @Autowired
    private ChatbiService chatbiService;
    @Autowired
    private KmService kmService;
    @Autowired
    @Qualifier(value="mongoAgileDataLogTemplate")
    private MongoTemplate mongoTemplate;
    @Resource
    private ADEService adeService;
    @Autowired
    private AgileDataSnapRelationMappingService agileDataSnapRelationMappingService;
    @Autowired
    private UserService userService;
    @Autowired
    private EchoService echoService;
    @Autowired
    @Qualifier(value="asyncServiceExecutor")
    private ExecutorService executor;
    @Autowired
    private ModulePermissionService modulePermissionService;
    @Autowired
    private SemcService semcService;

    public String processSDData(String processData, String fileName, AuthoredUser user) {
        UploadParamDTO uploadParamDTO = new UploadParamDTO();
        uploadParamDTO.setFileJson(processData);
        uploadParamDTO.setFileName(fileName);
        UploadAttachmentResp uploadAttachmentResp = this.dmcService.uploadAgileData(uploadParamDTO, user);
        return uploadAttachmentResp.getId();
    }

    public Map<String, String> processMessage(HttpServletRequest request, AthenaMessageDTO athenaMessageDTO, AuthoredUser user) {
        LogUtils.buildAgileLog((String)"adt", (String)"receiveQuestion", (String)"1", (String)JsonUtils.objectToString((Object)athenaMessageDTO), (String)"\u5a1c\u5a1c\u95ee\u53e5\u8bf7\u6c42", (String)"");
        HashMap<String, String> resultType = new HashMap<String, String>();
        if (athenaMessageDTO.getMsgType() == null || athenaMessageDTO.getMsgBody().isEmpty()) {
            resultType.put("resultType", "NOTSUPPORT");
        }
        AthenaMessageEvent event = this.init(request, athenaMessageDTO, user);
        this.localEventBus.post((Object)event);
        resultType.put("resultType", "PROCESS");
        return resultType;
    }

    public SnapShotDTO getAgileReportInfo(String dmcId) {
        return this.dmcService.getAgileData(dmcId);
    }

    public void compensateAgileData(SnapShotDTO snapShotDTO) {
        if (CollectionUtils.isNotEmpty((Collection)snapShotDTO.getContext().getPullData())) {
            snapShotDTO.getContext().getPullData().stream().forEach(pullDataDTO -> {
                Map computeMap = (Map)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)pullDataDTO), Map.class);
                computeMap.put("method", snapShotDTO.getContext().getBizParams().getMethod());
                computeMap.put("showDefine", snapShotDTO.getContext().getBizParams().getShowDefine());
                Map dataMap = this.uibotService.compensateAgileData(computeMap);
                if (MapUtils.isNotEmpty((Map)dataMap)) {
                    pullDataDTO.setData(dataMap);
                }
            });
        }
    }

    public AgileDataPanelResDTO panelProcessMessage(HttpServletRequest request, AthenaMessageDTO req, AuthoredUser user) {
        LogUtils.buildAgileLog((String)"adt", (String)"receiveQuestion", (String)"1", (String)JsonUtils.objectToString((Object)req), (String)"\u6570\u636e\u9762\u677f\u6536\u85cf\u8bf7\u6c42", (String)"");
        AgileDataProcessResDTO result = AgileDataProcessResDTO.init();
        AgileDataPanelResDTO agileDataPanelResDTO = new AgileDataPanelResDTO();
        AthenaMessageEvent event = this.init(request, req, user);
        event.setSendNana(false);
        event.setSourceName(AgileDataSourceEnum.PANEL.getName());
        event.setSourceCode(AgileDataSourceEnum.PANEL.getCode());
        String questionId = MapUtils.getString((Map)req.getMsgExt(), (Object)"questionId");
        if (StringUtils.isEmpty((CharSequence)questionId)) {
            result = this.agileDataMessageService.processRes(event);
        } else {
            KMCollectStepResDTO stepResDTO = this.kmService.getCollectStep(user, questionId);
            if (Objects.isNull(stepResDTO) || MapUtils.isEmpty((Map)stepResDTO.getSolutionStep()) || Objects.isNull(stepResDTO.getSnapshotId())) {
                result = this.agileDataMessageService.processRes(event);
                this.setPanelDataResult(result, agileDataPanelResDTO, user, event.getLang());
                return agileDataPanelResDTO;
            }
            this.buildEventByStepQuestion(event, stepResDTO);
            String snapshotId = stepResDTO.getSnapshotId();
            SnapShotDTO snapshotInfo = this.snapShotDataService.getSnapShotData(snapshotId, user.getTenantId(), user.getUserId());
            if (Objects.nonNull(snapshotInfo) && Objects.nonNull(stepResDTO.getBoardId()) && MapUtils.isNotEmpty((Map)stepResDTO.getSolutionStep())) {
                AgileDataProcessResDTO res = this.agileDataMessageService.processResV1(event, snapshotInfo, stepResDTO);
                result.setAlarm(false);
                result.setDataTipMessage("");
                result.setMsg(res.getMsg());
                result.setSnapshotId(res.getPanelMap().getSnapshotId());
                result.setPanelMap(res.getPanelMap());
                if (res.getPanelMap().getContext() != null) {
                    result.setRequestTime(res.getPanelMap().getContext().getBizParams().getRequestTime());
                }
            } else {
                result = this.agileDataMessageService.processRes(event);
            }
        }
        this.setPanelDataResult(result, agileDataPanelResDTO, user, event.getLang());
        return agileDataPanelResDTO;
    }

    public void setPanelDataResult(AgileDataProcessResDTO result, AgileDataPanelResDTO agileDataPanelResDTO, AuthoredUser user, String lang) {
        DateTimeFormatter sdf = DateTimeFormatter.ofPattern(YYYY_MM_DD_HH_MM_SS);
        if (Objects.nonNull(result) && Objects.nonNull(result.getRequestTime())) {
            String formatDate = result.getRequestTime().format(sdf);
            agileDataPanelResDTO.setRequestTime(formatDate);
            agileDataPanelResDTO.setSnapshotId(result.getSnapshotId());
            agileDataPanelResDTO.setMsg(result.getMsg());
            agileDataPanelResDTO.setTotalUsage(result.getTotalUsage());
            agileDataPanelResDTO.setRemainingUsage(result.getRemainingUsage());
            agileDataPanelResDTO.setAlarm(result.isAlarm());
            agileDataPanelResDTO.setDataTipMessage(result.getDataTipMessage());
            if (StringUtils.isEmpty((CharSequence)result.getSnapshotId())) {
                agileDataPanelResDTO.setResult(false);
            } else {
                SnapShotDTO snapshotInfo = result.getPanelMap();
                if (snapshotInfo == null) {
                    agileDataPanelResDTO.setResult(false);
                } else {
                    snapshotInfo.getContext().getPullData().stream().forEach(pullDataDTO -> {
                        if (MapUtils.isEmpty((Map)pullDataDTO.getData())) {
                            agileDataPanelResDTO.setTitle(AgileDataSnapShotUtils.getTile((SnapShotDTO)snapshotInfo));
                            agileDataPanelResDTO.setMsg(this.messageUtil.getMessageByLangNameWithFormat("exception.agileReport.empty.data", lang, new Object[0]));
                            agileDataPanelResDTO.setResult(false);
                            return;
                        }
                        Object dataListObj = pullDataDTO.getData().get("data");
                        if (dataListObj == null) {
                            agileDataPanelResDTO.setTitle(AgileDataSnapShotUtils.getTile((SnapShotDTO)snapshotInfo));
                            agileDataPanelResDTO.setResult(false);
                            agileDataPanelResDTO.setMsg(this.messageUtil.getMessageByLangNameWithFormat("exception.agileReport.empty.data", lang, new Object[0]));
                            return;
                        }
                        agileDataPanelResDTO.setResult(true);
                    });
                }
            }
        } else {
            agileDataPanelResDTO.setResult(false);
        }
    }

    public AgileDataPanelResult panelFlagShipProcessMessage(HttpServletRequest request, AniaAssistantChatReqDTO aniaAssistantChatReqDTO, AuthoredUser user) {
        AgileDataPanelResult agileDataPanelResult = new AgileDataPanelResult();
        Map extData = aniaAssistantChatReqDTO.getMessage().getExtData();
        String questionId = MapUtils.getString((Map)extData, (Object)"questionId");
        AthenaMessageEvent event = this.assemblyVersionInitEvent(request, aniaAssistantChatReqDTO, user);
        SnapShotDTO snapShotDTO = null;
        if (StringUtils.isNotEmpty((CharSequence)questionId)) {
            ThemeMapBoardDTO themeMapBoardDTO = this.kmService.getThemeMapBoardQuestion(user, questionId);
            Map adeParams = MapUtils.getMap((Map)themeMapBoardDTO.getDataParam(), (Object)"adeRequest");
            if (MapUtils.isNotEmpty((Map)adeParams)) {
                AdeDatasetReqDTO adeDatasetReqDTO = (AdeDatasetReqDTO)new JSONObject((Object)adeParams).toBean(AdeDatasetReqDTO.class);
                adeDatasetReqDTO.setMessageId(String.valueOf(event.getGenerateSerialNo()));
                AgileDataProcessResDTO res = this.agileDataMessageService.processResV2(event, null, themeMapBoardDTO, adeDatasetReqDTO);
                agileDataPanelResult.setSnapShotDTO(res.getPanelMap());
                agileDataPanelResult.setMsg(res.getMsg());
                agileDataPanelResult.setTitle(AgileDataSnapShotUtils.getTile((SchemaMetricShowDefine)adeDatasetReqDTO.getShowDefine()));
            } else {
                if (Objects.isNull(themeMapBoardDTO) || Objects.isNull(themeMapBoardDTO.getSolutionStep()) || Objects.isNull(themeMapBoardDTO.getSnapshotId())) {
                    AgileDataProcessResDTO res = this.agileDataMessageService.processRes(event);
                    agileDataPanelResult.setSnapShotDTO(res.getPanelMap());
                    agileDataPanelResult.setMsg(res.getMsg());
                    return agileDataPanelResult;
                }
                String snapshotId = themeMapBoardDTO.getSnapshotId();
                SnapShotDTO snapshotInfo = this.snapShotDataService.getSnapShotData(snapshotId, user.getTenantId(), user.getUserId());
                if (Objects.isNull(snapshotInfo)) {
                    agileDataPanelResult.setSnapShotDTO(snapShotDTO);
                    return agileDataPanelResult;
                }
                AgileDataProcessResDTO res = this.agileDataMessageService.processResV2(event, snapshotInfo, themeMapBoardDTO, null);
                this.buildTitle(res.getPanelMap(), themeMapBoardDTO);
                agileDataPanelResult.setSnapShotDTO(res.getPanelMap());
                agileDataPanelResult.setMsg(res.getMsg());
                agileDataPanelResult.setTitle(AgileDataSnapShotUtils.getTile((SnapShotDTO)res.getPanelMap()));
            }
        } else {
            AgileDataProcessResDTO res = this.agileDataMessageService.processRes(event);
            agileDataPanelResult.setSnapShotDTO(res.getPanelMap());
            agileDataPanelResult.setMsg(res.getMsg());
        }
        return agileDataPanelResult;
    }

    public AgileDataMCPDTO mcpProcessMessage(HttpServletRequest request, AniaAssistantChatReqDTO req, AuthoredUser user) {
        AgileDataMCPDTO agileDataMCPDTO = new AgileDataMCPDTO();
        agileDataMCPDTO.setResult(Boolean.valueOf(true));
        AthenaMessageEvent event = this.assemblyVersionInitEvent(request, req, user);
        AgileDataProcessResDTO res = this.agileDataMessageService.processRes(event);
        SnapShotDTO snapShotDTO = res.getPanelMap();
        if (snapShotDTO == null) {
            agileDataMCPDTO.setResult(Boolean.valueOf(false));
            agileDataMCPDTO.setMessage(res.getMsg());
            return agileDataMCPDTO;
        }
        agileDataMCPDTO.setSnapShotDTO(snapShotDTO);
        return agileDataMCPDTO;
    }

    private void buildTitle(SnapShotDTO snapShotDTO, ThemeMapBoardDTO themeMapBoardDTO) {
        Map showDefine;
        List showType;
        BizParamsDTO bizParamsDTO;
        ContextDTO contextDTO;
        if (StringUtils.isEmpty((CharSequence)themeMapBoardDTO.getChartTitle())) {
            return;
        }
        if (snapShotDTO != null && (contextDTO = snapShotDTO.getContext()) != null && (bizParamsDTO = contextDTO.getBizParams()) != null && CollectionUtils.isNotEmpty((Collection)(showType = (List)MapUtils.getObject((Map)(showDefine = bizParamsDTO.getShowDefine()), (Object)"showType")))) {
            showType.stream().forEach(showTypeMap -> {
                List type = (List)MapUtils.getObject((Map)showTypeMap, (Object)"type");
                if (CollectionUtils.isNotEmpty((Collection)type)) {
                    type.stream().forEach(typeMap -> typeMap.put("title", themeMapBoardDTO.getChartTitle()));
                }
            });
        }
    }

    private void buildEventByStepQuestion(AthenaMessageEvent event, KMCollectStepResDTO stepResDTO) {
        event.setDatasetIdList(stepResDTO.getDatasetList());
        event.getMsgExt().put("sceneCode", stepResDTO.getSceneCode());
        event.getMsgExt().put("metricIdList", stepResDTO.getMetricIdList());
    }

    public SseEmitter sseProcessMessage(HttpServletRequest request, AthenaMessageDTO athenaMessageDTO, AuthoredUser user) {
        LogUtils.buildAgileLog((String)"adt", (String)"receiveQuestion", (String)"1", (String)JsonUtils.objectToString((Object)athenaMessageDTO), (String)"\u5a1c\u5a1c\u6d41\u5f0fV1\u95ee\u53e5\u8bf7\u6c42", (String)"");
        SSEBaseEvent sseBaseEvent = new SSEBaseEvent();
        SseEmitter sseEmitter = this.sseManagerService.generateSseEmitter(sseBaseEvent);
        sseBaseEvent.setAniaEmitter(sseEmitter);
        AthenaMessageEvent event = this.init(request, athenaMessageDTO, user);
        event.setSaveTransResult(Boolean.valueOf(true));
        event.setSseMessage(true);
        event.setSseEmitter(sseEmitter);
        CompletableFuture.runAsync(() -> {
            EventData eventData = new EventData(SseAniaEventEnum.CHAT_CREATED.getEvent(), null);
            if (Objects.nonNull(sseEmitter)) {
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)eventData);
            }
            this.agileDataMessageService.sseProcess(event, sseBaseEvent);
        }, this.executorConfig.asyncServiceExecutor());
        return sseEmitter;
    }

    public SseEmitter sseProcessMessageV2(HttpServletRequest request, AniaAssistantChatReqDTO aniaAssistantChatReqDTO, AuthoredUser user) {
        LogUtils.buildAgileLog((String)"adt", (String)"receiveQuestion", (String)"1", (String)JsonUtils.objectToString((Object)aniaAssistantChatReqDTO), (String)"\u5a1c\u5a1c\u6d41\u5f0fV2\u95ee\u53e5\u8bf7\u6c42", (String)"");
        SSEBaseEvent sseBaseEvent = new SSEBaseEvent();
        SseEmitter sseEmitter = this.sseManagerService.generateSseEmitter(sseBaseEvent);
        sseBaseEvent.setAniaEmitter(sseEmitter);
        AthenaMessageEvent event = this.assemblyVersionInitEvent(request, aniaAssistantChatReqDTO, user);
        event.setSseMessage(true);
        event.setSseEmitter(sseEmitter);
        event.setAppCode(aniaAssistantChatReqDTO.getAssistantId());
        event.setSaveTransResult(Boolean.valueOf(true));
        CompletableFuture.runAsync(() -> {
            EventData eventData = new EventData(SseAniaEventEnum.CHAT_CREATED.getEvent(), null);
            if (Objects.nonNull(sseEmitter)) {
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)eventData);
            }
            this.agileDataMessageService.sseProcess(event, sseBaseEvent);
        }, this.executorConfig.asyncServiceExecutor());
        return sseEmitter;
    }

    public SseEmitter sseAgileData(HttpServletRequest request, AniaAssistantChatReqDTO aniaAssistantChatReqDTO, AuthoredUser user) {
        LogUtils.buildAgileLog((String)"adt", (String)"autoDataAnalyze", (String)"1", (String)JsonUtils.objectToString((Object)aniaAssistantChatReqDTO), (String)"\u751f\u6210\u5206\u6790\u5e08\u62a5\u544a\u8bf7\u6c42", (String)"");
        SSEBaseEvent sseBaseEvent = new SSEBaseEvent();
        SseEmitter sseEmitter = this.sseManagerService.generateSseEmitter(sseBaseEvent);
        sseBaseEvent.setAniaEmitter(sseEmitter);
        AthenaMessageEvent event = this.assemblyVersionInitEvent(request, aniaAssistantChatReqDTO, user);
        event.setSseMessage(true);
        event.setSseEmitter(sseEmitter);
        event.setAppCode(aniaAssistantChatReqDTO.getAssistantId());
        CompletableFuture.runAsync(() -> {
            EventData eventData = new EventData(SseAniaEventEnum.CHAT_CREATED.getEvent(), null);
            if (Objects.nonNull(sseEmitter)) {
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)eventData);
            }
            MDC.put((String)"traceId", (String)event.getPtxId());
            MDC.put((String)"PtxId", (String)event.getPtxId());
            log.info("initMdc create chat {},mdc get ptxId :{},event PtxId :{}", new Object[]{MDC.get((String)"traceId"), MDC.get((String)"PtxId"), event.getPtxId()});
            this.agileDataMessageService.sseProcess(event, sseBaseEvent);
        }, this.executorConfig.asyncServiceExecutor());
        return sseEmitter;
    }

    public AgileDataDetailUrlDTO getDataDetailUrl(AuthoredUser user, String snapshotId, String locale) {
        AgileDataDetailUrlDTO agileDataDetailUrlDTO = new AgileDataDetailUrlDTO();
        SnapShotDTO snapshotInfo = this.snapShotDataService.getSnapShotData(snapshotId, user.getTenantId(), user.getUserId());
        if (Objects.isNull(snapshotInfo)) {
            this.buildErrorMessage(agileDataDetailUrlDTO, locale);
            return agileDataDetailUrlDTO;
        }
        Map params = this.buildParams(snapshotInfo);
        if (Objects.isNull(params)) {
            return agileDataDetailUrlDTO;
        }
        AgileDataEngineFileDownModel adeFileDown = this.getFileDownUrl(user, params, locale);
        if (adeFileDown == null) {
            this.buildErrorMessage(agileDataDetailUrlDTO, locale);
            return agileDataDetailUrlDTO;
        }
        agileDataDetailUrlDTO.setDataUrl(adeFileDown.getData());
        agileDataDetailUrlDTO.setResult(Boolean.valueOf(StringUtils.equals((CharSequence)"200", (CharSequence)adeFileDown.getCode())));
        agileDataDetailUrlDTO.setErrorMessage(adeFileDown.getMsg());
        return agileDataDetailUrlDTO;
    }

    public AgileDataEngineFileDownModel getFileDownUrl(AuthoredUser user, Map<String, Object> params, String locale) {
        AgileDataEngineFileDownModel model = new AgileDataEngineFileDownModel();
        ArrayList header = (ArrayList)params.get("descriptionsList");
        ArrayList dataKey = (ArrayList)params.get("dataNamesList");
        List data = (List)params.get("data");
        HashMap<String, Object> excelRequest = new HashMap<String, Object>(2);
        StringBuilder sb = new StringBuilder();
        ArrayList<ExcelSheet> excelSheets = new ArrayList<ExcelSheet>(1);
        String sheetName = "\u56fe\u8868\u6570\u636e";
        String fileName = "\u6570\u636e\u4e0b\u8f7d";
        if ("zh_TW".equals(locale)) {
            sheetName = "\u5716\u8868\u6578\u64da";
            fileName = "\u6578\u64da\u4e0b\u8f09";
        }
        excelSheets.add(ExcelSheet.build((String)sheetName, (ArrayList)header, (ArrayList)dataKey, (List)data));
        excelRequest.put("fileName", fileName);
        excelRequest.put("fileData", excelSheets);
        excelRequest.put("tenantId", user.getTenantId());
        AgileDataEngineFileDownModel res = this.fileParsingService.getDmcShareUrl(user.getTenantId(), user.getToken(), locale, excelRequest);
        if (Objects.nonNull(res)) {
            return res;
        }
        return model;
    }

    private void buildErrorMessage(AgileDataDetailUrlDTO agileDataDetailUrlDTO, String locale) {
        agileDataDetailUrlDTO.setResult(Boolean.valueOf(false));
        agileDataDetailUrlDTO.setErrorMessage(this.messageUtil.getMessageByLangName("message.ade.dataUrl.error.msg", locale));
    }

    private Map<String, Object> buildParams(SnapShotDTO snapshotInfo) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        ContextDTO context = snapshotInfo.getContext();
        if (Objects.isNull(context)) {
            return null;
        }
        List pullData = context.getPullData();
        if (CollectionUtils.isEmpty((Collection)pullData)) {
            return null;
        }
        if (CollectionUtils.isNotEmpty((Collection)pullData)) {
            PullDataDTO pullDataDTO = (PullDataDTO)pullData.get(0);
            res.put("data", pullDataDTO.getData().get("data"));
            Map response = Optional.ofNullable((Map)pullDataDTO.getMetadata().get("response")).orElse(Collections.emptyMap());
            Map data = Optional.ofNullable((Map)response.get("data")).orElse(Collections.emptyMap());
            List fields = (List)data.get("field");
            ArrayList<String> descriptionsList = new ArrayList<String>();
            ArrayList<String> dataNamesList = new ArrayList<String>();
            for (Map field : fields) {
                descriptionsList.add(String.valueOf(field.get("description")));
                dataNamesList.add(String.valueOf(field.get("data_name")));
            }
            res.put("descriptionsList", descriptionsList);
            res.put("dataNamesList", dataNamesList);
        }
        return res;
    }

    public AgileDataSummarizeResDTO getAgileDataSummarize(AgileDataSummarizeReqDTO agileDataSummarizeReqDTO, AuthoredUser user) {
        AgileDataSummarizeResDTO agileDataSummarizeResDTO = new AgileDataSummarizeResDTO();
        String snapshotId = agileDataSummarizeReqDTO.getSnapshotId();
        SnapShotDTO snapshotInfo = this.snapShotDataService.getSnapShotData(snapshotId, user.getTenantId(), user.getUserId());
        boolean queryDataFlag = snapshotInfo.getContext().getBizParams().isQueryDataFlag();
        if (!queryDataFlag) {
            agileDataSummarizeResDTO.setData(false);
            agileDataSummarizeResDTO.setSummarizeMsg("");
            return agileDataSummarizeResDTO;
        }
        String summarizeData = ((PullDataDTO)snapshotInfo.getContext().getPullData().get(0)).getSummarizeData();
        String question2 = snapshotInfo.getContext().getBizParams().getQuestion();
        HashMap<String, Object> requestParam = new HashMap<String, Object>();
        requestParam.put("question", question2);
        requestParam.put("resultData", summarizeData);
        requestParam.put("snapshotId", snapshotId);
        requestParam.put("userPromptList", new ArrayList());
        Map analysis = this.chatbiService.getResultAnalysis(requestParam, user);
        if (Objects.isNull(analysis) || Objects.isNull(analysis.get("data"))) {
            agileDataSummarizeResDTO.setSummarizeMsg("\u83b7\u53d6\u6570\u636e\u603b\u7ed3\u5f02\u5e38");
            agileDataSummarizeResDTO.setData(false);
            return agileDataSummarizeResDTO;
        }
        String summarizeMsg = String.valueOf(analysis.get("data"));
        agileDataSummarizeResDTO.setSummarizeData(summarizeMsg);
        agileDataSummarizeResDTO.setData(true);
        this.saveAgileDataSummarizeById(snapshotId, summarizeMsg);
        return agileDataSummarizeResDTO;
    }

    public void saveAgileDataSummarizeById(String snapshotId, String summarizeMsg) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"snapshotId").is((Object)snapshotId));
        List results = this.mongoTemplate.find(query, AgileDataSummarizeMsg.class);
        if (CollectionUtils.isEmpty((Collection)results)) {
            AgileDataSummarizeMsg msg = new AgileDataSummarizeMsg();
            msg.setSummarizeMsg(summarizeMsg);
            msg.setSnapshotId(snapshotId);
            this.mongoTemplate.insert((Object)msg);
        }
    }

    public String getMongoSummarizeMsg(String snapshotId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"snapshotId").is((Object)snapshotId));
        List results = this.mongoTemplate.find(query, AgileDataSummarizeMsg.class);
        if (CollectionUtils.isNotEmpty((Collection)results)) {
            return ((AgileDataSummarizeMsg)results.get(0)).getSummarizeMsg();
        }
        return null;
    }

    public Map<String, Object> getAppVersion(AuthoredUser user, String appCode) {
        AthenaMessageEvent event = new AthenaMessageEvent();
        HashMap<String, Object> res = new HashMap<String, Object>();
        event.setUser(user);
        if ("asada".equals(appCode)) {
            res.put("version", "V1");
            res.put("isAgileDataApp", true);
            return res;
        }
        if (!StringUtils.isEmpty((CharSequence)appCode)) {
            KMDatasetCommandIntentionsResDTO cIData = this.kmService.dataSetCommandIntentions(event.getUser(), appCode, "");
            if (Objects.nonNull(cIData) && Objects.nonNull(cIData.getAppType())) {
                int appType = cIData.getAppType();
                String version = appType == 12 ? "V2" : "V1";
                res.put("version", version);
                boolean isAileDataApp = appType == 12 || appType == 6;
                res.put("isAgileDataApp", isAileDataApp);
            } else {
                res.put("version", "");
                res.put("isAgileDataApp", false);
            }
        }
        return res;
    }

    public AgileFilterProcessResDTO filterProcessMessage(HttpServletRequest request, AniaAssistantChatReqDTO req, AuthoredUser user) {
        AgileFilterProcessResDTO res = new AgileFilterProcessResDTO();
        LogUtils.buildAgileLog((String)"adt", (String)"filterQuestion", (String)"1", (String)JsonUtils.objectToString((Object)req), (String)"\u6570\u636e\u7b5b\u9009\u8bf7\u6c42", (String)"");
        try {
            SnapShotDTO snapShotDTO;
            String snapshotId;
            SnapShotDTO snapshotInfo;
            Map extData = req.getMessage().getExtData();
            AthenaMessageEvent event = this.assemblyVersionInitEvent(request, req, user);
            event.setSaveTransResult(Boolean.valueOf(true));
            String productVersion = event.getProductVersion();
            List stepFilterAnalysis = (List)req.getMessage().getExtData().get("stepFilterAnalysis");
            Object showType = req.getMessage().getExtData().get("showType");
            int filterShowType = 0;
            if (Objects.nonNull(showType)) {
                filterShowType = Integer.parseInt(showType.toString());
            }
            if (Objects.isNull(snapshotInfo = this.snapShotDataService.getSnapShotData(snapshotId = MapUtils.getString((Map)extData, (Object)"snapshotId"), user.getTenantId(), user.getUserId()))) {
                res.setMsg("\u672a\u67e5\u8be2\u5230\u5feb\u7167");
                return res;
            }
            if ("V1".equals(productVersion)) {
                KMCollectStepResDTO stepResDTO = KMCollectStepResDTO.builderCollectStepBySnapShotInfo((SnapShotDTO)snapshotInfo, (Integer)filterShowType);
                stepResDTO.setStepFilterAnalysis(stepFilterAnalysis);
                stepResDTO.setFilterAnalysis(true);
                AgileDataProcessResDTO resDTO = this.agileDataMessageService.processResV1(event, snapshotInfo, stepResDTO);
                snapShotDTO = resDTO.getPanelMap();
            } else {
                ThemeMapBoardDTO themeMapBoardDTO = ThemeMapBoardDTO.builderThemeMapBoardBySnapShotInfo((SnapShotDTO)snapshotInfo, (Integer)filterShowType);
                themeMapBoardDTO.setStepFilterAnalysis(stepFilterAnalysis);
                themeMapBoardDTO.setFilterAnalysis(true);
                AgileDataProcessResDTO result = this.agileDataMessageService.processResV2(event, snapshotInfo, themeMapBoardDTO, null);
                snapShotDTO = result.getPanelMap();
            }
            if (Objects.nonNull(snapShotDTO) && StringUtils.isNotEmpty((CharSequence)snapShotDTO.getSnapshotId())) {
                res.setSnapshotId(snapShotDTO.getSnapshotId());
            }
            if (Objects.nonNull(snapShotDTO) && Objects.nonNull(snapShotDTO.getContext()) && Objects.nonNull(snapShotDTO.getContext().getBizParams())) {
                Map typeMap;
                List typeList;
                List showTypeList;
                res.setTransIds(snapShotDTO.getContext().getBizParams().getTransIds());
                Map showDefine = snapShotDTO.getContext().getBizParams().getShowDefine();
                if (MapUtils.isNotEmpty((Map)showDefine) && CollectionUtils.isNotEmpty((Collection)(showTypeList = (List)MapUtils.getObject((Map)showDefine, (Object)"showType"))) && CollectionUtils.isNotEmpty((Collection)(typeList = (List)(typeMap = (Map)showTypeList.get(0)).get("type")))) {
                    res.setShowType(MapUtils.getString((Map)((Map)typeList.get(0)), (Object)"value"));
                }
            }
            res.setOrgSnapshotId(snapshotId);
            String filterSnapshotId = res.getSnapshotId();
            this.agileDataSnapRelationMappingService.saveSnapshotIdMappingRelation(snapshotId, filterSnapshotId);
        }
        catch (Exception e) {
            log.error("filterProcessMessage is error :{}", (Object)e.getMessage());
        }
        LogUtils.buildAgileLog((String)"adt", (String)"filterQuestion", (String)"1", (String)"\u6570\u636e\u7b5b\u9009\u8fd4\u56de", (String)JsonUtils.objectToString((Object)res), (String)"");
        return res;
    }

    public AnalysisFluctuateResDTO analysisFluctuateProcess(HttpServletRequest request, AnalysisFluctuateReqDTO req, AuthoredUser user) {
        log.info("\u6570\u636e\u6ce2\u52a8-\u5165\u53c2\uff1a{}", (Object)JsonUtils.objectToString((Object)req));
        AnalysisFluctuateResDTO res = new AnalysisFluctuateResDTO();
        AthenaMessageEvent event = new AthenaMessageEvent();
        Long messageId = SnowflakeIdWorker.getInstance().newId();
        event.setUser(user);
        event.setGenerateSerialNo(messageId);
        event.setPtxId(MDC.get((String)"PtxId"));
        try {
            String snapshotId = req.getSnapshotId();
            SnapShotDTO orgSnapshotDTO = this.snapShotDataService.getSnapShotData(snapshotId, user.getTenantId(), user.getUserId());
            if (Objects.isNull(orgSnapshotDTO)) {
                res.setMsg("\u672a\u67e5\u8be2\u5230\u5feb\u7167");
                return res;
            }
            String userLocale = this.userService.getUserLangNameByUserId(user.getUserId(), user.getTenantId(), user.getToken());
            event.setLang(userLocale);
            AnalysisFluctuateReqDTO scrumReq = AnalysisFluctuateReqDTO.builderQuery((AnalysisFluctuateReqDTO)req, (SnapShotDTO)orgSnapshotDTO);
            SchemaFluctuateResDTO scrumAnalysis = this.chatbiService.getFluctuateAnalysis(event, scrumReq);
            if (scrumAnalysis == null) {
                res.setMsg("AI\u5206\u6790\u5f02\u5e38");
                return res;
            }
            if (scrumAnalysis != null && scrumAnalysis.getData() != null && StringUtils.equals((CharSequence)"1", (CharSequence)scrumAnalysis.getData().getCode())) {
                res.setMsg(scrumAnalysis.getData().getReply());
                return res;
            }
            AdeDatasetReqDTO params = AdeDatasetReqDTO.BuildAnalysisFluctuateReq((SchemaFluctuateResDTO)scrumAnalysis, (SnapShotDTO)orgSnapshotDTO, (AuthoredUser)user);
            params.setLocale(event.getLang());
            params.setMessageId(String.valueOf(messageId));
            Map response = this.adeService.reqMetricSnapShotData(CommonUtil.convertObjectToMap((Object)params), event);
            if (response == null || "-1".equals(response.get("code"))) {
                String errorMsg = MapUtils.getString((Map)response, (Object)"msg");
                res.setMsg(errorMsg);
                return res;
            }
            SnapShotDTO snapShotDTO = (SnapShotDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString(response.get("data")), SnapShotDTO.class);
            res.setMsg("");
            res.setStep(scrumAnalysis.getData().getStep());
            res.setSolutionStep(scrumAnalysis.getData().getSolutionStep());
            res.setPullData(snapShotDTO.getContext().getPullData());
            res.setOrgOutPutSql(scrumAnalysis.getData().getOrgOutPutSql());
            res.setDatasetIds(scrumReq.getDatasetIds());
            res.setQuestion(scrumAnalysis.getData().getQuestion());
            res.setQuestionDate(scrumReq.getQuestionDate());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5f52\u56e0-\u6ce2\u52a8\u6570\u636e\u5931\u8d25:{}", (Object)e.getMessage());
        }
        return res;
    }

    public AnalysisAttributionResDTO analysisAttributionProcess(HttpServletRequest request, AnalysisAttributionReqDTO req, AuthoredUser user) {
        log.info("\u5f52\u56e0\u5206\u6790\u5165\u53c2\uff1a{}", (Object)JsonUtils.objectToString((Object)req));
        AnalysisAttributionResDTO res = new AnalysisAttributionResDTO();
        AthenaMessageEvent event = new AthenaMessageEvent();
        Long messageId = SnowflakeIdWorker.getInstance().newId();
        event.setUser(user);
        event.setGenerateSerialNo(messageId);
        event.setPtxId(MDC.get((String)"PtxId"));
        SchemaAnalysisAttributionResDTO scrumAnalysis = this.chatbiService.getAttributionAnalysis(event, req);
        if (scrumAnalysis == null || scrumAnalysis.getData() == null || !"0".equals(scrumAnalysis.getData().getCode())) {
            assert (Objects.requireNonNull(scrumAnalysis).getData() != null);
            String errorMsg = scrumAnalysis.getData().getReply();
            res.setMsg(errorMsg);
            return res;
        }
        String snapshotId = req.getSnapshotId();
        SnapShotDTO orgSnapshotDTO = this.snapShotDataService.getSnapShotData(snapshotId, user.getTenantId(), user.getUserId());
        if (Objects.isNull(orgSnapshotDTO)) {
            res.setMsg("\u672a\u67e5\u8be2\u5230\u5feb\u7167");
            return res;
        }
        AdeAnalysisAttributionReqDTO params = AdeAnalysisAttributionReqDTO.BuildAnalysisAttributionReq((SchemaAnalysisAttributionResDTO)scrumAnalysis, (AnalysisAttributionReqDTO)req, (SnapShotDTO)orgSnapshotDTO, (AuthoredUser)user);
        String userLocale = this.userService.getUserLangNameByUserId(user.getUserId(), user.getTenantId(), user.getToken());
        params.setLocale(userLocale);
        AdeAnalysisAttributionResDTO response = this.adeService.getAttributionDimension(event, params);
        if (response == null || "-1".equals(response.getCode())) {
            assert (response != null);
            String errorMsg = response.getMsg();
            res.setMsg(errorMsg);
            return res;
        }
        res.setGroupedSolutionSteps(response.getData().getGroupedSolutionSteps());
        return res;
    }

    public void chatPPts(HttpServletRequest request, ChatReqPPTReqDTO req, AuthoredUser user) {
        HashMap params = Maps.newHashMap();
        Long pptMessageId = req.getMessageId();
        params.put("messageId", pptMessageId);
        try {
            AgileDataFileDTO pptDTO = this.echoService.getAgileDataFile((Map)params, user.getToken(), user.getTenantId());
            log.info("\u6267\u884c ppt \u89e3\u6790 \u83b7\u53d6\u95ee\u53e5\u4fe1\u606f:{}", (Object)JsonUtils.objectToString((Object)pptDTO));
            if (pptDTO == null || CollectionUtils.isEmpty((Collection)pptDTO.getQuestionInfo())) {
                log.warn("\u672a\u83b7\u53d6\u5230PPT\u95ee\u53e5\u4fe1\u606f\uff0cmessageId\uff1a{}", (Object)pptMessageId);
                return;
            }
            String appCode = pptDTO.getAppCode();
            this.updatePPTStatusByMessageId(pptDTO, user, req.getMessageId());
            CompletableFuture.runAsync(() -> this.processChatPPT(appCode, user, pptDTO, arg_0 -> ((AgileDataMessageService)this.agileDataMessageService).processPPT(arg_0), () -> this.agileDataMessageService.processPPTAfter(user, pptMessageId)), this.executorConfig.asyncServiceExecutor());
        }
        catch (Exception e) {
            log.error("PPT\u95ee\u53e5\u89e3\u6790\u672a\u77e5\u5f02\u5e38\uff0cmessageId\uff1a{}", (Object)req.getMessageId(), (Object)e);
        }
    }

    public void chatAIBoard(HttpServletRequest request, ChatReqAIBoardDTO req, AuthoredUser user) {
        HashMap params = Maps.newHashMap();
        Long aiBoardMessageId = req.getMessageId();
        params.put("messageId", aiBoardMessageId);
        log.info("\u5f00\u59cb\u6267\u884c\u89e3\u6790\u5bf9\u8bdd\u770b\u677f,\u5165\u53c2:{}", (Object)JsonUtils.objectToString((Object)req));
        try {
            AIBoardDTO aiBoardDTO = this.echoService.getAIBoard((Map)params, user.getToken(), user.getTenantId());
            log.info("\u6267\u884c \u5bf9\u8bdd\u770b\u677f \u83b7\u53d6\u95ee\u53e5\u4fe1\u606f:{}", (Object)JsonUtils.objectToString((Object)aiBoardDTO));
            if (aiBoardDTO == null || CollectionUtils.isEmpty((Collection)aiBoardDTO.getQuestionInfo())) {
                log.warn("\u672a\u83b7\u53d6\u5230\u5bf9\u8bdd\u770b\u677f\u95ee\u53e5\u4fe1\u606f\uff0cmessageId\uff1a{}", (Object)aiBoardMessageId);
                return;
            }
            String appCode = aiBoardDTO.getAppCode();
            this.updateAIBoardStatusByMessageId(aiBoardDTO, user, req.getMessageId());
            CompletableFuture.runAsync(() -> this.processChatAIBoard(appCode, user, aiBoardDTO, arg_0 -> ((AgileDataMessageService)this.agileDataMessageService).processAIBoard(arg_0), () -> this.agileDataMessageService.processAIBoardAfter(user, aiBoardMessageId)), this.executorConfig.asyncServiceExecutor());
        }
        catch (Exception e) {
            log.error("\u5bf9\u8bdd\u770b\u677f\u89e3\u6790\u672a\u77e5\u5f02\u5e38\uff0cmessageId\uff1a{}", (Object)req.getMessageId(), (Object)e);
        }
    }

    public void processChatPPT(String appCode, AuthoredUser user, AgileDataFileDTO pptBean, QuestionProcessor processor, Runnable after) {
        List questions = pptBean.getQuestionInfo();
        if (CollectionUtils.isEmpty((Collection)questions)) {
            log.warn("PPT\u95ee\u53e5\u5217\u8868\u4e3a\u7a7a\uff0c\u65e0\u9700\u5904\u7406\uff0cmessageId\uff1a{}", (Object)pptBean.getMessageId());
            after.run();
            return;
        }
        try {
            CompletableFuture[] futures = (CompletableFuture[])questions.stream().map(question2 -> CompletableFuture.runAsync(() -> {
                AthenaMessageEvent event = new AthenaMessageEvent();
                try {
                    event = this.initEvent(appCode, question2.getQuestion(), question2.getDatasetIds(), user);
                    event.setSendNana(false);
                    event.getMsgExt().put("pptMessageId", pptBean.getMessageId());
                    event.getMsgExt().put("pptQuestionId", question2.getQuestionId());
                    processor.process(event);
                }
                catch (Exception e) {
                    HashMap<String, Object> queryData = new HashMap<String, Object>();
                    queryData.put("title", "\u7cfb\u7edf\u5f02\u5e38");
                    queryData.put("content", "");
                    queryData.put("status", false);
                    this.updatePPTDataByError(event, null, queryData);
                    log.error("\u5f02\u6b65\u5904\u7406PPT\u95ee\u53e5\u5931\u8d25\uff0cquestionId\uff1a{}", (Object)question2.getQuestion(), (Object)e);
                }
                finally {
                    AppAuthContextHolder.clearContext();
                }
            }, this.executor)).toArray(CompletableFuture[]::new);
            ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(futures).exceptionally(ex -> {
                log.error("PPT\u95ee\u53e5\u5f02\u6b65\u5904\u7406\u6279\u6b21\u5931\u8d25\uff0cmessageId\uff1a{}", (Object)pptBean.getMessageId(), ex);
                return null;
            })).thenRun(after)).join();
        }
        catch (RejectedExecutionException e) {
            log.error("\u7ebf\u7a0b\u6c60[asyncServiceExecutor]\u62d2\u7edd\u63a5\u6536\u4efb\u52a1\uff0cmessageId\uff1a{}", (Object)pptBean.getMessageId(), (Object)e);
        }
        catch (Exception e) {
            log.error("PPT\u95ee\u53e5\u5f02\u6b65\u5904\u7406\u6846\u67b6\u5f02\u5e38\uff0cmessageId\uff1a{}", (Object)pptBean.getMessageId(), (Object)e);
        }
    }

    public void processChatAIBoard(String appCode, AuthoredUser user, AIBoardDTO aiBoardDTO, QuestionProcessor processor, Runnable after) {
        List questions = aiBoardDTO.getQuestionInfo();
        if (CollectionUtils.isEmpty((Collection)questions)) {
            log.warn("\u5bf9\u8bdd\u770b\u677f\u95ee\u53e5\u5217\u8868\u4e3a\u7a7a\uff0c\u65e0\u9700\u5904\u7406\uff0cmessageId\uff1a{}", (Object)aiBoardDTO.getMessageId());
            after.run();
            return;
        }
        try {
            CompletableFuture[] futures = (CompletableFuture[])questions.stream().map(question2 -> CompletableFuture.runAsync(() -> {
                AthenaMessageEvent event = new AthenaMessageEvent();
                try {
                    event = this.initEvent(appCode, question2.getQuestion(), question2.getDatasetIds(), user);
                    event.setSendNana(false);
                    event.getMsgExt().put("aiBoardMessageId", aiBoardDTO.getMessageId());
                    event.getMsgExt().put("aiBoardQuestionId", question2.getQuestionId());
                    processor.process(event);
                }
                catch (Exception e) {
                    HashMap<String, Object> queryData = new HashMap<String, Object>();
                    queryData.put("title", "\u7cfb\u7edf\u5f02\u5e38");
                    queryData.put("content", "");
                    queryData.put("status", false);
                    this.updatePPTDataByError(event, null, queryData);
                    log.error("\u5f02\u6b65\u5904\u7406\u5bf9\u8bdd\u770b\u677f\u95ee\u53e5\u5931\u8d25\uff0cquestionId\uff1a{}", (Object)question2.getQuestion(), (Object)e);
                }
                finally {
                    AppAuthContextHolder.clearContext();
                }
            }, this.executor)).toArray(CompletableFuture[]::new);
            ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(futures).exceptionally(ex -> {
                log.error("\u5bf9\u8bdd\u770b\u677f\u95ee\u53e5\u5f02\u6b65\u5904\u7406\u6279\u6b21\u5931\u8d25\uff0cmessageId\uff1a{}", (Object)aiBoardDTO.getMessageId(), ex);
                return null;
            })).thenRun(after)).join();
        }
        catch (RejectedExecutionException e) {
            log.error("\u7ebf\u7a0b\u6c60[asyncServiceExecutor]\u62d2\u7edd\u63a5\u6536\u4efb\u52a1\uff0cmessageId\uff1a{}", (Object)aiBoardDTO.getMessageId(), (Object)e);
        }
        catch (Exception e) {
            log.error("\u5bf9\u8bdd\u770b\u677f\u95ee\u53e5\u5f02\u6b65\u5904\u7406\u6846\u67b6\u5f02\u5e38\uff0cmessageId\uff1a{}", (Object)aiBoardDTO.getMessageId(), (Object)e);
        }
    }

    public void updatePPTStatusByMessageId(AgileDataFileDTO agileDataFileDTO, AuthoredUser user, Long messageId) {
        AgileDataFileDTO updateStatusDTO = new AgileDataFileDTO();
        agileDataFileDTO.setMessageId(messageId);
        agileDataFileDTO.setMessageStatus(Integer.valueOf(2));
        updateStatusDTO.setMessageId(messageId);
        updateStatusDTO.setMessageStatus(Integer.valueOf(2));
        ArrayList updateQuestions = Lists.newArrayList();
        updateStatusDTO.setQuestionInfo((List)updateQuestions);
        List questionInfos = agileDataFileDTO.getQuestionInfo();
        Iterator iterator = questionInfos.iterator();
        while (iterator.hasNext()) {
            AgileDataFileDTO.AgileDataFileQuestionDTO dto = (AgileDataFileDTO.AgileDataFileQuestionDTO)iterator.next();
            Integer analyzeStatus = dto.getAnalyzeStatus();
            if (analyzeStatus != null && analyzeStatus == 0) {
                iterator.remove();
                continue;
            }
            AgileDataFileDTO.AgileDataFileQuestionDTO questionDTO = new AgileDataFileDTO.AgileDataFileQuestionDTO();
            questionDTO.setQuestionId(dto.getQuestionId());
            questionDTO.setAnalyzeStatus(Integer.valueOf(2));
            updateQuestions.add(questionDTO);
            dto.setAnalyzeStatus(Integer.valueOf(2));
        }
        this.echoService.updateAgileDataFile(updateStatusDTO, user.getToken(), user.getTenantId());
    }

    public void updateAIBoardStatusByMessageId(AIBoardDTO aiBoardDTO, AuthoredUser user, Long messageId) {
        aiBoardDTO.setMessageId(messageId);
        aiBoardDTO.setMessageStatus(Integer.valueOf(2));
        List questionInfos = aiBoardDTO.getQuestionInfo();
        Iterator iterator = questionInfos.iterator();
        while (iterator.hasNext()) {
            AIBoardDTO.AIBoardQuestionDTO dto = (AIBoardDTO.AIBoardQuestionDTO)iterator.next();
            Integer analyzeStatus = dto.getAnalyzeStatus();
            if (analyzeStatus != null && analyzeStatus == 0) {
                iterator.remove();
                continue;
            }
            dto.setAnalyzeStatus(Integer.valueOf(2));
        }
        this.echoService.updateAIBoard(aiBoardDTO, user.getToken(), user.getTenantId());
    }
}

