/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.domain.semc.impl;

import com.digiwin.athena.adt.agileReport.constant.ErrorCodeEnum;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataSummarizeReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataSummarizeResDTO;
import com.digiwin.athena.adt.agileReport.event.domain.SendMessageDTO;
import com.digiwin.athena.adt.agileReport.event.domain.SendMessageReqDTO;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.app.env.AdtEnvProperties;
import com.digiwin.athena.adt.domain.report.AgileReportDataService;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.sse.domain.EventData;
import com.digiwin.athena.adt.sse.domain.SseAniaEventEnum;
import com.digiwin.athena.adt.sse.utils.SseEmitterUtils;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.ExceptionUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Service
public class SemcServiceImpl
implements SemcService {
    private static final Logger log = LoggerFactory.getLogger(SemcServiceImpl.class);
    @Autowired
    private AdtEnvProperties adtEnvProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private MessageUtil messageUtil;
    @Autowired
    private AgileReportDataService agileReportDataService;

    public Map sendMessage(SendMessageDTO sendMessageDTO, String token, String tenantId) {
        String securityToken = Objects.isNull(AppAuthContextHolder.getContext()) ? null : AppAuthContextHolder.getContext().getSecurityToken();
        log.info("\u53d1\u9001----\u5a1c\u5a1c messageId:{}, app core securityToken : {}", (Object)sendMessageDTO.getMessageId(), (Object)securityToken);
        String url = this.adtEnvProperties.getSemcUrl() + "/gpt/message/sendMessage";
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        headers.add("token", token);
        headers.add("routerkey", tenantId);
        HttpEntity httpEntity = new HttpEntity((Object)sendMessageDTO, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, Map.class, new Object[0]);
            return (Map)response.getBody();
        }
        catch (Exception e) {
            log.error("{}, \u8bf7\u6c42body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{ErrorCodeEnum.SEMC_SEND_MESSAGE_FAIL.getErrCode(), JsonUtils.objectToString((Object)sendMessageDTO), e});
            throw ExceptionUtil.wrap((String)ErrorCodeEnum.SEMC_SEND_MESSAGE_FAIL.getErrCode(), (Exception)e);
        }
    }

    public Map<String, Object> sendMessageToGpt(AthenaMessageEvent event, Map<String, Object> messageBody) {
        SendMessageDTO sendMessageDTO = this.getSendMessageDTO(event, messageBody);
        if (MapUtils.isNotEmpty((Map)sendMessageDTO.getMsgExt()) && sendMessageDTO.getMsgExt().containsKey("type")) {
            sendMessageDTO.getMsgBody().put("type", MapUtils.getString((Map)sendMessageDTO.getMsgExt(), (Object)"type"));
        }
        if (!(event.isSseMessage() || !MapUtils.isEmpty((Map)sendMessageDTO.getMsgExt()) && "agileSubscribe".equals(sendMessageDTO.getMsgExt().get("type")))) {
            log.info("Sending Message to B\u5a1c sendMessageDTO: {},sendMessageReqDTO :{}", (Object)JsonUtils.objectToString((Object)sendMessageDTO), (Object)JsonUtils.objectToString((Object)sendMessageDTO));
            this.sendMessage(sendMessageDTO, event.getUser().getToken(), event.getUser().getTenantId());
        } else if (event.isSseMessage()) {
            String sseProductVersion = event.getSseProductVersion();
            if ("V1".equals(sseProductVersion)) {
                this.sendMessageToGptByV1(sendMessageDTO, event);
            } else if ("V2".equals(sseProductVersion)) {
                sendMessageDTO.getMsgBody().put("attributionOnline", true);
                this.sendMessageToGptByV2(sendMessageDTO, event);
            } else {
                this.sendMessageToGptByV1(sendMessageDTO, event);
            }
        }
        return CommonUtil.convertObjectToMap((Object)sendMessageDTO);
    }

    public SendMessageDTO getSendMessageDTO(AthenaMessageEvent event, Map<String, Object> messageBody) {
        SendMessageReqDTO sendMessageReqDTO = SendMessageReqDTO.builderMessageAndType((AthenaMessageEvent)event, messageBody);
        SendMessageDTO sendMessageDTO = sendMessageReqDTO.getSendMessageDTO();
        String question2 = sendMessageReqDTO.getQuestion();
        String combinationQuestion = sendMessageReqDTO.getCombinationQuestion();
        String questionUnderstand = sendMessageReqDTO.getQuestionUnderstand();
        Long generateSerialNo = sendMessageReqDTO.getGenerateSerialNo();
        sendMessageDTO.setSkillType("1");
        sendMessageDTO.setMsgType("CUSTOM");
        if (MapUtils.isNotEmpty((Map)sendMessageDTO.getMsgBody())) {
            sendMessageDTO.getMsgBody().put("getMessageInfo", sendMessageDTO.isGetMessageInfo());
            sendMessageDTO.getMsgBody().put("agileDataMessageType", sendMessageReqDTO.getMessageType());
            sendMessageDTO.getMsgBody().put("method", StringUtils.isEmpty((CharSequence)sendMessageDTO.getMethod()) ? "dataflow" : sendMessageDTO.getMethod());
            sendMessageDTO.getMsgBody().put("metricList", sendMessageDTO.getMetricList());
            sendMessageDTO.getMsgBody().put("datasetList", event.getDatasetList());
            sendMessageDTO.getMsgBody().put("debugModel", sendMessageDTO.getDebugModel());
            if (StringUtils.isNotEmpty((CharSequence)question2)) {
                sendMessageDTO.getMsgBody().put("question", question2);
            }
            if (StringUtils.isNotEmpty((CharSequence)combinationQuestion)) {
                sendMessageDTO.getMsgBody().put("scrumbiQuestion", combinationQuestion);
            }
            if (StringUtils.isNotEmpty((CharSequence)questionUnderstand)) {
                sendMessageDTO.getMsgBody().put("questionUnderstand", questionUnderstand);
            }
            if (generateSerialNo != null) {
                sendMessageDTO.getMsgBody().put("generateSerialNo", generateSerialNo);
            }
            if (StringUtils.isNotEmpty((CharSequence)event.getSkillType())) {
                sendMessageDTO.getMsgBody().put("agileDataSkillType", event.getSkillType());
            }
            if (StringUtils.isNotEmpty((CharSequence)event.getAction())) {
                sendMessageDTO.getMsgBody().put("pptAction", event.getAction());
            }
            sendMessageDTO.getMsgBody().put("answerResult", event.getAnswerResult());
            sendMessageDTO.getMsgBody().put("intentions", event.getSentences());
            if (event.isSseMessage()) {
                sendMessageDTO.getMsgBody().put("historyData", event.getHistoryData());
                sendMessageDTO.getMsgBody().put("tokenSize", event.getTokenSize());
                sendMessageDTO.getMsgBody().put("exceedTokenThreshold", event.getExceedTokenThreshold());
                sendMessageDTO.getMsgBody().put("exceedSummarizeSize", event.getExceedSummarizeSize());
                sendMessageDTO.getMsgBody().put("processStreamData", event.getProcessStreamData());
                sendMessageDTO.getMsgBody().put("orgOutPutSql", event.getOrgOutPutSql());
            }
        }
        return sendMessageDTO;
    }

    public void setSummarizeData(SendMessageDTO sendMessageDTO, AthenaMessageEvent event) {
        SseEmitter sseEmitter = event.getSseEmitter();
        Boolean isSummarize = event.getExceedSummarizeSize();
        String resultMsg = this.messageUtil.getMessageByLangName("message.adt.data.summarize.info", event.getLang());
        Object snapId = sendMessageDTO.getMsgBody().get("snapshotId");
        if (Objects.isNull(snapId) || Objects.isNull(isSummarize)) {
            return;
        }
        if (!isSummarize.booleanValue()) {
            AgileDataSummarizeReqDTO req = new AgileDataSummarizeReqDTO();
            req.setSnapshotId(String.valueOf(snapId));
            AgileDataSummarizeResDTO summarizeData = this.agileReportDataService.getAgileDataSummarize(req, event.getUser());
            if (StringUtils.isNotEmpty((CharSequence)summarizeData.getSummarizeData()) && summarizeData.isData()) {
                resultMsg = summarizeData.getSummarizeData();
            } else {
                return;
            }
        }
        try {
            String[] answerSplit = resultMsg.split("");
            for (int i = 0; i < resultMsg.length(); ++i) {
                Thread.sleep(15L);
                EventData.EventMessage eventMessage = EventData.EventMessage.builderAnswerTextMessage((Object)answerSplit[i]);
                this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_DELTA.getEvent(), sseEmitter, eventMessage);
            }
        }
        catch (Exception e) {
            log.error("send message setSummarizeData error: {}", (Object)e.getMessage());
            Thread.currentThread().interrupt();
        }
    }

    private void sendMessageToGptByV1(SendMessageDTO sendMessageDTO, AthenaMessageEvent event) {
        SseEmitter sseEmitter = event.getSseEmitter();
        EventData.EventMessage eventMessage = EventData.EventMessage.builderAnswerMessage((Object)sendMessageDTO);
        this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_DELTA.getEvent(), sseEmitter, eventMessage);
        log.info("Sending Message to B\u5a1c sse message:{}", (Object)JsonUtils.objectToString((Object)sendMessageDTO));
        this.sendEventDataMessage(SseAniaEventEnum.CHAT_COMPLETED.getEvent(), sseEmitter, new EventData.EventMessage());
        this.sendEventDataMessage(SseAniaEventEnum.CHAT_DONE.getEvent(), sseEmitter, new EventData.EventMessage());
        sseEmitter.complete();
    }

    private void sendMessageToGptByV2(SendMessageDTO sendMessageDTO, AthenaMessageEvent event) {
        SseEmitter sseEmitter = event.getSseEmitter();
        EventData.EventMessage eventMessage = EventData.EventMessage.builderAnswerMessageV2((Object)sendMessageDTO);
        this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_DELTA.getEvent(), sseEmitter, eventMessage);
        log.info("Sending Message to B\u5a1c sse message:{}", (Object)JsonUtils.objectToString((Object)sendMessageDTO));
        if (event.getTenantConfig() != null && event.getTenantConfig().getEnableDataRecommend().booleanValue()) {
            this.setSentences(event);
        }
        if (event.getTenantConfig() != null && event.getTenantConfig().getEnableDataInsights().booleanValue()) {
            this.setSummarizeData(sendMessageDTO, event);
        }
        this.sendEventDataMessage(SseAniaEventEnum.CHAT_COMPLETED.getEvent(), sseEmitter, new EventData.EventMessage());
        this.sendEventDataMessage(SseAniaEventEnum.CHAT_DONE.getEvent(), sseEmitter, new EventData.EventMessage());
        sseEmitter.complete();
    }

    public void sendEventDataMessage(String sendEvent, SseEmitter sseEmitter, EventData.EventMessage eventMessage) {
        EventData eventData = new EventData(sendEvent, eventMessage);
        if (Objects.nonNull(sseEmitter)) {
            SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)eventData);
        }
    }

    public void setSentences(AthenaMessageEvent event) {
        if (CollectionUtils.isEmpty((Collection)event.getSentences())) {
            return;
        }
        EventData.EventMessage followUp = EventData.EventMessage.builderCompletedFollowUpMessageV2((AthenaMessageEvent)event);
        this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(), event.getSseEmitter(), followUp);
    }
}

