/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.sse.domain;

import com.digiwin.athena.adt.sse.domain.EventData;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.UUID;
import javax.validation.constraints.NotBlank;

@JsonPropertyOrder(value={"event", "data"})
public class EventData
implements Serializable {
    @NotBlank
    private String eventId = UUID.randomUUID().toString().replace("-", "");
    @NotBlank
    private String event;
    private EventMessage data;
    private Long eventTime = System.currentTimeMillis();

    public EventData() {
    }

    public EventData(String event) {
        this.event = event;
    }

    public EventData(String event, EventMessage data) {
        this.event = event;
        this.data = data;
    }

    public EventData(String event, String type, String messageType, String answerText) {
        this.event = event;
        EventMessage eventMessage = new EventMessage();
        eventMessage.setMessage((Object)answerText);
        eventMessage.setType(type);
        eventMessage.setMessage_type(messageType);
        this.data = eventMessage;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getEvent() {
        return this.event;
    }

    public EventMessage getData() {
        return this.data;
    }

    public Long getEventTime() {
        return this.eventTime;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setData(EventMessage data) {
        this.data = data;
    }

    public void setEventTime(Long eventTime) {
        this.eventTime = eventTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventData)) {
            return false;
        }
        EventData other = (EventData)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$eventId = this.getEventId();
        String other$eventId = other.getEventId();
        if (this$eventId == null ? other$eventId != null : !this$eventId.equals(other$eventId)) {
            return false;
        }
        String this$event = this.getEvent();
        String other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        EventMessage this$data = this.getData();
        EventMessage other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Long this$eventTime = this.getEventTime();
        Long other$eventTime = other.getEventTime();
        return !(this$eventTime == null ? other$eventTime != null : !((Object)this$eventTime).equals(other$eventTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $eventId = this.getEventId();
        result = result * 59 + ($eventId == null ? 43 : $eventId.hashCode());
        String $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        EventMessage $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Long $eventTime = this.getEventTime();
        result = result * 59 + ($eventTime == null ? 43 : ((Object)$eventTime).hashCode());
        return result;
    }

    public String toString() {
        return "EventData(eventId=" + this.getEventId() + ", event=" + this.getEvent() + ", data=" + this.getData() + ", eventTime=" + this.getEventTime() + ")";
    }

    static /* synthetic */ String access$000(EventData x0) {
        return x0.eventId;
    }
}

