/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.sse.domain;

import com.digiwin.athena.adt.sse.domain.EventData;
import com.digiwin.athena.adt.sse.domain.SseAniaEventEnum;
import com.digiwin.athena.adt.sse.dto.SSEBaseEvent;
import com.digiwin.athena.adt.sse.utils.SseEmitterUtils;
import com.digiwin.athena.adt.util.MessageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public class SseEmitterTimeOutCallbackComponent
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SseEmitterTimeOutCallbackComponent.class);
    private SSEBaseEvent sseBaseEvent;

    public SseEmitterTimeOutCallbackComponent(SSEBaseEvent sseBaseEvent) {
        this.sseBaseEvent = sseBaseEvent;
    }

    @Override
    public void run() {
        log.info("\u5f53\u524d\u5bf9\u8bdd\u6267\u884c\u65f6\u95f4\u8fc7\u957f\uff0c\u8fdb\u884c\u963b\u65ad\uff0c\u4fe1\u606fID:{}", (Object)this.sseBaseEvent.getId());
        this.sseBaseEvent.setIsOver(Boolean.valueOf(true));
        if (!this.sseBaseEvent.getIsScrumOver().booleanValue()) {
            this.sseBaseEvent.getScrumEventSource().cancel();
        }
        String answer = MessageUtil.getMessageByLanguage((Object)"message.adt.sse.service.timeout", (String)this.sseBaseEvent.getLang());
        EventData eventData = new EventData(SseAniaEventEnum.MESSAGE_DELTA.getEvent(), SseAniaEventEnum.SseEventDataTypeEnum.ANSWER.getType(), SseAniaEventEnum.EventDataMessageEnum.TEXT.getMessageType(), answer);
        SseEmitterUtils.send((SseEmitter)this.sseBaseEvent.getAniaEmitter(), (EventData)eventData);
        EventData doneData = new EventData(SseAniaEventEnum.CHAT_FAILED.getEvent(), null);
        SseEmitterUtils.send((SseEmitter)this.sseBaseEvent.getAniaEmitter(), (EventData)doneData);
    }
}

