/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.util.agileData;

import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Maps;
import com.knuddels.jtokkit.Encodings;
import com.knuddels.jtokkit.api.Encoding;
import com.knuddels.jtokkit.api.EncodingRegistry;
import com.knuddels.jtokkit.api.ModelType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class AgileDataExecuteDataRecord {
    private static final Logger log = LoggerFactory.getLogger(AgileDataExecuteDataRecord.class);
    private static final EncodingRegistry encodingRegistry = Encodings.newDefaultEncodingRegistry();

    private static int getTokenSize(String data) {
        Encoding secondEnc = encodingRegistry.getEncodingForModel(ModelType.TEXT_EMBEDDING_ADA_002);
        return secondEnc.countTokens(data);
    }

    public static void executeAgileData(AthenaMessageEvent event, Map<String, Object> adeResult, int tokenThreshold) {
        if (!event.isSseMessage()) {
            return;
        }
        if (MapUtils.isEmpty(adeResult)) {
            return;
        }
        Map contextMap = MapUtils.getMap(adeResult, (Object)"context");
        if (MapUtils.isEmpty((Map)contextMap)) {
            return;
        }
        Object dataObject = contextMap.get("pullData");
        if (dataObject == null) {
            return;
        }
        List dataList = (List)dataObject;
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return;
        }
        Map<String, List<Map>> groupMap = dataList.stream().collect(Collectors.groupingBy(map -> (String)map.get("actionId")));
        if (MapUtils.isEmpty(groupMap)) {
            return;
        }
        HashMap historyMap = Maps.newHashMap();
        Map data = Maps.newHashMap();
        Map metadata = Maps.newHashMap();
        for (List<Map> v : groupMap.values()) {
            Map metadataMap;
            Optional<Map> optionalMetadataMap;
            Map bkMap;
            Optional<Map> optionalBkMap = v.stream().filter(map -> MapUtils.getObject((Map)map, (Object)"data") != null).findFirst();
            if (optionalBkMap.isPresent() && MapUtils.isNotEmpty((Map)(bkMap = optionalBkMap.get()))) {
                data = MapUtils.getMap((Map)bkMap, (Object)"data");
            }
            if (!(optionalMetadataMap = v.stream().filter(map -> MapUtils.getObject((Map)map, (Object)"metadata") != null).findFirst()).isPresent() || !MapUtils.isNotEmpty((Map)(metadataMap = optionalMetadataMap.get()))) continue;
            metadata = MapUtils.getMap((Map)metadataMap, (Object)"metadata");
        }
        historyMap.putAll(data);
        historyMap.putAll(metadata);
        if (MapUtils.isEmpty((Map)data)) {
            return;
        }
        if (MapUtils.isEmpty((Map)metadata)) {
            return;
        }
        int tokenSize = AgileDataExecuteDataRecord.getTokenSize((String)JsonUtils.objectToString((Object)historyMap));
        event.setTokenSize(Integer.valueOf(tokenSize));
        if (tokenSize > tokenThreshold) {
            event.setExceedTokenThreshold(Boolean.valueOf(true));
        } else {
            event.setExceedTokenThreshold(Boolean.valueOf(false));
            try {
                AgileDataExecuteDataRecord.processData((Map)data, (Map)metadata);
                HashMap newData = Maps.newHashMap();
                newData.put("data", String.valueOf(data));
                event.setHistoryData((Map)newData);
            }
            catch (Exception e) {
                log.error("\u8f6c\u6362\u4e1a\u52a1\u6570\u636e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        }
    }

    private static void processData(Map<String, Object> data, Map<String, Object> metadata) {
        Map responseMetadata = MapUtils.getMap(metadata, (Object)"response");
        if (MapUtils.isEmpty((Map)responseMetadata)) {
            return;
        }
        Map responseRoot = MapUtils.getMap((Map)responseMetadata, (Object)"data");
        if (MapUtils.isEmpty((Map)responseRoot)) {
            return;
        }
        AgileDataExecuteDataRecord.changeData((Map)AgileDataExecuteDataRecord.layoutMetaData((Map)responseRoot), data);
    }

    private static Map<String, String> layoutMetaData(Map<String, Object> metadataMap) {
        HashMap layoutMetadataMap = Maps.newHashMap();
        String dataName = MapUtils.getString(metadataMap, (Object)"data_name");
        String dataType = MapUtils.getString(metadataMap, (Object)"data_type");
        if (StringUtils.pathEquals((String)"object", (String)dataType)) {
            List metadataList = (List)MapUtils.getObject(metadataMap, (Object)"field");
            metadataList.stream().forEach(map -> layoutMetadataMap.putAll(AgileDataExecuteDataRecord.layoutMetaData((Map)map)));
        } else {
            String description = MapUtils.getString(metadataMap, (Object)"description");
            layoutMetadataMap.put(dataName, description);
        }
        return layoutMetadataMap;
    }

    private static void changeData(Map<String, String> layoutMetadataMap, Map<String, Object> data) {
        HashMap newData = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String dataName = entry.getKey();
            Object dataValue = entry.getValue();
            if (dataValue instanceof List) {
                List tempList = (List)dataValue;
                tempList.forEach(map -> AgileDataExecuteDataRecord.changeData((Map)layoutMetadataMap, (Map)map));
                newData.put(dataName, dataValue);
                continue;
            }
            String description = layoutMetadataMap.get(dataName);
            if (description == null) continue;
            newData.put(description, dataValue);
        }
        data.clear();
        data.putAll(newData);
    }
}

