/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.util.message;

import com.digiwin.athena.adt.domain.po.SnapData;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.time.LocalDateTime;
import org.springframework.context.i18n.LocaleContextHolder;

public class MessageDTO {
    private AuthoredUser authoredUser;
    private String langName;
    private String name;
    private String id;
    private LocalDateTime alertTime;
    private Integer status;
    private String title;
    private String message;
    private String messageType;
    private String category;
    private Integer state;
    private Integer importance;

    public static MessageDTO builderDetectionMessage(SnapData snapData, AuthoredUser authoredUser) {
        MessageDTO messageDTO = new MessageDTO();
        messageDTO.setAuthoredUser(authoredUser);
        messageDTO.setMessageType("AGILE_DATA_DETAIL");
        messageDTO.setCategory("SIGN_NOTICE");
        messageDTO.setImportance(Integer.valueOf(0));
        messageDTO.setState(Integer.valueOf(0));
        messageDTO.setStatus(Integer.valueOf(0));
        messageDTO.setLangName(LocaleContextHolder.getLocale().toLanguageTag());
        messageDTO.setId(snapData.getSnapshotId());
        messageDTO.setName(MessageUtil.getMessageByLanguage((Object)snapData.getTitle(), (String)messageDTO.getLangName()));
        messageDTO.setAlertTime(snapData.getRequestTime());
        messageDTO.setTitle(snapData.getTitle());
        messageDTO.setMessage(snapData.getTitle());
        return messageDTO;
    }

    public AuthoredUser getAuthoredUser() {
        return this.authoredUser;
    }

    public String getLangName() {
        return this.langName;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public LocalDateTime getAlertTime() {
        return this.alertTime;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getTitle() {
        return this.title;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public String getCategory() {
        return this.category;
    }

    public Integer getState() {
        return this.state;
    }

    public Integer getImportance() {
        return this.importance;
    }

    public void setAuthoredUser(AuthoredUser authoredUser) {
        this.authoredUser = authoredUser;
    }

    public void setLangName(String langName) {
        this.langName = langName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAlertTime(LocalDateTime alertTime) {
        this.alertTime = alertTime;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public void setImportance(Integer importance) {
        this.importance = importance;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageDTO)) {
            return false;
        }
        MessageDTO other = (MessageDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        AuthoredUser this$authoredUser = this.getAuthoredUser();
        AuthoredUser other$authoredUser = other.getAuthoredUser();
        if (this$authoredUser == null ? other$authoredUser != null : !this$authoredUser.equals(other$authoredUser)) {
            return false;
        }
        String this$langName = this.getLangName();
        String other$langName = other.getLangName();
        if (this$langName == null ? other$langName != null : !this$langName.equals(other$langName)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        LocalDateTime this$alertTime = this.getAlertTime();
        LocalDateTime other$alertTime = other.getAlertTime();
        if (this$alertTime == null ? other$alertTime != null : !((Object)this$alertTime).equals(other$alertTime)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$messageType = this.getMessageType();
        String other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !this$messageType.equals(other$messageType)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        Integer this$state = this.getState();
        Integer other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
            return false;
        }
        Integer this$importance = this.getImportance();
        Integer other$importance = other.getImportance();
        return !(this$importance == null ? other$importance != null : !((Object)this$importance).equals(other$importance));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AuthoredUser $authoredUser = this.getAuthoredUser();
        result = result * 59 + ($authoredUser == null ? 43 : $authoredUser.hashCode());
        String $langName = this.getLangName();
        result = result * 59 + ($langName == null ? 43 : $langName.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        LocalDateTime $alertTime = this.getAlertTime();
        result = result * 59 + ($alertTime == null ? 43 : ((Object)$alertTime).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : $messageType.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        Integer $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        Integer $importance = this.getImportance();
        result = result * 59 + ($importance == null ? 43 : ((Object)$importance).hashCode());
        return result;
    }

    public String toString() {
        return "MessageDTO(authoredUser=" + this.getAuthoredUser() + ", langName=" + this.getLangName() + ", name=" + this.getName() + ", id=" + this.getId() + ", alertTime=" + this.getAlertTime() + ", status=" + this.getStatus() + ", title=" + this.getTitle() + ", message=" + this.getMessage() + ", messageType=" + this.getMessageType() + ", category=" + this.getCategory() + ", state=" + this.getState() + ", importance=" + this.getImportance() + ")";
    }
}

