/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.constant;

import com.digiwin.athena.appcore.constant.ErrorTypeEnum;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atmc.http.domain.calendar.model.PermissionException;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public enum ErrorCodeEnum {
    AAM_UPLOAD_AGILEDATA_FAIL("P.ADT.901.0001", "\u8c03\u7528aam\u7684uploadAgileReport\u63a5\u53e3\u4e0a\u4f20\u6587\u6863\u5931\u8d25"),
    AAM_GET_AGILEDATA_FAIL("P.ADT.901.0002", "\u8c03\u7528aam\u7684getAgileReportInfo\u63a5\u53e3\u83b7\u53d6\u6587\u6863\u4e2d\u5fc3\u654f\u6377\u6570\u636e\u5931\u8d25"),
    AAM_DELETE_AGILEDATA_FAIL("P.ADT.901.0003", "\u8c03\u7528aam\u7684deleteAgileReportInfo\u63a5\u53e3\u5220\u9664\u654f\u6377\u62a5\u8868\u6570\u636e\u5931\u8d25"),
    AAM_BATCHDELETE_AGILEDATA_FAIL("P.ADT.901.0004", "\u8c03\u7528aam\u7684delete\u6279\u91cf\u5220\u9664\u654f\u6377\u62a5\u8868\u6570\u636e\u5931\u8d25"),
    UIBOT_DATA_AGILEDATA_FAIL("P.ADT.901.0005", "\u8c03\u7528uibot\u7684\u8865\u507f\u6570\u636e\u63a5\u53e3\u5931\u8d25"),
    ADE_GET_SNAPDATA_FAIL("P.ADT.902.0001", "\u8bf7\u6c42ade\u4f20\u5165sdScencDTO\u83b7\u53d6\u654f\u6377\u6570\u636esnapShotDTO\u5931\u8d25"),
    ADE_REALTIME_SNAPDATA_FAIL("P.ADT.902.0002", "503 \u8bf7\u6c42ade\u5931\u8d25"),
    ADE_REALTIME_SQL_FAIL("P.ADT.902.0003", "\u83b7\u53d6\u67e5\u8be2\u65b9\u6848\u7684SQL\u5931\u8d25"),
    ADE_REALTIME_TIME_OUT_FAIL("P.ADT.902.0004", "503 \u8bf7\u6c42ade\u8d85\u65f6"),
    CHATBI_QUERY_FAIL("P.ADT.903.0001", "\u4f20\u5165\u6587\u672c\u4fe1\u606f\u83b7\u53d6chatBI\u8fd4\u56de\u7ed3\u679c\u5931\u8d25,\u5165\u53c2{text:\u5e2e\u6211\u9884\u6d4b\u5929\u6c14}"),
    KM_GET_TITLE_FAIL("P.ADT.904.0001", "\u6839\u636ecode\u83b7\u53d6snapData\u7684title\u5931\u8d25"),
    KM_GET_CODE_FAIL("P.ADT.904.0002", "\u83b7\u53d6\u573a\u666fcode\u5931\u8d25"),
    KM_GET_TIME_OUT_FAIL("P.ADT.904.0003", "\u8c03\u7528km\u63a5\u53e3\u83b7\u53d6\u4fe1\u606f\u8d85\u65f6"),
    SEMC_SEND_MESSAGE_FAIL("P.ADT.905.0001", "\u53d1\u9001sendMessageDTO\u5931\u8d25"),
    DMCID_CAN_NOT_FIND("P.ADT.500.0001", "\u6570\u636e\u5e93\u4e2d\u672a\u67e5\u8be2\u5230DmcId"),
    WHO_IS_EMPTY("P.ADT.500.0002", "who\u6570\u636e\u4e3a\u7a7a!"),
    DELETE_SNAP_IS_EMPTY("P.ADT.500.0003", "\u67e5\u4e0d\u5230\u8be5snapdata"),
    USERINFO_IS_EMPTY("P.ADT.500.0004", "\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728"),
    CAC_REALTIME_FAIL("P.ADT.905.0001", "\u8bf7\u6c42cac\u8d85\u65f6"),
    CAC_GET_FAIL("P.ADT.905.0002", "\u8bf7\u6c42cac\u5931\u8d25"),
    CAC_REALTIME_DECREASE_FAIL("P.ADT.905.0003", "\u8bf7\u6c42cac\u8d85\u65f6"),
    CAC_DECREASE_FAIL("P.ADT.905.0004", "\u8bf7\u6c42cac\u5931\u8d25"),
    TDD_REALTIME_FAIL("P.ADT.906.0001", "\u8bf7\u6c42tdd\u8d85\u65f6"),
    TDD_GET_FAIL("P.ADT.906.0002", "\u8bf7\u6c42tdd\u5931\u8d25"),
    ECHO_REALTIME_FAIL("P.ADT.907.0001", "\u8bf7\u6c42echo\u8d85\u65f6"),
    ECHO_GET_FAIL("P.ADT.907.0002", "\u8bf7\u6c42echo\u5931\u8d25"),
    KM_GET_PURCHASE_FAIL("P.ADT.908.0001", "\u6839\u636etoken\u83b7\u53d6km \u5e94\u7528\u5931\u8d25"),
    IAM_USER_INFO_FAIL("P.ADT.910.0001", "\u8bf7\u6c42IAM \u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25"),
    UPLOAD_DMC_ERROR("P.ADT.911.0001", "\u8bf7\u6c42DMC \u4e0a\u4f20\u9644\u4ef6\u5931\u8d25 "),
    TRANS_DATA_ERROR("P.ADT.921.0001", "\u83b7\u53d6\u8f6c\u6362\u6570\u636e\u5931\u8d25");

    private String errCode;
    private String errMsg;
    private static MessageSource messageSource;

    private ErrorCodeEnum(String errCode, String errMsg) {
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    public BusinessException getBusinessException() {
        return BusinessException.create((String)this.getErrCode(), (String)messageSource.getMessage(this.getErrCode(), null, this.getErrMsg(), LocaleContextHolder.getLocale()));
    }

    public BusinessException getBusinessException(ErrorTypeEnum errorTypeEnum) {
        return BusinessException.create((String)this.getErrCode(), (String)messageSource.getMessage(this.getErrCode(), null, this.getErrMsg(), LocaleContextHolder.getLocale()), (String)errorTypeEnum.getValue());
    }

    public BusinessException getBusinessExceptionWithArgs(Object ... paras) {
        return BusinessException.create((String)this.getErrCode(), (String)messageSource.getMessage(this.getErrCode(), paras, LocaleContextHolder.getLocale()));
    }

    public BusinessException getBusinessException(String errorMessage) {
        return BusinessException.create((String)this.getErrCode(), (String)errorMessage);
    }

    public PermissionException getPermissionException() {
        return new PermissionException(Integer.parseInt(this.getErrCode()), messageSource.getMessage(this.getErrCode(), null, this.getErrMsg(), LocaleContextHolder.getLocale()));
    }

    public PermissionException getPermissionException(String errorMsg) {
        return new PermissionException(Integer.parseInt(this.getErrCode()), errorMsg);
    }

    public String getErrCode() {
        return this.errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    static {
        messageSource = (MessageSource)SpringUtil.getBean(MessageSource.class);
    }
}

