/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.controller;

import com.digiwin.athena.adt.agileReport.service.ChartSnapshotService;
import com.digiwin.athena.adt.domain.dto.mongo.AgileDataChartSnapshot;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import javax.validation.constraints.NotBlank;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ai/agileData/chartSnapshot"})
public class ChartSnapshotController {
    @Autowired
    private ChartSnapshotService chartSnapshotService;

    @PostMapping(value={"/save"})
    public ResponseEntity<?> save(@RequestBody @Validated AgileDataChartSnapshot snapshot, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        this.chartSnapshotService.saveSnapshot(snapshot);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/get"})
    public ResponseEntity<?> get(@RequestParam(value="snapshotId") @NotBlank String snapshotId, @RequestParam(value="chartType") @NotBlank String chartType, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.chartSnapshotService.getBySnapshotId(snapshotId, chartType));
    }
}

