/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.controller.ania;

import com.digiwin.athena.adt.agileReport.service.AniaAssistantService;
import com.digiwin.athena.adt.domain.dto.ania.AniaAssistantReqDTO;
import com.digiwin.athena.adt.domain.dto.ania.AniaVersionReqDTO;
import com.digiwin.athena.adt.domain.dto.mongo.AgileDataCustomConfig;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ai/agileData"})
public class AniaAssistantController {
    @Autowired
    private AniaAssistantService aniaAssistantService;

    @PostMapping(value={"/assistant/getPublishedInfo"})
    public ResponseEntity<?> getPublishedInfo(@RequestBody AniaAssistantReqDTO req, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.aniaAssistantService.getPublishedInfo(req, user));
    }

    @PostMapping(value={"/mongo/saveCustomConfig"})
    public ResponseEntity<?> saveCustomConfig(@RequestBody @Validated AgileDataCustomConfig agileDataCustomConfig, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        this.aniaAssistantService.saveCustomConfig(agileDataCustomConfig, user);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/mongo/get/customConfig"})
    public ResponseEntity<?> getMongoCustomConfig(@RequestBody @Validated AgileDataCustomConfig agileDataCustomConfig, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.aniaAssistantService.getMongoCustomConfig(agileDataCustomConfig, user));
    }

    @PostMapping(value={"/mongo/deleteMongoCustomConfig"})
    public ResponseEntity<?> deleteMongoCustomConfig(@RequestBody @Validated AgileDataCustomConfig agileDataCustomConfig, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        this.aniaAssistantService.deleteMongoCustomConfig(agileDataCustomConfig, user);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/assistant/getVersion"})
    public ResponseEntity<?> getVersion(@RequestBody AniaVersionReqDTO req, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.aniaAssistantService.getVersion(req, user));
    }

    @PostMapping(value={"/assistant/getInspirationPhrases"})
    public ResponseEntity<?> getInspirationPhrases(@RequestBody AniaAssistantReqDTO req, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.aniaAssistantService.getInspirationPhrases(req, user));
    }
}

