/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.controller.report;

import com.digiwin.athena.adt.agileReport.controller.dto.AthenaApcMessageReqDTO;
import com.digiwin.athena.adt.agileReport.service.AgileApcDataService;
import com.digiwin.athena.adt.domain.dto.apc.AgileApcDataEocMap;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ai/agile/apc"})
public class AgileApcDataController {
    @Autowired
    private AgileApcDataService agileApcDataService;

    @PostMapping(value={"/processMessage"})
    public ResponseEntity<?> processMessage(HttpServletRequest request, @RequestBody AthenaApcMessageReqDTO req, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        String locale = request.getHeader("locale");
        Objects.requireNonNull(req, "\u4f20\u5165\u7684AthenaApcMessageReqDTO\u4e3a\u7a7a\uff01");
        if (CollectionUtils.isEmpty((Collection)req.getEocMaps())) {
            AgileApcDataEocMap agileApcDataEocMap = new AgileApcDataEocMap();
            agileApcDataEocMap.setEocSiteId(MapUtils.getString((Map)req.getEocMap(), (Object)"eocSiteId"));
            agileApcDataEocMap.setEocCompanyId(MapUtils.getString((Map)req.getEocMap(), (Object)"eocCompanyId"));
            req.setEocMaps((List)Lists.newArrayList((Object[])new AgileApcDataEocMap[]{agileApcDataEocMap}));
        }
        if (StringUtils.isEmpty((CharSequence)req.getRequestType())) {
            req.setRequestType("sync-snapshot");
        }
        return ResponseEntityWrapper.wrapperOk((Object)this.agileApcDataService.processMessage(request, req, user, locale));
    }
}

