/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.controller.report;

import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataPPTReq;
import com.digiwin.athena.adt.agileReport.controller.dto.file.AgileDataGenerateReq;
import com.digiwin.athena.adt.agileReport.service.AgileDataPPTService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ai/agileData/anasisly"})
public class AgileDataPPTController {
    @Autowired
    private AgileDataPPTService agileDataPPTService;

    @PostMapping(value={"/getAnasislyQuestion"})
    public ResponseEntity<?> getAnasislyQuestion(HttpServletRequest request, @RequestBody AgileDataPPTReq agileDataPPTReq, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        Objects.requireNonNull(agileDataPPTReq, "\u4f20\u5165\u7684\u91cd\u65b0\u89c4\u5212\u6570\u636e\u4e3a\u7a7a\uff01");
        String locale = request.getHeader("locale");
        return ResponseEntityWrapper.wrapperOk((Object)this.agileDataPPTService.getPPTAnalyze(user, agileDataPPTReq, locale));
    }

    @PostMapping(value={"/generateAgileDataFile"})
    public ResponseEntity<?> generateAgileDataFile(HttpServletRequest request, @RequestBody AgileDataGenerateReq agileDataGenerateReq, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        Objects.requireNonNull(agileDataGenerateReq, "\u4f20\u5165\u7684\u751f\u6210ppt\u6570\u636e\u4e3a\u7a7a\uff01");
        String locale = request.getHeader("locale");
        return ResponseEntityWrapper.wrapperOk((Object)this.agileDataPPTService.generatePPT(user, agileDataGenerateReq, locale));
    }
}

