/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.event;

import com.digiwin.athena.adt.agileReport.event.domain.EventSubscribeDTO;
import com.digiwin.athena.adt.agileReport.event.service.impl.SubscribeEventImpl;
import com.digiwin.athena.adt.agileReport.service.EventBaseService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/api/test/ptm"})
public class EventMqTestController {
    private static final Logger log = LoggerFactory.getLogger(EventMqTestController.class);
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private EventBaseService eventBaseService;
    @Autowired
    private SubscribeEventImpl subscribeEvent;

    @PostMapping(value={"/mq/send"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> mockMqSend(@RequestBody String data, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        this.rabbitTemplate.convertAndSend("athena.event.message", "athena.event.message.adt.subscribe", (Object)data);
        return ResponseEntity.ok((Object)data);
    }

    @PostMapping(value={"/mq/message"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> mockMqMessage(@RequestBody String data, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        try {
            this.eventBaseService.receiveOrder(data, null, null, 0L, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ResponseEntity.ok((Object)data);
    }

    @PostMapping(value={"/mq/send/subscribe"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<?> subscribe(@RequestBody String data, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        EventSubscribeDTO subscribeDTO = new EventSubscribeDTO();
        subscribeDTO.setMsgType("agileSubscribe");
        HashMap<String, String> msgBody = new HashMap<String, String>();
        msgBody.put("text", "\u4eca\u5e74\u7684\u8425\u6536\u91d1\u989d");
        HashMap<String, Object> msgExt = new HashMap<String, Object>();
        msgExt.put("question", "\u4eca\u5e74\u7684\u8425\u6536\u91d1\u989d");
        msgExt.put("sceneCode", "S202405130010");
        msgExt.put("multiDialogue", false);
        msgExt.put("userName", "\u6797\u5ddd");
        msgExt.put("type", "agileSubscribe");
        msgExt.put("userId", "wangchaom@digiwin.com");
        msgExt.put("tenantId", "AthenaHZTest");
        subscribeDTO.setMsgBody(msgBody);
        subscribeDTO.setMsgExt(msgExt);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("token", "e9f750bc-ffef-42e8-a616-1fe8c6bd1d7b");
        this.subscribeEvent.processMessage(subscribeDTO, headers);
        return ResponseEntity.ok((Object)data);
    }
}

