/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.event.report;

import com.digiwin.athena.adt.agileReport.event.service.ReportEventListenerService;
import com.digiwin.athena.adt.agileReport.service.EventBaseService;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.stereotype.Component;

@Component
public class ReportEventListener
extends EventBaseService {
    private static final Logger log = LoggerFactory.getLogger(ReportEventListener.class);
    @Autowired
    private ReportEventListenerService eventListenerService;

    @RabbitListener(bindings={@QueueBinding(value=@Queue(value="athena.event.message.adt", durable="true", autoDelete="false"), exchange=@Exchange(value="athena.event.message", type="topic"), key={"athena.event.message.adt"})}, ackMode="MANUAL", concurrency="2-4")
    public void receiveOrder(String data, Channel channel, @Header(value="amqp_deliveryTag") long tag, @Headers Map<String, Object> headers) throws IOException {
        super.receiveOrder(data, "athena.event.message.adt", channel, tag, headers);
    }

    @RabbitListener(bindings={@QueueBinding(value=@Queue(value="athena.event.message.adt.subscribe", durable="true", autoDelete="false"), exchange=@Exchange(value="athena.event.message", type="topic"), key={"athena.event.message.adt.subscribe"})}, ackMode="MANUAL", concurrency="2-4")
    public void subscribe(String data, Channel channel, @Header(value="amqp_deliveryTag") long tag, @Headers Map<String, Object> headers) throws IOException {
        super.receiveOrder(data, "athena.event.message.adt.subscribe", channel, tag, headers);
    }

    public void processMessage(String data, String queueName, Map<String, Object> headers) {
        this.eventListenerService.processMsg(data, queueName, headers);
        LogDto logDto = new LogDto("\u6d88\u8d39\u6d88\u606f\u6210\u529f", data);
        log.info(logDto.toString());
    }
}

