/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.event.service.impl;

import com.digiwin.athena.adt.agileReport.constant.AgileDataSourceEnum;
import com.digiwin.athena.adt.agileReport.controller.dto.AthenaMessageDTO;
import com.digiwin.athena.adt.agileReport.event.domain.EventSubscribeDTO;
import com.digiwin.athena.adt.agileReport.event.service.EventInterface;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataMessageService;
import com.digiwin.athena.adt.domain.report.impl.AbsAgileEventProcess;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class SubscribeEventImpl
extends AbsAgileEventProcess
implements EventInterface {
    private static final Logger log = LoggerFactory.getLogger(SubscribeEventImpl.class);
    @Autowired
    @Qualifier(value="asyncServiceExecutor")
    private ExecutorService executor;
    @Autowired
    private AgileDataMessageService agileDataMessageService;

    public String modelType() {
        return "athena.event.message.adt.subscribe";
    }

    public void distributeMessages(String data, Map<String, Object> headers) {
        log.info("[athena.event.message.adt-distributeMessages]: data {}", (Object)JsonUtils.objectToString((Object)data));
        EventSubscribeDTO subscribeDTO = (EventSubscribeDTO)JsonUtils.jsonToObject((String)data, EventSubscribeDTO.class);
        if (subscribeDTO != null) {
            this.processMessage(subscribeDTO, headers);
        }
    }

    public void processMessage(EventSubscribeDTO subscribeDTO, Map<String, Object> headers) {
        LogUtils.buildAgileLog((String)"adt", (String)"receiveQuestion", (String)"1", (String)JsonUtils.objectToString((Object)subscribeDTO), (String)"\u8ba2\u9605\u6d88\u606f\u8bf7\u6c42", (String)"");
        String token = String.valueOf(headers.get("token"));
        AuthoredUser adtUser = new AuthoredUser();
        adtUser.setToken(token);
        adtUser.setUserId(String.valueOf(subscribeDTO.getMsgExt().get("userId")));
        adtUser.setUserName(String.valueOf(subscribeDTO.getMsgExt().get("userName")));
        adtUser.setTenantId(String.valueOf(subscribeDTO.getMsgExt().get("tenantId")));
        adtUser.setTenantName(String.valueOf(subscribeDTO.getMsgExt().get("tenantName")));
        AthenaMessageDTO athenaMessageDTO = new AthenaMessageDTO();
        BeanUtils.copyProperties((Object)subscribeDTO, (Object)athenaMessageDTO);
        athenaMessageDTO.setAppCode(String.valueOf(subscribeDTO.getTo().get("appCode")));
        athenaMessageDTO.setAsaCode(String.valueOf(subscribeDTO.getMsgExt().get("asaCode")));
        AthenaMessageEvent event = this.init(null, athenaMessageDTO, adtUser);
        event.setSubscribe(true);
        event.setSendNana(false);
        event.setSourceName(AgileDataSourceEnum.SUBSCRIBER.getName());
        event.setSourceCode(AgileDataSourceEnum.SUBSCRIBER.getCode());
        event.setAppCode(String.valueOf(subscribeDTO.getTo().get("appCode")));
        Object snapshotId = subscribeDTO.getMsgExt().get("snapshotId");
        this.executor.submit(() -> {
            if (Objects.isNull(snapshotId)) {
                this.agileDataMessageService.process(event);
            } else {
                this.agileDataMessageService.processSubscribeV2(event, subscribeDTO);
            }
        });
    }

    public void consumeMessage(String data, Channel channel, long tag) throws IOException {
    }
}

