/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.eventbus.subscriber;

import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataMessageService;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AthenaMessageSendEventSubscriber {
    private static final Logger log = LoggerFactory.getLogger(AthenaMessageSendEventSubscriber.class);
    @Autowired
    private AgileDataMessageService agileDataMessageService;

    @Subscribe
    @AllowConcurrentEvents
    public void subscriber(AthenaMessageEvent event) {
        try {
            AppAuthContextHolder.clearContext();
            this.processEvent(event);
        }
        catch (Exception ex) {
            log.error("\u6d88\u606f\u63a8\u9001\u7ed3\u675f error:{}, stack:{}\uff0cevent:{}", new Object[]{ex, ex.getStackTrace(), event});
        }
        finally {
            AppAuthContextHolder.clearContext();
        }
    }

    public void processEvent(AthenaMessageEvent event) {
        log.info("AthenaMessageSendEventSubscriber processEvent \uff1a{} ", (Object)JsonUtils.objectToString((Object)event));
        this.agileDataMessageService.process(event);
    }
}

