/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.aiBoard;

import com.digiwin.athena.adt.agileReport.controller.dto.AIBoardGenerateRes;
import com.digiwin.athena.adt.agileReport.service.AIBoardService;
import com.digiwin.athena.adt.domain.dto.aiBoard.AIBoardDTO;
import com.digiwin.athena.adt.domain.dto.km.AgileDataQueryBoardAddDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.knowledge.KmService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AIBoardServiceImpl
implements AIBoardService {
    @Autowired
    private EchoService echoService;
    @Autowired
    private KmService kmService;

    public AIBoardGenerateRes generateAIBoard(AuthoredUser authoredUser, Long messageId, String locale) {
        Map addResult;
        AIBoardGenerateRes aiBoardGenerateRes = new AIBoardGenerateRes();
        aiBoardGenerateRes.setResult(Boolean.valueOf(true));
        HashMap queryParams = Maps.newHashMap();
        queryParams.put("messageId", messageId);
        AIBoardDTO aiBoardDTO = this.echoService.getAIBoard((Map)queryParams, authoredUser.getToken(), authoredUser.getTenantId());
        if (aiBoardDTO == null) {
            aiBoardGenerateRes.setResult(Boolean.valueOf(false));
            aiBoardGenerateRes.setErrorMessage("\u672a\u67e5\u8be2\u5230\u8be5\u770b\u677f\u4fe1\u606f\uff0c\u65e0\u6cd5\u751f\u6210");
            return aiBoardGenerateRes;
        }
        AgileDataQueryBoardAddDTO boardAddDTO = new AgileDataQueryBoardAddDTO();
        AgileDataQueryBoardAddDTO.BoardConfig config = new AgileDataQueryBoardAddDTO.BoardConfig();
        config.setAsaCode(aiBoardDTO.getAppCode());
        config.setBoardName(aiBoardDTO.getBoardTitle());
        config.setMessageId(aiBoardDTO.getMessageId());
        config.setDataEntry("aiBoard");
        config.setUserId(authoredUser.getUserId());
        config.setTenantId(authoredUser.getTenantId());
        ArrayList dataBoardQuestions = Lists.newArrayList();
        config.setDataBoardQuestions((List)dataBoardQuestions);
        boardAddDTO.setConfig(config);
        if (CollectionUtils.isNotEmpty((Collection)aiBoardDTO.getQuestionInfo())) {
            aiBoardDTO.getQuestionInfo().forEach(questionInfo -> {
                if (questionInfo.getAnalyzeStatus() == null || questionInfo.getAnalyzeStatus() != 0) {
                    return;
                }
                AgileDataQueryBoardAddDTO.DataBoardQuestion dataBoardQuestion = new AgileDataQueryBoardAddDTO.DataBoardQuestion();
                dataBoardQuestion.setAppCode(aiBoardDTO.getAppCode());
                HashMap dataParam = Maps.newHashMap();
                dataParam.put("questionId", questionInfo.getQuestionId());
                dataParam.put("adeRequest", questionInfo.getGetDataParams());
                dataBoardQuestion.setDataParam((Map)dataParam);
                dataBoardQuestion.setQuestion(questionInfo.getQuestion());
                dataBoardQuestion.setFilterAnalysis(Boolean.valueOf(false));
                dataBoardQuestions.add(dataBoardQuestion);
            });
        }
        if (MapUtils.isEmpty((Map)(addResult = this.kmService.addBoardInfo(authoredUser, boardAddDTO)))) {
            aiBoardGenerateRes.setResult(Boolean.valueOf(false));
            aiBoardGenerateRes.setErrorMessage("\u751f\u6210\u770b\u677f\u5931\u8d25");
        }
        Map response = MapUtils.getMap((Map)addResult, (Object)"response");
        String boardId = MapUtils.getString((Map)response, (Object)"boardId");
        aiBoardGenerateRes.setBoardId(boardId);
        AIBoardDTO updateAiBoardDTO = new AIBoardDTO();
        updateAiBoardDTO.setBoardId(boardId);
        updateAiBoardDTO.setMessageId(messageId);
        this.echoService.updateAIBoard(updateAiBoardDTO, authoredUser.getToken(), authoredUser.getTenantId());
        return aiBoardGenerateRes;
    }
}

