/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.autoData;

import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataAutoDataReq;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataAutoDataRes;
import com.digiwin.athena.adt.agileReport.controller.dto.AniaAssistantChatReqDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AutoDataDownLoadDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AutoDataDownLoadReq;
import com.digiwin.athena.adt.agileReport.controller.dto.AutoDataGenerateReportReq;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataAutoDataService;
import com.digiwin.athena.adt.agileReport.service.AgileDataMessageService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.domain.dmc.DmcService;
import com.digiwin.athena.adt.domain.dto.agileDataProcess.AgileDataProcessResDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.BizParamsDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.ContextDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.PullDataDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.dto.autoData.AgileDataAutoDataDTO;
import com.digiwin.athena.adt.domain.dto.autoData.AgileDataAutoDataReportDTO;
import com.digiwin.athena.adt.domain.dto.km.ThemeMapBoardDTO;
import com.digiwin.athena.adt.domain.dto.schema.SchemaMetricShowDefine;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.file.FileParsingService;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgileDataAutoDataServiceImpl
extends AbsAgileDataProcess
implements AgileDataAutoDataService {
    private static final Logger log = LoggerFactory.getLogger(AgileDataAutoDataServiceImpl.class);
    @Autowired
    private AgileDataMessageService agileDataMessageService;
    @Autowired
    private EchoService echoService;
    @Autowired
    private MessageUtil messageUtil;
    @Autowired
    private FileParsingService fileParsingService;
    @Autowired
    private DmcService dmcService;

    public AgileDataAutoDataRes getData(HttpServletRequest request, AuthoredUser authoredUser, AgileDataAutoDataReq autoDataReq) {
        log.info("\u83b7\u53d6\u6267\u884c\u5b9e\u65f6\u603b\u7ed3\u6570\u636e\u5165\u53c2\uff1a{}", (Object)JsonUtils.objectToString((Object)autoDataReq));
        AgileDataAutoDataRes agileDataAutoDataRes = new AgileDataAutoDataRes();
        agileDataAutoDataRes.setQueryResult(Boolean.valueOf(true));
        AniaAssistantChatReqDTO aniaAssistantChatReqDTO = this.buildAutoDataQuestionParams(request, autoDataReq);
        SnapShotDTO snapshotInfo = this.buildAutoDataSnapParams(autoDataReq);
        ThemeMapBoardDTO themeMapBoardDTO = this.buildAutoDataBoardParams(autoDataReq);
        AthenaMessageEvent event = this.assemblyVersionInitEvent(request, aniaAssistantChatReqDTO, authoredUser);
        AgileDataProcessResDTO res = this.agileDataMessageService.processResV2(event, snapshotInfo, themeMapBoardDTO, null);
        if (res.getPanelMap() == null || res.getPanelMap().getContext() == null || res.getPanelMap().getContext().getBizParams() == null || CollectionUtils.isEmpty((Collection)res.getPanelMap().getContext().getPullData())) {
            agileDataAutoDataRes.setQueryResult(Boolean.valueOf(false));
            return agileDataAutoDataRes;
        }
        PullDataDTO pullDataDTO = res.getPanelMap().getContext().getPullData().stream().findFirst().orElse(null);
        if (pullDataDTO == null) {
            agileDataAutoDataRes.setQueryResult(Boolean.valueOf(false));
            return agileDataAutoDataRes;
        }
        agileDataAutoDataRes.setExceedSummarizeSize(res.getPanelMap().getContext().getBizParams().getExceedSummarizeSize());
        agileDataAutoDataRes.setSummarizeData(pullDataDTO.getSummarizeData());
        return agileDataAutoDataRes;
    }

    public AgileDataAutoDataDTO getReportData(HttpServletRequest request, AuthoredUser authoredUser, AutoDataGenerateReportReq autoDataReq) {
        AgileDataAutoDataDTO autoDataDTO = new AgileDataAutoDataDTO();
        autoDataDTO.setMessageId(autoDataReq.getMessageId());
        autoDataDTO.setStatus("0");
        AgileDataAutoDataDTO data = this.echoService.getAutoDataReport(authoredUser, autoDataDTO);
        if (StringUtils.isEmpty((CharSequence)data.getShowDmcId())) {
            return data;
        }
        Map dmcAgileData = this.dmcService.getDmcAgileData(data.getShowDmcId());
        data.setAutoDataAnalyzeText(this.buildHistoryText(dmcAgileData));
        data.setAutoDataAnalyzeList(this.buildHistoryList(dmcAgileData));
        return data;
    }

    public AutoDataDownLoadDTO getDownLoadInfo(HttpServletRequest request, AuthoredUser authoredUser, AutoDataDownLoadReq req) {
        String locale = request.getHeader("locale");
        AutoDataDownLoadDTO autoDataDownLoad = new AutoDataDownLoadDTO();
        AgileDataAutoDataDTO autoDataDTO = new AgileDataAutoDataDTO();
        autoDataDTO.setMessageId(req.getMessageId());
        autoDataDTO.setStatus("0");
        AgileDataAutoDataDTO agileDataAutoDataDTO = this.echoService.getAutoDataReport(authoredUser, autoDataDTO);
        if (agileDataAutoDataDTO == null) {
            log.error("\u5206\u6790\u5e08\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u6d88\u606fID:{}", (Object)req.getMessageId());
            autoDataDownLoad.setResult(Boolean.valueOf(false));
            autoDataDownLoad.setMessage(this.messageUtil.getMessageByLangNameWithFormat("message.adt.getDownLoadReport.error", locale, new Object[0]));
            return autoDataDownLoad;
        }
        if (StringUtils.equals((CharSequence)"pdf", (CharSequence)req.getDownLoadType()) && StringUtils.isNotEmpty((CharSequence)agileDataAutoDataDTO.getPdfUrl())) {
            autoDataDownLoad.setResult(Boolean.valueOf(true));
            autoDataDownLoad.setDownLoadUrl(agileDataAutoDataDTO.getPdfUrl());
            autoDataDownLoad.setCreateData(agileDataAutoDataDTO.getPdfCreateDate());
            autoDataDownLoad.setExpireData(agileDataAutoDataDTO.getPdfExpireDate());
            autoDataDownLoad.setLimitDay(agileDataAutoDataDTO.getLimitDay());
            return autoDataDownLoad;
        }
        if (StringUtils.equals((CharSequence)"docx", (CharSequence)req.getDownLoadType()) && StringUtils.isNotEmpty((CharSequence)agileDataAutoDataDTO.getWordUrl())) {
            autoDataDownLoad.setResult(Boolean.valueOf(true));
            autoDataDownLoad.setDownLoadUrl(agileDataAutoDataDTO.getWordUrl());
            autoDataDownLoad.setCreateData(agileDataAutoDataDTO.getWordCreateDate());
            autoDataDownLoad.setExpireData(agileDataAutoDataDTO.getWordExpireDate());
            autoDataDownLoad.setLimitDay(agileDataAutoDataDTO.getLimitDay());
            return autoDataDownLoad;
        }
        if (StringUtils.isEmpty((CharSequence)agileDataAutoDataDTO.getShowDmcId())) {
            log.error("\u5206\u6790\u5e08DMC\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u6d88\u606fID:{}", (Object)req.getMessageId());
            autoDataDownLoad.setResult(Boolean.valueOf(false));
            autoDataDownLoad.setMessage(this.messageUtil.getMessageByLangNameWithFormat("message.adt.getDownLoadReport.error", locale, new Object[0]));
            return autoDataDownLoad;
        }
        Map processStreamData = this.dmcService.getDmcAgileData(agileDataAutoDataDTO.getShowDmcId());
        Map reportGeneration = MapUtils.getMap((Map)processStreamData, (Object)"reportGeneration");
        String markdown = MapUtils.getString((Map)reportGeneration, (Object)"content");
        HashMap params = Maps.newHashMap();
        params.put("userId", authoredUser.getUserId());
        params.put("tenantId", authoredUser.getTenantId());
        params.put("fileName", agileDataAutoDataDTO.getFileName());
        params.put("markdownData", markdown);
        params.put("fileType", req.getDownLoadType());
        AgileDataAutoDataReportDTO agileDataAutoDataReportDTO = this.fileParsingService.getFileParsingAutoDataReport(authoredUser.getTenantId(), authoredUser.getToken(), locale, (Map)params);
        if (agileDataAutoDataReportDTO == null || !StringUtils.equals((CharSequence)"200", (CharSequence)agileDataAutoDataReportDTO.getCode())) {
            log.error("\u83b7\u53d6\u5206\u6790\u5e08\u62a5\u544a\u5931\u8d25\uff1a\u5206\u6790\u5165\u53c2\uff1a{}", (Object)JsonUtils.objectToString((Object)params));
            autoDataDownLoad.setResult(Boolean.valueOf(false));
            if (agileDataAutoDataReportDTO == null) {
                autoDataDownLoad.setMessage(this.messageUtil.getMessageByLangNameWithFormat("message.adt.getDownLoadReport.error", locale, new Object[0]));
            } else {
                autoDataDownLoad.setMessage(agileDataAutoDataReportDTO.getMessage());
            }
            return autoDataDownLoad;
        }
        AgileDataAutoDataDTO updateAutoDataDTO = new AgileDataAutoDataDTO();
        updateAutoDataDTO.setMessageId(req.getMessageId());
        updateAutoDataDTO.setLimitDay(agileDataAutoDataReportDTO.getData().getLimitDay());
        if (StringUtils.equals((CharSequence)"pdf", (CharSequence)req.getDownLoadType())) {
            updateAutoDataDTO.setPdfUrl(agileDataAutoDataReportDTO.getData().getPdf().getUrl());
            updateAutoDataDTO.setPdfCreateDate(agileDataAutoDataReportDTO.getData().getPdf().getCreateDate());
            updateAutoDataDTO.setPdfExpireDate(agileDataAutoDataReportDTO.getData().getPdf().getExpireDate());
            autoDataDownLoad.setDownLoadUrl(agileDataAutoDataReportDTO.getData().getPdf().getUrl());
            autoDataDownLoad.setCreateData(agileDataAutoDataReportDTO.getData().getPdf().getCreateDate());
            autoDataDownLoad.setExpireData(agileDataAutoDataReportDTO.getData().getPdf().getExpireDate());
            autoDataDownLoad.setLimitDay(agileDataAutoDataReportDTO.getData().getLimitDay());
        }
        if (StringUtils.equals((CharSequence)"docx", (CharSequence)req.getDownLoadType())) {
            updateAutoDataDTO.setWordUrl(agileDataAutoDataReportDTO.getData().getDocx().getUrl());
            updateAutoDataDTO.setWordCreateDate(agileDataAutoDataReportDTO.getData().getDocx().getCreateDate());
            updateAutoDataDTO.setWordExpireDate(agileDataAutoDataReportDTO.getData().getDocx().getExpireDate());
            autoDataDownLoad.setDownLoadUrl(agileDataAutoDataReportDTO.getData().getDocx().getUrl());
            autoDataDownLoad.setCreateData(agileDataAutoDataReportDTO.getData().getDocx().getCreateDate());
            autoDataDownLoad.setExpireData(agileDataAutoDataReportDTO.getData().getDocx().getExpireDate());
            autoDataDownLoad.setLimitDay(agileDataAutoDataReportDTO.getData().getLimitDay());
        }
        this.echoService.updateAutoDataReport(authoredUser, updateAutoDataDTO);
        return autoDataDownLoad;
    }

    private AniaAssistantChatReqDTO buildAutoDataQuestionParams(HttpServletRequest request, AgileDataAutoDataReq autoDataReq) {
        AniaAssistantChatReqDTO aniaAssistantChatReqDTO = new AniaAssistantChatReqDTO();
        aniaAssistantChatReqDTO.setAssistantId(autoDataReq.getAppCode());
        AniaAssistantChatReqDTO.Message message = new AniaAssistantChatReqDTO.Message();
        HashMap extData = Maps.newHashMap();
        HashMap msgExt = Maps.newHashMap();
        msgExt.put("msg", autoDataReq.getQuestion());
        msgExt.put("asaCode", autoDataReq.getQuestion());
        HashMap msgBody = Maps.newHashMap();
        msgBody.put("msg", autoDataReq.getQuestion());
        extData.put("msgBody", msgBody);
        extData.put("msgExt", msgExt);
        message.setExtData((Map)extData);
        aniaAssistantChatReqDTO.setMessage(message);
        return aniaAssistantChatReqDTO;
    }

    private SnapShotDTO buildAutoDataSnapParams(AgileDataAutoDataReq autoDataReq) {
        SnapShotDTO snapShotDTO = new SnapShotDTO();
        ContextDTO contextDTO = new ContextDTO();
        snapShotDTO.setContext(contextDTO);
        BizParamsDTO bizParamsDTO = new BizParamsDTO();
        bizParamsDTO.setShowDefine(CommonUtil.convertObjectToMap((Object)autoDataReq.getShowDefine()));
        bizParamsDTO.setDatasetList(autoDataReq.getDatasetList());
        bizParamsDTO.setQuestion(autoDataReq.getQuestion());
        contextDTO.setBizParams(bizParamsDTO);
        return snapShotDTO;
    }

    private ThemeMapBoardDTO buildAutoDataBoardParams(AgileDataAutoDataReq autoDataReq) {
        ThemeMapBoardDTO themeMapBoardDTO = new ThemeMapBoardDTO();
        HashMap solutionStep = Maps.newHashMap();
        String actionId = ((SchemaMetricShowDefine.ShowType)autoDataReq.getShowDefine().getShowType().get(0)).getActionId();
        solutionStep.put(actionId, autoDataReq.getSolutionStep());
        themeMapBoardDTO.setAppCode(autoDataReq.getAppCode());
        themeMapBoardDTO.setSolutionStep((Map)solutionStep);
        themeMapBoardDTO.setFilterAnalysis(false);
        return themeMapBoardDTO;
    }

    private String buildHistoryText(Map<String, Object> processStreamData) {
        StringBuilder historyText = new StringBuilder();
        if (MapUtils.isEmpty(processStreamData)) {
            return historyText.toString();
        }
        Map intentionAnalysis4AutoData = MapUtils.getMap(processStreamData, (Object)"intentionAnalysis4AutoData");
        historyText.append(MapUtils.getString((Map)intentionAnalysis4AutoData, (Object)"title"));
        historyText.append(MapUtils.getString((Map)intentionAnalysis4AutoData, (Object)"content"));
        Map taskPlan = MapUtils.getMap(processStreamData, (Object)"taskPlan");
        historyText.append(MapUtils.getString((Map)taskPlan, (Object)"title"));
        historyText.append(MapUtils.getString((Map)taskPlan, (Object)"content"));
        Map dataQuery = MapUtils.getMap(processStreamData, (Object)"dataQuery");
        historyText.append(MapUtils.getString((Map)dataQuery, (Object)"title"));
        historyText.append(MapUtils.getString((Map)dataQuery, (Object)"content"));
        Map dataFusionAnalysis = MapUtils.getMap(processStreamData, (Object)"dataFusionAnalysis");
        historyText.append(MapUtils.getString((Map)dataFusionAnalysis, (Object)"title"));
        historyText.append(MapUtils.getString((Map)dataFusionAnalysis, (Object)"content"));
        Map reportGeneration = MapUtils.getMap(processStreamData, (Object)"reportGeneration");
        historyText.append(MapUtils.getString((Map)reportGeneration, (Object)"title"));
        historyText.append(MapUtils.getString((Map)reportGeneration, (Object)"content"));
        return historyText.toString();
    }

    private List<Map<String, Object>> buildHistoryList(Map<String, Object> processStreamData) {
        ArrayList historyList = Lists.newArrayList();
        if (MapUtils.isEmpty(processStreamData)) {
            return historyList;
        }
        Map intentionAnalysis4AutoData = MapUtils.getMap(processStreamData, (Object)"intentionAnalysis4AutoData");
        historyList.add(this.buildAutoDataReportContent("function_analysic", "title", MapUtils.getString((Map)intentionAnalysis4AutoData, (Object)"title")));
        historyList.add(this.buildAutoDataReportContent("function_analysic", "text", MapUtils.getString((Map)intentionAnalysis4AutoData, (Object)"content")));
        Map taskPlan = MapUtils.getMap(processStreamData, (Object)"taskPlan");
        historyList.add(this.buildAutoDataReportContent("function_analysic", "title", MapUtils.getString((Map)taskPlan, (Object)"title")));
        historyList.add(this.buildAutoDataReportContent("function_analysic", "text", MapUtils.getString((Map)taskPlan, (Object)"content")));
        Map dataQuery = MapUtils.getMap(processStreamData, (Object)"dataQuery");
        historyList.add(this.buildAutoDataReportContent("function_analysic", "title", MapUtils.getString((Map)dataQuery, (Object)"title")));
        historyList.add(this.buildAutoDataReportContent("function_analysic", "text", MapUtils.getString((Map)dataQuery, (Object)"content")));
        Map dataFusionAnalysis = MapUtils.getMap(processStreamData, (Object)"dataFusionAnalysis");
        historyList.add(this.buildAutoDataReportContent("function_analysic", "title", MapUtils.getString((Map)dataFusionAnalysis, (Object)"title")));
        historyList.add(this.buildAutoDataReportContent("function_analysic", "text", MapUtils.getString((Map)dataFusionAnalysis, (Object)"content")));
        Map reportGeneration = MapUtils.getMap(processStreamData, (Object)"reportGeneration");
        historyList.add(this.buildAutoDataReportContent("function_answer", "text", MapUtils.getString((Map)reportGeneration, (Object)"content")));
        return historyList;
    }

    private Map<String, Object> buildAutoDataReportContent(String eventType, String messageType, String content) {
        HashMap autoDataReport = Maps.newHashMap();
        autoDataReport.put("eventType", eventType);
        autoDataReport.put("messageType", messageType);
        autoDataReport.put("content", content);
        return autoDataReport;
    }
}

