/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.log;

import com.digiwin.athena.adt.agileReport.eventbus.AgileDataLogEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataLogService;
import com.digiwin.athena.adt.agileReport.service.AgileDataMessageLogEventService;
import com.digiwin.athena.adt.util.MessageUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgileDataLogServiceImpl
implements AgileDataLogService {
    private static final Logger log = LoggerFactory.getLogger(AgileDataLogServiceImpl.class);
    @Autowired
    private MessageUtil messageUtil;
    @Autowired
    private AgileDataMessageLogEventService agileDataMessageLogEventService;

    public void saveAgileDataLog(AgileDataLogEvent event) {
        this.agileDataMessageLogEventService.processLog(event);
    }

    public void saveQuestionData(Map<String, Object> data, AgileDataLogEvent event) {
        HashMap dataMap = Maps.newHashMap();
        String snapshotId = "";
        String tipMessage = this.messageUtil.getMessageByLangName("message.log.error", event.getLocal());
        if (MapUtils.isNotEmpty(data)) {
            List dataList;
            snapshotId = MapUtils.getString(data, (Object)"snapshotId");
            Map contextMap = MapUtils.getMap(data, (Object)"context");
            if (MapUtils.isNotEmpty((Map)contextMap) && contextMap.containsKey("pullData") && !CollectionUtils.isEmpty((Collection)(dataList = (List)MapUtils.getObject((Map)contextMap, (Object)"pullData")))) {
                event.setMessageGet(true);
                Map<String, List<Map>> groupMap = dataList.stream().collect(Collectors.groupingBy(map -> (String)map.get("actionId")));
                if (MapUtils.isNotEmpty(groupMap)) {
                    groupMap.forEach((k, v) -> {
                        ArrayList bkDataList = Lists.newArrayList();
                        v.stream().forEach(groupData -> {
                            Object dataObj = MapUtils.getObject((Map)groupData, (Object)"data");
                            if (dataObj != null && !((Map)dataObj).isEmpty()) {
                                ArrayList tempList = Lists.newArrayList();
                                if (dataObj instanceof Map) {
                                    tempList.add((Map)dataObj);
                                } else {
                                    tempList.addAll((Collection)dataObj);
                                }
                                if (!CollectionUtils.isEmpty((Collection)tempList)) {
                                    bkDataList.addAll(tempList);
                                }
                            }
                        });
                        if (!CollectionUtils.isEmpty((Collection)bkDataList)) {
                            dataMap.put(k, bkDataList);
                        }
                    });
                }
            }
            event.setData((Map)dataMap);
            event.setSnapshotId(snapshotId);
            event.setSuccess(Integer.valueOf(1));
            event.setType(Integer.valueOf(0));
            event.setErrorAnswer(MapUtils.isNotEmpty((Map)dataMap) ? null : tipMessage);
            this.agileDataMessageLogEventService.processLog(event);
        }
    }
}

