/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.ppt;

import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataPPTReq;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataPPTRes;
import com.digiwin.athena.adt.agileReport.controller.dto.file.AgileDataGenerateReq;
import com.digiwin.athena.adt.agileReport.controller.dto.file.AgileDataGenerateRes;
import com.digiwin.athena.adt.agileReport.service.AgileDataPPTService;
import com.digiwin.athena.adt.domain.chatbi.ChatbiService;
import com.digiwin.athena.adt.domain.dto.AgileDataFileShowDTO;
import com.digiwin.athena.adt.domain.dto.FileParsingPPTRes;
import com.digiwin.athena.adt.domain.dto.ScrumbiGenaratePPTReq;
import com.digiwin.athena.adt.domain.dto.ScrumbiGenaratePPTRes;
import com.digiwin.athena.adt.domain.dto.ScrumbiPPTAnalyzeDTO;
import com.digiwin.athena.adt.domain.dto.echo.AgileDataFileDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaPPTPlanningDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.file.FileParsingService;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.adt.util.agileData.AgileDataAnalysisUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgileDataPPTServiceImpl
implements AgileDataPPTService {
    private static final Logger log = LoggerFactory.getLogger(AgileDataPPTServiceImpl.class);
    @Autowired
    private EchoService echoService;
    @Autowired
    private ChatbiService chatbiService;
    @Autowired
    private MessageUtil messageUtil;
    @Autowired
    private FileParsingService fileParsingService;

    public AgileDataPPTRes getPPTAnalyze(AuthoredUser user, AgileDataPPTReq agileDataPPTReq, String locale) {
        log.info("\u5f00\u59cb\u91cd\u65b0\u751f\u6210\u89c4\u5212\uff0c\u5165\u53c2\uff1a{}", (Object)JsonUtils.objectToString((Object)agileDataPPTReq));
        AgileDataPPTRes agileDataPPTRes = new AgileDataPPTRes();
        agileDataPPTRes.setResult(Boolean.valueOf(true));
        HashMap params = Maps.newHashMap();
        params.put("messageId", agileDataPPTReq.getMessageId());
        AgileDataFileDTO agileDataFileDTO = this.echoService.getAgileDataFile((Map)params, user.getToken(), user.getTenantId());
        if (agileDataFileDTO == null) {
            agileDataPPTRes.setAnalyzeResult(agileDataFileDTO);
            return agileDataPPTRes;
        }
        if (!this.isNeedExecute(agileDataFileDTO).booleanValue()) {
            agileDataPPTRes.setAnalyzeResult(agileDataFileDTO);
            return agileDataPPTRes;
        }
        ScrumbiPPTAnalyzeDTO querySchemaResDTO = this.chatbiService.getPPTAnalyze(user, this.buildPPTParams(agileDataFileDTO, agileDataPPTReq), locale);
        if (querySchemaResDTO == null) {
            agileDataPPTRes.setAnalyzeResult(agileDataFileDTO);
            return agileDataPPTRes;
        }
        Integer code = querySchemaResDTO.getData().getCode();
        if (Objects.isNull(code)) {
            log.info("\u5206\u6790\u8bed\u4e49\u89c4\u5212\u83b7\u53d6\u5931\u8d25\uff0c\u4f7f\u7528\u539f\u7ed3\u679c");
            agileDataPPTRes.setAnalyzeResult(agileDataFileDTO);
            return agileDataPPTRes;
        }
        QuerySchemaPPTPlanningDTO questionPlanningRes = querySchemaResDTO.getData().getContent();
        if (Objects.isNull(questionPlanningRes)) {
            log.info("\u5206\u6790\u8bed\u4e49\u89c4\u5212\u83b7\u53d6\u5931\u8d25\uff0c\u4f7f\u7528\u539f\u7ed3\u679c");
            agileDataPPTRes.setAnalyzeResult(agileDataFileDTO);
            return agileDataPPTRes;
        }
        switch (((Object)code).toString()) {
            case "0": {
                HashMap deleteParams = Maps.newHashMap();
                deleteParams.put("messageId", agileDataPPTReq.getMessageId());
                this.echoService.deleteAgileDataFile((Map)deleteParams, user.getToken(), user.getTenantId());
                QuerySchemaResDTO schemaResDTO = new QuerySchemaResDTO();
                querySchemaResDTO.getData().getContent().setPlanningTopic(agileDataFileDTO.getMessageTopic());
                schemaResDTO.setQuestionPlanningRes(querySchemaResDTO.getData().getContent());
                agileDataFileDTO.getQuestionInfo().stream().forEach(question2 -> querySchemaResDTO.getData().getContent().getPlanningQuestions().stream().forEach(planningQuestion -> {
                    if (planningQuestion.getQuestion().equals(question2.getQuestion())) {
                        planningQuestion.setStatus(Integer.valueOf(question2.getLock() != false ? 0 : 1));
                    }
                }));
                AgileDataFileDTO agileDataFile = AgileDataAnalysisUtils.buildAgileDataFile((Long)agileDataPPTReq.getMessageId(), (String)agileDataFileDTO.getAppCode(), (QuerySchemaResDTO)schemaResDTO);
                this.echoService.addAgileDataFile(agileDataFile, user.getToken(), user.getTenantId());
                agileDataPPTRes.setAnalyzeResult(agileDataFile);
                break;
            }
            case "1": {
                agileDataPPTRes.setResult(Boolean.valueOf(false));
                agileDataPPTRes.setReplay(querySchemaResDTO.getData().getReply());
                break;
            }
        }
        return agileDataPPTRes;
    }

    public AgileDataGenerateRes generatePPT(AuthoredUser user, AgileDataGenerateReq agileDataGenerateReq, String locale) {
        AgileDataFileDTO.AgileDataFileGenerateDTO pptGenerateDTO;
        log.info("\u5f00\u59cb\u751f\u6210PPT\uff0c\u5165\u53c2\uff1a{}", (Object)JsonUtils.objectToString((Object)agileDataGenerateReq));
        AgileDataGenerateRes agileDataGenerateRes = new AgileDataGenerateRes();
        agileDataGenerateRes.setPptStatus("0");
        HashMap getFileParams = Maps.newHashMap();
        getFileParams.put("messageId", agileDataGenerateReq.getMessageId());
        AgileDataFileDTO agileDataFileDTO = this.echoService.getAgileDataFile((Map)getFileParams, user.getToken(), user.getTenantId());
        if (agileDataFileDTO == null) {
            log.error("\u83b7\u53d6\u95ee\u53e5\u4fe1\u606f\u5931\u8d25");
            agileDataGenerateRes.setPptStatus("1");
            agileDataGenerateRes.setErrMessage(this.messageUtil.getMessageByLangName("message.adt.ppt.error", locale));
            return agileDataGenerateRes;
        }
        List pptInfo = agileDataFileDTO.getPptInfo();
        if (CollectionUtils.isNotEmpty((Collection)pptInfo) && (pptGenerateDTO = (AgileDataFileDTO.AgileDataFileGenerateDTO)pptInfo.stream().filter(ppt -> ppt.getPptId().equals(agileDataGenerateReq.getPptId())).findFirst().orElse(null)) != null && "0".equals(pptGenerateDTO.getGenerateStatus())) {
            agileDataGenerateRes.setPptUrl(pptGenerateDTO.getPptUrl());
            agileDataGenerateRes.setPptPreviewUrl(pptGenerateDTO.getPptPreviewUrl());
            agileDataGenerateRes.setPptDocId(pptGenerateDTO.getPptDocId());
            agileDataGenerateRes.setPptName(pptGenerateDTO.getPptName());
            agileDataGenerateRes.setCreateDate(pptGenerateDTO.getCreateDate());
            agileDataGenerateRes.setExpireDate(pptGenerateDTO.getExpireDate());
            agileDataGenerateRes.setPptPageSize(pptGenerateDTO.getPptPageSize());
            return agileDataGenerateRes;
        }
        Boolean updateResult = this.echoService.updateAgileDataFile(this.buildUpdateStatusParams(agileDataFileDTO, "2", agileDataGenerateReq, null), user.getToken(), user.getTenantId());
        if (!updateResult.booleanValue()) {
            this.echoService.updateAgileDataFile(this.buildUpdateStatusParams(agileDataFileDTO, "1", agileDataGenerateReq, null), user.getToken(), user.getTenantId());
            log.error("\u83b7\u53d6\u95ee\u53e5\u4fe1\u606f\u5931\u8d25");
            agileDataGenerateRes.setPptStatus("1");
            agileDataGenerateRes.setErrMessage(this.messageUtil.getMessageByLangName("message.adt.ppt.error", locale));
            return agileDataGenerateRes;
        }
        HashMap params = Maps.newHashMap();
        params.put("snapshotIds", agileDataFileDTO.getQuestionInfo().stream().filter(Objects::nonNull).filter(question2 -> question2.getAnalyzeStatus() != null && question2.getAnalyzeStatus() == 0).map(AgileDataFileDTO.AgileDataFileQuestionDTO::getSnapshotId).filter(Objects::nonNull).collect(Collectors.toList()));
        AgileDataFileShowDTO agileDataFileShowDTO = this.echoService.getAgileDataFileShow((Map)params, user.getToken(), user.getTenantId());
        if (agileDataFileShowDTO == null) {
            this.echoService.updateAgileDataFile(this.buildUpdateStatusParams(agileDataFileDTO, "1", agileDataGenerateReq, null), user.getToken(), user.getTenantId());
            log.error("\u83b7\u53d6\u95ee\u53e5\u5448\u73b0\u7ed3\u6784\u5931\u8d25");
            agileDataGenerateRes.setPptStatus("1");
            agileDataGenerateRes.setErrMessage(this.messageUtil.getMessageByLangName("message.adt.ppt.error", locale));
            return agileDataGenerateRes;
        }
        ScrumbiGenaratePPTRes pptRes = this.chatbiService.generatePPT(user, this.buildPPTGenarateParams(agileDataFileShowDTO, agileDataFileDTO, user), locale);
        if (pptRes == null) {
            this.echoService.updateAgileDataFile(this.buildUpdateStatusParams(agileDataFileDTO, "1", agileDataGenerateReq, null), user.getToken(), user.getTenantId());
            log.error("\u83b7\u53d6PPT\u667a\u80fd\u4f53\u5931\u8d25");
            agileDataGenerateRes.setPptStatus("1");
            agileDataGenerateRes.setErrMessage(this.messageUtil.getMessageByLangName("message.adt.ppt.error", locale));
            return agileDataGenerateRes;
        }
        if (pptRes.getData() == null) {
            this.echoService.updateAgileDataFile(this.buildUpdateStatusParams(agileDataFileDTO, "1", agileDataGenerateReq, null), user.getToken(), user.getTenantId());
            log.error("\u83b7\u53d6PPT\u667a\u80fd\u4f53\u5931\u8d25");
            agileDataGenerateRes.setPptStatus("1");
            agileDataGenerateRes.setErrMessage(this.messageUtil.getMessageByLangName("message.adt.ppt.error", locale));
            return agileDataGenerateRes;
        }
        Integer code = pptRes.getData().getCode();
        switch (code) {
            case 0: {
                Map content = pptRes.getData().getContent();
                List pages = (List)content.get("pptPage");
                List datas = (List)content.get("pptData");
                String name = MapUtils.getString((Map)content, (Object)"name");
                if (CollectionUtils.isEmpty((Collection)datas)) {
                    this.echoService.updateAgileDataFile(this.buildUpdateStatusParams(agileDataFileDTO, "1", agileDataGenerateReq, null), user.getToken(), user.getTenantId());
                    log.error("\u83b7\u53d6PPT\u667a\u80fd\u4f53\u751f\u6210\u7ed3\u6784\u5931\u8d25");
                    agileDataGenerateRes.setPptStatus("1");
                    agileDataGenerateRes.setErrMessage(this.messageUtil.getMessageByLangName("message.adt.ppt.error", locale));
                    return agileDataGenerateRes;
                }
                FileParsingPPTRes fileParsingPPTRes = this.fileParsingService.getFileParsingPPT(user.getTenantId(), user.getToken(), locale, this.buildFilePPTParams(user, name, datas, pages));
                if (fileParsingPPTRes == null || fileParsingPPTRes.getCode() != 200 || fileParsingPPTRes.getData() == null) {
                    this.echoService.updateAgileDataFile(this.buildUpdateStatusParams(agileDataFileDTO, "1", agileDataGenerateReq, null), user.getToken(), user.getTenantId());
                    log.error("\u751f\u6210PPT\u5931\u8d25");
                    agileDataGenerateRes.setPptStatus("1");
                    agileDataGenerateRes.setErrMessage(fileParsingPPTRes != null && StringUtils.isNotEmpty((String)fileParsingPPTRes.getMsg()) ? fileParsingPPTRes.getMsg() : this.messageUtil.getMessageByLangName("message.adt.ppt.error", locale));
                    return agileDataGenerateRes;
                }
                this.echoService.updateAgileDataFile(this.buildUpdateStatusParams(agileDataFileDTO, "0", agileDataGenerateReq, fileParsingPPTRes), user.getToken(), user.getTenantId());
                agileDataGenerateRes.setPptUrl(fileParsingPPTRes.getData().getUrl());
                agileDataGenerateRes.setPptDocId(fileParsingPPTRes.getData().getPptDocId());
                agileDataGenerateRes.setPptPreviewUrl(fileParsingPPTRes.getData().getPptPreviewUrl());
                agileDataGenerateRes.setPptPageSize(fileParsingPPTRes.getData().getPptPageSize());
                agileDataGenerateRes.setPptName(fileParsingPPTRes.getData().getPptName());
                agileDataGenerateRes.setCreateDate(fileParsingPPTRes.getData().getCreateDate());
                agileDataGenerateRes.setExpireDate(fileParsingPPTRes.getData().getExpireDate());
                break;
            }
            case 1: {
                this.echoService.updateAgileDataFile(this.buildUpdateStatusParams(agileDataFileDTO, "1", agileDataGenerateReq, null), user.getToken(), user.getTenantId());
                log.error("\u83b7\u53d6PPT\u667a\u80fd\u4f53\u5931\u8d25");
                agileDataGenerateRes.setPptStatus("1");
                agileDataGenerateRes.setErrMessage(pptRes.getData().getReply());
                break;
            }
        }
        return agileDataGenerateRes;
    }

    private Map<String, Object> buildFilePPTParams(AuthoredUser authoredUser, String name, List<Map<String, Object>> datas, List<Map<String, Object>> pages) {
        HashMap params = Maps.newHashMap();
        params.put("userId", authoredUser.getUserId());
        params.put("userName", authoredUser.getUserName());
        params.put("tenantId", authoredUser.getTenantId());
        params.put("pptData", datas);
        params.put("pptPage", pages);
        params.put("name", name);
        return params;
    }

    private ScrumbiGenaratePPTReq buildPPTGenarateParams(AgileDataFileShowDTO agileDataFileShowDTO, AgileDataFileDTO agileDataFileDTO, AuthoredUser user) {
        ScrumbiGenaratePPTReq scrumbiGenaratePPTReq = new ScrumbiGenaratePPTReq();
        scrumbiGenaratePPTReq.setPlanningTopic(agileDataFileDTO.getMessageTopic());
        scrumbiGenaratePPTReq.setUserId(user.getUserId());
        scrumbiGenaratePPTReq.setUserName(user.getUserName());
        scrumbiGenaratePPTReq.setTenantId(user.getTenantId());
        scrumbiGenaratePPTReq.setChartTypeMap(agileDataFileShowDTO.getTypeMap());
        ArrayList questionAndAnswers = Lists.newArrayList();
        scrumbiGenaratePPTReq.setPlanningQuestionAndAnswers((List)questionAndAnswers);
        if (CollectionUtils.isNotEmpty((Collection)agileDataFileDTO.getQuestionInfo())) {
            agileDataFileDTO.getQuestionInfo().stream().forEach(questionInfo -> {
                List showDefines = agileDataFileShowDTO.getShowDefine().stream().filter(showDefine -> showDefine.getSnapshotId().equals(questionInfo.getSnapshotId())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(showDefines)) {
                    showDefines.stream().forEach(showDefine -> {
                        ScrumbiGenaratePPTReq.QuestionAndAnswers questionAndAnswer = new ScrumbiGenaratePPTReq.QuestionAndAnswers();
                        questionAndAnswer.setQuestion(questionInfo.getQuestion());
                        questionAndAnswer.setTitle(questionInfo.getTitle());
                        questionAndAnswer.setAnswer(showDefine.getAbstractComponent());
                        questionAndAnswer.setSummary(questionInfo.getSummarizeData());
                        questionAndAnswers.add(questionAndAnswer);
                    });
                }
            });
        }
        return scrumbiGenaratePPTReq;
    }

    private AgileDataFileDTO buildUpdateStatusParams(AgileDataFileDTO agileDataFile, String status, AgileDataGenerateReq agileDataGenerateReq, FileParsingPPTRes fileParsingPPTRes) {
        AgileDataFileDTO agileDataFileDTO = new AgileDataFileDTO();
        agileDataFileDTO.setMessageId(agileDataGenerateReq.getMessageId());
        List pptInfo = agileDataFile.getPptInfo();
        AgileDataFileDTO.AgileDataFileGenerateDTO pptInfoDTO = new AgileDataFileDTO.AgileDataFileGenerateDTO();
        pptInfoDTO.setPptId(agileDataGenerateReq.getPptId());
        pptInfoDTO.setGenerateStatus(status);
        if (fileParsingPPTRes != null && fileParsingPPTRes.getData() != null) {
            pptInfoDTO.setPptUrl(fileParsingPPTRes.getData().getUrl());
            pptInfoDTO.setPptPreviewUrl(fileParsingPPTRes.getData().getPptPreviewUrl());
            pptInfoDTO.setPptDocId(fileParsingPPTRes.getData().getPptDocId());
            pptInfoDTO.setPptName(fileParsingPPTRes.getData().getPptName());
            pptInfoDTO.setCreateDate(fileParsingPPTRes.getData().getCreateDate());
            pptInfoDTO.setExpireDate(fileParsingPPTRes.getData().getExpireDate());
            pptInfoDTO.setPptPageSize(fileParsingPPTRes.getData().getPptPageSize());
        }
        pptInfo.add(pptInfoDTO);
        agileDataFileDTO.setPptInfo(pptInfo);
        return agileDataFileDTO;
    }

    private Boolean isNeedExecute(AgileDataFileDTO agileDataFileDTO) {
        List planningQuestions;
        if (agileDataFileDTO != null && CollectionUtils.isNotEmpty((Collection)(planningQuestions = agileDataFileDTO.getQuestionInfo())) && planningQuestions.size() == 8) {
            List unLock = planningQuestions.stream().filter(question2 -> question2.getLock() == false).collect(Collectors.toList());
            return CollectionUtils.isNotEmpty(unLock);
        }
        return true;
    }

    private Map<String, Object> buildPPTParams(AgileDataFileDTO agileDataFileDTO, AgileDataPPTReq agileDataPPTReq) {
        HashMap res = Maps.newHashMap();
        if (agileDataFileDTO == null) {
            return res;
        }
        res.put("question", agileDataPPTReq.getQuestion());
        res.put("planningTopic", agileDataFileDTO.getMessageTopic());
        ArrayList planningQuestions = Lists.newArrayList();
        agileDataFileDTO.getQuestionInfo().stream().forEach(question2 -> {
            HashMap planningQuestion = Maps.newHashMap();
            planningQuestion.put("question", question2.getQuestion());
            planningQuestion.put("title", question2.getTitle());
            planningQuestion.put("datasetIds", question2.getDatasetIds());
            planningQuestion.put("status", question2.getLock() != false ? 1 : 0);
            planningQuestions.add(planningQuestion);
        });
        res.put("planningQuestions", planningQuestions);
        res.put("measures", agileDataPPTReq.getMeasures());
        return res;
    }
}

