/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.process.agileData;

import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.AgileDataType;
import com.digiwin.athena.adt.agileReport.service.AgileDataProcessService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.adt.domain.dto.aiBoard.AIBoardDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.report.AgileReportDataService;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@AgileDataType(value=AgileDataEnum.AI_BOARD_ANALYZE)
public class AgileDataProcessAIBoardAnalyzeServiceImpl
extends AbsAgileDataProcess
implements AgileDataProcessService {
    private static final Logger log = LoggerFactory.getLogger(AgileDataProcessAIBoardAnalyzeServiceImpl.class);
    @Resource
    private ADEService adeService;
    @Autowired
    private MessageUtil messageUtil;
    @Autowired
    private EchoService echoService;
    @Autowired
    private AgileReportDataService agileReportDataService;

    public void process(AthenaMessageEvent event, QuerySchemaResDTO responseData) {
        try {
            Map req = this.processBefore(event, responseData);
            this.processAfter(event, req, responseData);
        }
        catch (Exception e) {
            HashMap<String, Object> queryData = new HashMap<String, Object>();
            queryData.put("title", this.messageUtil.getMessageByLangNameWithFormat("message.sse.essentialFactor", event.getLang(), new Object[0]));
            queryData.put("status", false);
            this.updateAIBoardDataByError(event, responseData.getData().getDataset().getProcessStreamData(), queryData);
            log.error("\u5bf9\u8bdd\u770b\u677f \u83b7\u53d6\u89e3\u9898\u601d\u8def\u5931\u8d25: {}", (Object)JsonUtils.objectToString((Object)e));
            Thread.currentThread().interrupt();
        }
    }

    public Map<String, Object> processBefore(AthenaMessageEvent event, QuerySchemaResDTO responseData) {
        Map req = this.parameterBasedOnVersion(responseData, event);
        this.updateProcessStreamDataByEF(event, req, responseData);
        return req;
    }

    public void processAfter(AthenaMessageEvent event, Map<String, Object> response, QuerySchemaResDTO responseData) {
        if (Objects.isNull(response)) {
            log.info("\u66f4\u65b0\u5bf9\u8bdd\u770b\u677f\u6267\u884c\u6b65\u9aa4 ADE\u89e3\u9898\u601d\u8def\u5931\u8d25");
            this.updateAIBoardDataFile(event, responseData, Integer.valueOf(1), null);
            return;
        }
        try {
            this.updateAIBoardDataFile(event, responseData, Integer.valueOf(0), response);
        }
        catch (Exception e) {
            this.updateAIBoardDataFile(event, responseData, Integer.valueOf(1), null);
        }
    }

    public void updateProcessStreamDataByEF(AthenaMessageEvent event, Map<String, Object> req, QuerySchemaResDTO responseData) {
        Map processStreamData = responseData.getData().getDataset().getProcessStreamData();
        log.info("\u5bf9\u8bdd\u770b\u677f \u66f4\u65b0\u8981\u7d20\u8bc6\u522b\u8bed\u4e49\u5165\u53c2 processStreamData: {}", (Object)JsonUtils.objectToString((Object)processStreamData));
        HashMap<String, Object> essentialFactor = new HashMap<String, Object>();
        essentialFactor.put("title", "\u89e3\u9898\u8981\u7d20\u8bc6\u522b");
        Map response = this.adeService.getEssentialFactor(event, req);
        if (response == null || Objects.isNull(response.get("msg"))) {
            assert (response != null);
            essentialFactor.put("content", response.get("msg"));
            essentialFactor.put("status", false);
        } else {
            essentialFactor.put("content", response.get("data"));
            essentialFactor.put("status", true);
        }
        processStreamData.put("stepAnasisly", essentialFactor);
    }

    public void updateAIBoardDataFile(AthenaMessageEvent event, QuerySchemaResDTO responseData, Integer status, Map<String, Object> getDataParams) {
        AIBoardDTO aiBoardDTO = new AIBoardDTO();
        Map processStreamData = responseData.getData().getDataset().getProcessStreamData();
        aiBoardDTO.setMessageId(Long.valueOf(event.getMsgExt().get("aiBoardMessageId").toString()));
        ArrayList<AIBoardDTO.AIBoardQuestionDTO> questionDTOS = new ArrayList<AIBoardDTO.AIBoardQuestionDTO>();
        AIBoardDTO.AIBoardQuestionDTO questionDTO = new AIBoardDTO.AIBoardQuestionDTO();
        questionDTO.setQuestionId(Long.valueOf(event.getMsgExt().get("aiBoardQuestionId").toString()));
        AIBoardDTO.AIBoardAnalyzeDTO analyzeDTO = (AIBoardDTO.AIBoardAnalyzeDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)processStreamData), AIBoardDTO.AIBoardAnalyzeDTO.class);
        questionDTO.setAnalyzeResult(analyzeDTO);
        questionDTO.setAnalyzeStatus(status);
        questionDTO.setAnalyzeMessageId(event.getGenerateSerialNo());
        questionDTO.setGetDataParams(getDataParams);
        questionDTOS.add(questionDTO);
        aiBoardDTO.setQuestionInfo(questionDTOS);
        log.info("\u66f4\u65b0\u5bf9\u8bdd\u770b\u677f\u6267\u884c\u6b65\u9aa4\u548c\u72b6\u6001\u5165\u53c2 eventQuestionId :{},: data:{}", (Object)event.getGenerateSerialNo(), (Object)JsonUtils.objectToString((Object)aiBoardDTO));
        this.echoService.updateAIBoard(aiBoardDTO, event.getUser().getToken(), event.getUser().getTenantId());
    }
}

