/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.process.agileData;

import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.AgileDataType;
import com.digiwin.athena.adt.agileReport.service.AgileDataCalculateCostService;
import com.digiwin.athena.adt.agileReport.service.AgileDataCostDetailService;
import com.digiwin.athena.adt.agileReport.service.AgileDataProcessService;
import com.digiwin.athena.adt.agileReport.service.AgileReportService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.domain.ade.ADEService;
import com.digiwin.athena.adt.domain.dto.echo.EchoSubmitReq;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.sse.domain.EventData;
import com.digiwin.athena.adt.sse.domain.SseAniaEventEnum;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.adt.util.agileData.AgileDataAnalysisUtils;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.google.common.collect.Maps;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@AgileDataType(value=AgileDataEnum.DATASET)
public class AgileDataProcessDatasetServiceImpl
extends AbsAgileDataProcess
implements AgileDataProcessService {
    private static final Logger log = LoggerFactory.getLogger(AgileDataProcessDatasetServiceImpl.class);
    @Resource
    private ADEService adeService;
    @Autowired
    private SemcService semcService;
    @Autowired
    private MessageUtil messageUtil;
    @Autowired
    private AgileDataCalculateCostService agileDataCalculateCostService;
    @Autowired
    private EchoService echoService;
    @Autowired
    private AgileReportService agileReportService;
    @Autowired
    private AgileDataCostDetailService agileDataCostDetailService;

    public void process(AthenaMessageEvent event, QuerySchemaResDTO responseData) {
        try {
            Map req = this.processBefore(event, responseData);
            this.processAfter(event, req, responseData);
        }
        catch (Exception e) {
            HashMap<String, String> msgBody = new HashMap<String, String>();
            log.error("ade message sendMessageToAde error: {}", (Object)e.getMessage());
            String tipMessage = this.messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error", event.getLang(), new Object[0]);
            msgBody.put("prompt", tipMessage);
            this.saveAbnormal(event, tipMessage, Integer.valueOf(0));
            this.semcService.sendMessageToGpt(event, msgBody);
            Thread.currentThread().interrupt();
        }
    }

    public Map<String, Object> processBefore(AthenaMessageEvent event, QuerySchemaResDTO responseData) throws ExecutionException, InterruptedException {
        AtomicBoolean state = new AtomicBoolean(false);
        CountDownLatch returnResultLatch = new CountDownLatch(1);
        String sseProductVersion = event.getSseProductVersion();
        Map req = this.parameterBasedOnVersion(responseData, event);
        if (event.isSseMessage()) {
            log.info("send \u8981\u7d20\u8bc6\u522b\u4f1a\u8bdd\u5f00\u59cb");
            HashMap<String, Object> messageObj = new HashMap<String, Object>();
            String messageTitle = this.messageUtil.getMessageByLangNameWithFormat("message.sse.essentialFactor", event.getLang(), new Object[0]);
            messageObj.put("name", messageTitle);
            messageObj.put("arguments ", new HashMap());
            EventData.EventMessage eventMessage = "V1".equals(sseProductVersion) ? EventData.EventMessage.builderNewEventMessage((String)"function_call", messageObj, (AthenaMessageEvent)event) : EventData.EventMessage.builderNewEventMessageV2((String)"function_call", (Object)messageTitle, (AthenaMessageEvent)event);
            this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(), event.getSseEmitter(), eventMessage);
        }
        CompletableFuture<Boolean> getEssentialFactor = CompletableFuture.supplyAsync(() -> {
            AppAuthContextHolder.clearContext();
            log.info("initMdc getEssentialFactor : traceId : {},mdc get ptxId :{},event PtxId :{}", new Object[]{MDC.get((String)"traceId"), MDC.get((String)"PtxId"), event.getPtxId()});
            MDC.put((String)"traceId", (String)event.getPtxId());
            MDC.put((String)"PtxId", (String)event.getPtxId());
            JaMDC.put((String)event.getPtxId());
            this.getEssentialFactorAndSendSseMessage(event, req, state, returnResultLatch);
            returnResultLatch.countDown();
            return true;
        });
        CompletableFuture<Map> adeResult = CompletableFuture.supplyAsync(() -> {
            AppAuthContextHolder.clearContext();
            log.info("initMdc reqMetricSnapShotData : traceId : {},mdc get ptxId :{},event PtxId :{}", new Object[]{MDC.get((String)"traceId"), MDC.get((String)"PtxId"), event.getPtxId()});
            log.info("initMdc getEssentialFactor : traceId : {},mdc get ptxId :{},event PtxId :{}", new Object[]{MDC.get((String)"traceId"), MDC.get((String)"PtxId"), event.getPtxId()});
            MDC.put((String)"traceId", (String)event.getPtxId());
            MDC.put((String)"PtxId", (String)event.getPtxId());
            JaMDC.put((String)event.getPtxId());
            Map res = this.adeService.reqMetricSnapShotData(req, event);
            state.set(true);
            try {
                boolean awaitResult = returnResultLatch.await(60L, TimeUnit.SECONDS);
                if (awaitResult) {
                    log.info("Condition is satisfied");
                } else {
                    log.info("Condition is not satisfied");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (res == null || MapUtils.getMap((Map)res, (Object)"data") == null) {
                if (event.isSseMessage()) {
                    EventData.EventMessage toolResponse = "V1".equals(sseProductVersion) ? EventData.EventMessage.builderMessageClose((String)"tool_response", (String)event.getSseCallId(), (String)"fail") : EventData.EventMessage.builderMessageCloseV2((String)"tool_response", (String)event.getSseCallId(), (String)"fail");
                    this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(), event.getSseEmitter(), toolResponse);
                }
                String errorMsg = MapUtils.getString((Map)res, (Object)"msg");
                HashMap sendMap = Maps.newHashMap();
                sendMap.put("prompt", errorMsg);
                String tipMessage = this.messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error", event.getLang(), new Object[0]);
                this.saveAbnormal(event, tipMessage, Integer.valueOf(0));
                this.semcService.sendMessageToGpt(event, (Map)sendMap);
                return null;
            }
            return res;
        });
        getEssentialFactor.get();
        log.info("send \u53d6\u6570\u7ed3\u675f");
        if (event.isSseMessage()) {
            EventData.EventMessage toolResponse = "V1".equals(sseProductVersion) ? EventData.EventMessage.builderMessageClose((String)"tool_response", (String)event.getSseCallId(), (String)"success") : EventData.EventMessage.builderMessageCloseV2((String)"tool_response", (String)event.getSseCallId(), (String)"success");
            this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_COMPLETED.getEvent(), event.getSseEmitter(), toolResponse);
        }
        return adeResult.get();
    }

    public void processAfter(AthenaMessageEvent event, Map<String, Object> response, QuerySchemaResDTO responseData) {
        if (Objects.isNull(response)) {
            return;
        }
        String question2 = event.getQuestion();
        String combinationQuestion = event.getCombinationQuestion();
        Long generateSerialNo = event.getGenerateSerialNo();
        try {
            boolean isCheck;
            HashMap sendMap = Maps.newHashMap();
            Map data = MapUtils.getMap(response, (Object)"data");
            Pair interception = this.isDataProcessAction(data);
            if (((Boolean)interception.getLeft()).booleanValue()) {
                this.echoService.echoMongodbSubmit(EchoSubmitReq.builderInterception((AthenaMessageEvent)event, (MessageUtil)this.messageUtil, (Integer)((Integer)interception.getRight())), event.getUser().getToken(), event.getUser().getTenantId());
            }
            String snapshotId = MapUtils.getString((Map)data, (Object)"snapshotId");
            sendMap.put("snapshotId", snapshotId);
            this.executeStepAnalysis(event, response);
            this.setDataSummary(data, event);
            this.setDataScreening(event, response);
            AgileDataAnalysisUtils.getTransShowInfo((Map)data, (Map)sendMap, null);
            this.agileReportService.executeAgileDataByTokenSize(event.getUser(), event, data);
            this.saveQuestionData(MapUtils.getMap(response, (Object)"data"), event, question2, combinationQuestion, generateSerialNo);
            this.saveBuiltClassifications(event, response);
            if (StringUtils.isNotEmpty((CharSequence)snapshotId)) {
                this.agileDataCostDetailService.saveAgileDataCostDetail(data, event.getUser(), event.getPtxId(), event.getAppCode(), event.getAppName(), event.getSourceName());
            }
            if (!(isCheck = this.agileDataCalculateCostService.combinedBillingCalculation(event, data, (Map)sendMap))) {
                return;
            }
            this.semcService.sendMessageToGpt(event, (Map)sendMap);
        }
        catch (Exception e) {
            HashMap sendMap = Maps.newHashMap();
            sendMap.put("prompt", e.getMessage());
            String tipMessage = this.messageUtil.getMessageByLangNameWithFormat("message.adt.ade.error", event.getLang(), new Object[0]);
            this.semcService.sendMessageToGpt(event, (Map)sendMap);
            this.saveAbnormal(event, tipMessage, Integer.valueOf(0));
        }
    }
}

