/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.process.schema;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.SchemaDataType;
import com.digiwin.athena.adt.agileReport.service.SchemaDataProcessService;
import com.digiwin.athena.adt.agileReport.service.impl.process.schema.AbsSchemaDataProcess;
import com.digiwin.athena.adt.domain.chatbi.ChatbiService;
import com.digiwin.athena.adt.domain.dto.autoData.AgileDataAutoDataDTO;
import com.digiwin.athena.adt.domain.dto.schema.AutoDataQuestionResDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.sse.domain.EventData;
import com.digiwin.athena.adt.sse.domain.SseAniaEventEnum;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.MessageUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Service
@SchemaDataType(value=SchemaDataEnum.AUTO_DATA_QUESTION)
public class SchemaDataProcessAutoDataQuestionServiceImpl
extends AbsSchemaDataProcess
implements SchemaDataProcessService {
    private static final Logger log = LoggerFactory.getLogger(SchemaDataProcessAutoDataQuestionServiceImpl.class);
    @Autowired
    private ChatbiService chatbiService;
    @Autowired
    private EchoService echoService;
    @Autowired
    private MessageUtil messageUtil;
    @Autowired
    private SemcService semcService;

    public Pair<Boolean, QuerySchemaResDTO> process(AthenaMessageEvent event) {
        return null;
    }

    public Map<String, Object> getQuerySchemaReq(AthenaMessageEvent event) {
        event.getQuerySchemaReqDTO().setQuestion(event.getQuestion());
        event.getQuerySchemaReqDTO().setProbe(true);
        event.getQuerySchemaReqDTO().setMultiDialogue(Boolean.valueOf(true));
        event.getQuerySchemaReqDTO().setEnableDataSearch(MapUtils.getBoolean((Map)event.getMsgExt(), (Object)"enableDataSearch", (Boolean)true));
        return CommonUtil.convertObjectToMap((Object)event.getQuerySchemaReqDTO());
    }

    public Pair<Boolean, QuerySchemaResDTO> sseProcess(AthenaMessageEvent event, JSONObject jsonObject) {
        return null;
    }

    public AutoDataQuestionResDTO.AutoDataQuestion.RecognitionResult processAutoData(AthenaMessageEvent event, Map<String, Object> req) {
        AutoDataQuestionResDTO res = new AutoDataQuestionResDTO();
        SseEmitter sseEmitter = event.getSseEmitter();
        try {
            res = this.chatbiService.getIntentionConfirm(event, req);
            if (res == null || res.getData() == null) {
                String sysError = this.messageUtil.getMessageByLangNameWithFormat("message.system.schema.error", event.getLang(), new Object[0]);
                String[] answerSplit = sysError.split("");
                for (int i = 0; i < sysError.length(); ++i) {
                    Thread.sleep(15L);
                    EventData.EventMessage eventMessage = EventData.EventMessage.builderAnswerTextMessage((Object)answerSplit[i]);
                    this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_DELTA.getEvent(), sseEmitter, eventMessage);
                }
                this.sendEventDataMessage(SseAniaEventEnum.CHAT_COMPLETED.getEvent(), sseEmitter, new EventData.EventMessage());
                this.sendEventDataMessage(SseAniaEventEnum.CHAT_DONE.getEvent(), sseEmitter, new EventData.EventMessage());
                sseEmitter.complete();
                return null;
            }
            String resultMsg = res.getData().getCode() == 1 ? res.getData().getReply() : res.getData().getRecognitionResult().getReplay();
            String[] answerSplit = resultMsg.split("");
            for (int i = 0; i < resultMsg.length(); ++i) {
                Thread.sleep(15L);
                EventData.EventMessage eventMessage = EventData.EventMessage.builderAnswerTextMessage((Object)answerSplit[i]);
                this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_DELTA.getEvent(), sseEmitter, eventMessage);
            }
            if (res.getData().getCode() == 1) {
                if (res.getData().getRecognitionResult() != null) {
                    HashMap<String, AutoDataQuestionResDTO.AutoDataQuestion.RecognitionResult> sendMap = new HashMap<String, AutoDataQuestionResDTO.AutoDataQuestion.RecognitionResult>();
                    sendMap.put("recognitionResult", res.getData().getRecognitionResult());
                    this.semcService.sendMessageToGpt(event, sendMap);
                } else {
                    this.sendEventDataMessage(SseAniaEventEnum.CHAT_COMPLETED.getEvent(), sseEmitter, new EventData.EventMessage());
                    this.sendEventDataMessage(SseAniaEventEnum.CHAT_DONE.getEvent(), sseEmitter, new EventData.EventMessage());
                    sseEmitter.complete();
                }
                return null;
            }
            Object title = res.getData().getRecognitionResult().getBlueprint().get("title");
            AgileDataAutoDataDTO agileDataAutoDataDTO = new AgileDataAutoDataDTO();
            agileDataAutoDataDTO.setMessageId(event.getGenerateSerialNo());
            agileDataAutoDataDTO.setFileName(Objects.nonNull(title) ? title.toString() : "");
            this.echoService.saveAutoDataReport(event.getUser(), agileDataAutoDataDTO);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8bed\u4e49\u610f\u56fe\u4fe1\u606f\u5f02\u5e38\uff0c{}", (Object)e.getMessage());
            Thread.currentThread().interrupt();
            return null;
        }
        return res.getData().getRecognitionResult();
    }
}

