/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.process.schema;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.SchemaDataType;
import com.digiwin.athena.adt.agileReport.service.SchemaDataProcessService;
import com.digiwin.athena.adt.agileReport.service.impl.process.schema.AbsSchemaDataProcess;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaReqDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.sse.utils.SseEmitterUtils;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Service
@SchemaDataType(value=SchemaDataEnum.AUTODATA_REPORT)
public class SchemaDataProcessAutoDataReportServiceImpl
extends AbsSchemaDataProcess
implements SchemaDataProcessService {
    private static final Logger log = LoggerFactory.getLogger(SchemaDataProcessAutoDataReportServiceImpl.class);
    @Autowired
    private SemcService semcService;

    public Pair<Boolean, QuerySchemaResDTO> process(AthenaMessageEvent event) {
        return null;
    }

    public Map<String, Object> getQuerySchemaReq(AthenaMessageEvent event) {
        QuerySchemaReqDTO req = QuerySchemaReqDTO.builderSchemaAutoDataReportReq((AthenaMessageEvent)event);
        try {
            LogUtils.buildAgileLog((String)"adt", (String)"NumericalIntelligenceMode", (String)"1", (String)JsonUtils.objectToString((Object)req), (String)"", (String)"");
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"NumericalIntelligenceMode", (String)TroubleToolCodeEnum.ADT_901_0106.getErrCode(), (String)JsonUtils.objectToString((Object)req), (String)TroubleToolCodeEnum.ADT_901_0106.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0106.getSuggestion());
        }
        return CommonUtil.convertObjectToMap((Object)req);
    }

    public Pair<Boolean, QuerySchemaResDTO> sseProcess(AthenaMessageEvent event, JSONObject jsonObject) {
        QuerySchemaResDTO querySchemaResDTO = (QuerySchemaResDTO)JSONObject.parseObject((String)jsonObject.get((Object)"message").toString()).toJavaObject(QuerySchemaResDTO.class);
        if (querySchemaResDTO == null || querySchemaResDTO.getCode() == null) {
            return Pair.of((Object)false, null);
        }
        boolean check = false;
        try {
            Integer code = querySchemaResDTO.getCode();
            if (Objects.isNull(code)) {
                return Pair.of((Object)false, (Object)querySchemaResDTO);
            }
            switch (((Object)code).toString()) {
                case "0": {
                    check = true;
                    break;
                }
                case "1": {
                    String reply = querySchemaResDTO.getReply();
                    SseEmitterUtils.sendAnswerDone((SseEmitter)event.getSseEmitter(), (boolean)true);
                    break;
                }
            }
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"pptAnalysis", (String)TroubleToolCodeEnum.ADT_901_0129.getErrCode(), (String)JsonUtils.objectToString((Object)querySchemaResDTO), (String)TroubleToolCodeEnum.ADT_901_0129.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0129.getSuggestion());
        }
        querySchemaResDTO.setRoute(SchemaDataEnum.AUTODATA_REPORT.getCode());
        Pair result = check ? Pair.of((Object)true, (Object)querySchemaResDTO) : Pair.of((Object)false, (Object)querySchemaResDTO);
        LogUtils.buildAgileLog((String)"adt", (String)"autoData_report", (String)"1", (String)JsonUtils.objectToString((Object)querySchemaResDTO), (String)JsonUtils.objectToString((Object)result), (String)"");
        return result;
    }
}

