/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.process.schema;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.constant.TroubleToolCodeEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.interfaces.SchemaDataType;
import com.digiwin.athena.adt.agileReport.service.SchemaDataProcessService;
import com.digiwin.athena.adt.agileReport.service.impl.process.schema.AbsSchemaDataProcess;
import com.digiwin.athena.adt.domain.chatbi.ChatbiService;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaReqDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.util.CommonUtil;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@SchemaDataType(value=SchemaDataEnum.DESIGNER)
public class SchemaDataProcessDesignerServiceImpl
extends AbsSchemaDataProcess
implements SchemaDataProcessService {
    private static final Logger log = LoggerFactory.getLogger(SchemaDataProcessDesignerServiceImpl.class);
    @Autowired
    private ChatbiService chatbiService;
    @Autowired
    private SemcService semcService;
    @Autowired
    private MessageUtil messageUtil;

    public Pair<Boolean, QuerySchemaResDTO> process(AthenaMessageEvent event) {
        QuerySchemaResDTO schema = new QuerySchemaResDTO();
        QuerySchemaReqDTO req = QuerySchemaReqDTO.builderSchemaDesignerReq((AthenaMessageEvent)event);
        try {
            schema = this.chatbiService.getQuerySchema(req, event);
            LogUtils.buildAgileLog((String)"adt", (String)"NumericalIntelligenceMode", (String)"1", (String)JsonUtils.objectToString((Object)req), (String)JsonUtils.objectToString((Object)schema), (String)"");
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"NumericalIntelligenceMode", (String)TroubleToolCodeEnum.ADT_901_0106.getErrCode(), (String)JsonUtils.objectToString((Object)req), (String)TroubleToolCodeEnum.ADT_901_0106.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0106.getSuggestion());
        }
        return this.absCheckSchemaResponseData(event, schema);
    }

    public Map<String, Object> getQuerySchemaReq(AthenaMessageEvent event) {
        QuerySchemaReqDTO req = QuerySchemaReqDTO.builderSchemaDesignerReq((AthenaMessageEvent)event);
        try {
            LogUtils.buildAgileLog((String)"adt", (String)"NumericalIntelligenceMode", (String)"1", (String)JsonUtils.objectToString((Object)req), (String)"", (String)"");
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"NumericalIntelligenceMode", (String)TroubleToolCodeEnum.ADT_901_0106.getErrCode(), (String)JsonUtils.objectToString((Object)req), (String)TroubleToolCodeEnum.ADT_901_0106.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0106.getSuggestion());
        }
        return CommonUtil.convertObjectToMap((Object)req);
    }

    public boolean checkDataFlowResponseData(QuerySchemaResDTO querySchemaResDTO, AthenaMessageEvent event) {
        boolean isCheck = true;
        try {
            String combinationQuestion = this.getStringBySchemaData(querySchemaResDTO, "combinationQuestion");
            String questionUnderstand = this.getStringBySchemaData(querySchemaResDTO, "questionUnderstand");
            List sceneList = this.getListBySchemaData(querySchemaResDTO, "scenes");
            List targetList = this.getListBySchemaData(querySchemaResDTO, "targets");
            List productLineInfo = this.getListBySchemaData(querySchemaResDTO, "productLineInfo");
            event.setCombinationQuestion(combinationQuestion);
            event.setQuestionUnderstand(questionUnderstand);
            event.setScenes(sceneList);
            event.setTargets(targetList);
            event.setProductLineInfo(productLineInfo);
            this.saveDataFlowEventApplicationMessage(event, querySchemaResDTO);
            for (Map data : querySchemaResDTO.getData().getDataflow()) {
                Object specialMode = data.get("specialMode");
                if (!Objects.nonNull(data.get("code")) || (Integer)data.get("code") == 1) continue;
                HashMap<String, String> msgBody = new HashMap<String, String>();
                if (Objects.nonNull(specialMode)) {
                    this.sendSpecialMessage(data, event);
                } else {
                    msgBody.put("prompt", MapUtils.getString((Map)data, (Object)"data"));
                }
                msgBody.put("scrumbiQuestion", event.getQuestion());
                isCheck = false;
                Object obj = MapUtils.getObject((Map)data, (Object)"sentences", null);
                event.setAnswerResult(Integer.valueOf(2));
                if (obj instanceof Collection) {
                    event.setSentences(CommonUtil.objConvertListString((Object)obj));
                }
                if (event.isSendNana()) {
                    this.semcService.sendMessageToGpt(event, msgBody);
                }
                String errorMsg = this.messageUtil.getMessageByLangNameWithFormat("message.morescene.error", event.getLang(), new Object[0]);
                this.saveAbnormalLog(event, msgBody.containsKey("prompt") ? MapUtils.getString(msgBody, (Object)"prompt") : errorMsg, Integer.valueOf(1), Integer.valueOf(0));
                break;
            }
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"sceneAnalysis", (String)TroubleToolCodeEnum.ADT_901_0113.getErrCode(), (String)JsonUtils.objectToString((Object)querySchemaResDTO), (String)TroubleToolCodeEnum.ADT_901_0113.getErrMsg(), (String)TroubleToolCodeEnum.ADT_901_0113.getSuggestion());
        }
        return isCheck;
    }

    public void saveDataFlowEventApplicationMessage(AthenaMessageEvent event, QuerySchemaResDTO querySchemaResDTO) {
        List scenesList = querySchemaResDTO.getData().getDataflow().stream().map(data -> {
            Object scenesObj = MapUtils.getObject((Map)data, (Object)"scenes");
            return scenesObj instanceof List ? (List)scenesObj : null;
        }).filter(Objects::nonNull).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(scenesList)) {
            Map scenesMap = (Map)scenesList.get(0);
            event.setAppName(Objects.nonNull(scenesMap.get("appName")) ? String.valueOf(scenesMap.get("appName")) : "");
            event.setAppCode(Objects.nonNull(scenesMap.get("appCode")) ? String.valueOf(scenesMap.get("appCode")) : "");
        }
    }

    public Pair<Boolean, QuerySchemaResDTO> sseProcess(AthenaMessageEvent event, JSONObject jsonObject) {
        QuerySchemaResDTO querySchemaResDTO = (QuerySchemaResDTO)JSONObject.parseObject((String)jsonObject.get((Object)"message").toString()).toJavaObject(QuerySchemaResDTO.class);
        return this.absCheckSchemaResponseData(event, querySchemaResDTO);
    }
}

