/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.report;

import com.digiwin.athena.adt.agileReport.config.SchemaDataHandlerProcessor;
import com.digiwin.athena.adt.agileReport.controller.dto.AthenaMessageDTO;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataAssistTroubleService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.domain.chatbi.ChatbiService;
import com.digiwin.athena.adt.domain.dto.ade.ADEScencDTO;
import com.digiwin.athena.adt.domain.dto.agileReport.SceneDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaReqDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class AgileProcessAssistTroubleServiceImpl
extends AbsAgileDataProcess
implements AgileDataAssistTroubleService {
    private static final Logger log = LoggerFactory.getLogger(AgileProcessAssistTroubleServiceImpl.class);
    @Autowired
    private SchemaDataHandlerProcessor schemaDataHandlerProcessor;
    @Autowired
    private ChatbiService chatbiService;

    public ResponseEntity<?> getAssistTroubleData(HttpServletRequest request, String message, String sceneCode, AuthoredUser user) {
        AthenaMessageDTO athenaMessageDTO = new AthenaMessageDTO();
        HashMap extMap = Maps.newHashMap();
        extMap.put("sceneCode", sceneCode);
        extMap.put("question", message);
        athenaMessageDTO.setMsgExt((Map)extMap);
        HashMap msgBody = Maps.newHashMap();
        msgBody.put("text", message);
        athenaMessageDTO.setMsgBody((Map)msgBody);
        AthenaMessageEvent event = this.init(request, athenaMessageDTO, user);
        QuerySchemaReqDTO req = event.getQuerySchemaReqDTO();
        req.setSceneCode(MapUtils.getString((Map)event.getMsgExt(), (Object)"sceneCode"));
        if ("3".equals(event.getMessageType())) {
            req.setDebugMode("3");
            req.setMultiDialogue(Boolean.valueOf(false));
        }
        req.setMessage(message);
        QuerySchemaResDTO responseData = this.chatbiService.getQuerySchema(event.getQuerySchemaReqDTO(), event);
        if (responseData == null || CollectionUtils.isEmpty((Collection)responseData.getData().getDataflow())) {
            return ResponseEntityWrapper.wrapperOk((Object)"\u8bbf\u95ee\u610f\u56fe\u8bc6\u522b\u5931\u8d25");
        }
        ArrayList<ADEScencDTO> adeScencDTOList = new ArrayList<ADEScencDTO>();
        List dataList = responseData.getData().getDataflow();
        ArrayList scenes = Lists.newArrayList();
        block4: for (Map data : dataList) {
            if (MapUtils.isEmpty((Map)data) || !data.containsKey("code")) continue;
            int code = (Integer)data.get("code");
            switch (code) {
                case 1: {
                    List sceneList = (List)MapUtils.getObject((Map)data, (Object)"scenes");
                    String kmCode = "";
                    if (CollectionUtils.isNotEmpty((Collection)sceneList)) {
                        scenes.addAll(sceneList);
                        Boolean isMore = CollectionUtils.isNotEmpty((Collection)scenes) && scenes.size() > 1;
                        if (CollectionUtils.isNotEmpty((Collection)scenes)) {
                            kmCode = MapUtils.getString((Map)((Map)scenes.get(0)), (Object)"sceneCode");
                        }
                    } else {
                        kmCode = MapUtils.getString((Map)data, (Object)"sceneCode");
                    }
                    ADEScencDTO adeScencDTO = this.buildCommodeScene(user, event.getSceneDTO());
                    adeScencDTO.setTemplateCode(MapUtils.getString((Map)data, (Object)"templateCode"));
                    adeScencDTO.setTarget(MapUtils.getString((Map)data, (Object)"target"));
                    adeScencDTO.setDimension(MapUtils.getObject((Map)data, (Object)"dimension"));
                    HashMap sceneMap = Maps.newHashMap();
                    sceneMap.put("templateCode", adeScencDTO.getTemplateCode());
                    sceneMap.put("targetId", adeScencDTO.getTarget());
                    sceneMap.put("dimension", adeScencDTO.getDimension());
                    if (CollectionUtils.isNotEmpty((Collection)sceneList) && sceneList.size() > 1) {
                        sceneMap.put("errorMsg", "\u5b58\u5728\u591a\u573a\u666f\uff0c\u8bf7\u9009\u62e9\u4e00\u4e2a\u573a\u666f\u63a5\u53e3\u52a0\u5165sceneCode\u4f5c\u4e3a\u5165\u53c2\u67e5\u8be2");
                        sceneMap.put("scenes", sceneList);
                        return ResponseEntityWrapper.wrapperOk((Object)sceneMap);
                    }
                    if (StringUtils.isEmpty((CharSequence)kmCode)) {
                        sceneMap.put("errorMsg", "\u4e0d\u5b58\u5728\u8be5\u573a\u666f");
                        return ResponseEntityWrapper.wrapperOk((Object)sceneMap);
                    }
                    adeScencDTO.setSceneCode(kmCode);
                    HashMap recastData = new HashMap();
                    recastData.put(kmCode, data.get("data"));
                    adeScencDTO.setRecast(recastData);
                    adeScencDTOList.add(adeScencDTO);
                    continue block4;
                }
                case 2: {
                    ADEScencDTO adeSceneDTO2 = this.buildCommodeScene(user, event.getSceneDTO());
                    adeSceneDTO2.setQuerySchema(MapUtils.getMap((Map)data, (Object)"data"));
                    adeScencDTOList.add(adeSceneDTO2);
                    continue block4;
                }
            }
            HashMap chartData = Maps.newHashMap();
            chartData.put("chartData", responseData);
            chartData.put("errorMsg", "\u8bed\u4e49\u65e0\u6cd5\u5206\u6790\u6b64\u95ee\u9898");
            return ResponseEntityWrapper.wrapperOk((Object)chartData);
        }
        if (CollectionUtils.isNotEmpty(adeScencDTOList)) {
            return ResponseEntityWrapper.wrapperOk(adeScencDTOList.get(0));
        }
        return ResponseEntityWrapper.wrapperOk((Object)"\u8bed\u4e49\u65e0\u6cd5\u5206\u6790\u6b64\u95ee\u9898");
    }

    private ADEScencDTO buildCommodeScene(AuthoredUser user, SceneDTO sceneDTO) {
        ADEScencDTO adeScencDTO = new ADEScencDTO();
        adeScencDTO.setTenantId(user.getTenantId());
        adeScencDTO.setRequestor(user.getUserId());
        adeScencDTO.setLocale(LocaleContextHolder.getLocale().toString());
        adeScencDTO.setRequestTime(TimeUtils.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy-MM-dd HH:mm:ss"));
        adeScencDTO.setScene(sceneDTO);
        adeScencDTO.setMethod("dataflow");
        return adeScencDTO;
    }
}

