/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.agileReport.service.impl.report;

import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataFeedBackDTO;
import com.digiwin.athena.adt.agileReport.eventbus.AgileDataLogEvent;
import com.digiwin.athena.adt.agileReport.service.AgileReportFeedBackService;
import com.digiwin.athena.adt.domain.dto.AgileDataFeedBack;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.google.common.eventbus.AsyncEventBus;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class AgileReportFeedBackServiceImpl
implements AgileReportFeedBackService {
    private static final Logger log = LoggerFactory.getLogger(AgileReportFeedBackServiceImpl.class);
    @Autowired
    @Qualifier(value="mongoAgileDataLogTemplate")
    private MongoTemplate mongoAgileDataLogTemplate;
    private static final String MONGODB_COLLECTION_NAME = "agile_data_full_log";
    @Autowired
    private AsyncEventBus localEventBus;

    public Boolean saveFeedback(AuthoredUser authoredUser, AgileDataFeedBackDTO agileDataFeedBackDTO, String clientAgent) {
        AgileDataLogEvent event = AgileDataLogEvent.builder().feedbackType(agileDataFeedBackDTO.getFeedbackType()).authoredUser(authoredUser).extendInfo(agileDataFeedBackDTO.getExtendInfo()).generateSerialNo(agileDataFeedBackDTO.getGenerateSerialNo()).terminal(clientAgent).snapshotId(agileDataFeedBackDTO.getSnapshotId()).type(Integer.valueOf(2)).build();
        this.localEventBus.post((Object)event);
        return true;
    }

    public void deleteFeedback(AuthoredUser authoredUser, AgileDataFeedBackDTO agileDataFeedBackDTO) {
        AgileDataLogEvent event = AgileDataLogEvent.builder().answerOpinion("").backContent("").checkOpinions("").feedbackType(Integer.valueOf(4)).authoredUser(authoredUser).generateSerialNo(agileDataFeedBackDTO.getGenerateSerialNo()).type(Integer.valueOf(4)).build();
        this.localEventBus.post((Object)event);
    }

    public void answerBack(AuthoredUser authoredUser, AgileDataFeedBackDTO agileDataFeedBackDTO) {
        AgileDataLogEvent event = AgileDataLogEvent.builder().answerOpinion(agileDataFeedBackDTO.getAnswerOpinion()).backContent(agileDataFeedBackDTO.getBackContent()).checkOpinions(agileDataFeedBackDTO.getCheckOpinions()).authoredUser(authoredUser).generateSerialNo(agileDataFeedBackDTO.getGenerateSerialNo()).type(Integer.valueOf(3)).build();
        this.localEventBus.post((Object)event);
    }

    public List<AgileDataFeedBack> getFeedback(AuthoredUser authoredUser, List<Long> generateSerialNoList) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"generateSerialNo").in(generateSerialNoList).and("userId").is((Object)authoredUser.getUserId()).and("tenantId").is((Object)authoredUser.getTenantId()));
        List agileDataFeedBacks = this.mongoAgileDataLogTemplate.find(query, AgileDataFeedBack.class, MONGODB_COLLECTION_NAME);
        return agileDataFeedBacks;
    }
}

