/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.domain.dto.schema;

import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaDebugDTO;
import com.digiwin.athena.adt.util.CommonUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class QuerySchemaReqDTO
implements Serializable {
    private String message;
    private String question;
    private Boolean multiDialogue;
    private Boolean explain;
    private Boolean timeTrace;
    private String sessionId;
    private String targetId;
    private String sceneCode;
    private String debugMode;
    private List<String> metricIdList;
    private String appCode;
    private String version;
    private String method;
    private String userId;
    private String userName;
    private String combinationMsg;
    private String asaCode;
    private boolean closeStream;
    private String productVersion;
    private List<String> datasetIdList;
    private boolean probe;
    private String sectionId;
    private String messageId4Ania;
    private String conversationId;
    private String appVersion;
    private Map<String, Object> intentConfirmResult;
    private Map<String, Object> param;
    private Boolean enableDataSearch;
    private Boolean enableDataRecommend;

    public static QuerySchemaReqDTO builderSchemaReq(AthenaMessageEvent event) {
        QuerySchemaReqDTO querySchemaReqDTO = new QuerySchemaReqDTO();
        querySchemaReqDTO.setUserId(event.getUser().getUserId());
        querySchemaReqDTO.setUserName(event.getUser().getUserName());
        querySchemaReqDTO.setSessionId(event.getSessionId());
        querySchemaReqDTO.setMessage(event.getQuestion());
        querySchemaReqDTO.setAsaCode(event.getAsaCode());
        return querySchemaReqDTO;
    }

    public static QuerySchemaReqDTO builderSchemaDesignerReq(AthenaMessageEvent event) {
        QuerySchemaReqDTO req = event.getQuerySchemaReqDTO();
        req.setSceneCode(MapUtils.getString((Map)event.getMsgExt(), (Object)"sceneCode"));
        req.setTargetId(MapUtils.getString((Map)event.getMsgExt(), (Object)"targetId"));
        if (StringUtils.isEmpty((CharSequence)req.getAppCode())) {
            req.setAppCode(MapUtils.getString((Map)event.getMsgExt(), (Object)"applicationCode"));
        }
        List metricIdListObj = CommonUtil.objConvertListString(event.getMsgExt().get("metricIdList"));
        String multiDialogue = MapUtils.getString((Map)event.getMsgExt(), (Object)"multiDialogue");
        if (StringUtils.isNotEmpty((CharSequence)multiDialogue)) {
            req.setMultiDialogue(Boolean.valueOf(multiDialogue));
        }
        if (CollectionUtils.isEmpty((Collection)req.getMetricIdList())) {
            req.setMetricIdList(metricIdListObj);
        }
        if (event.isDebug()) {
            req.setDebugMode("3");
            req.setMultiDialogue(Boolean.valueOf(false));
        }
        if ((StringUtils.isNotEmpty((CharSequence)req.getSceneCode()) || StringUtils.isNotEmpty((CharSequence)req.getTargetId()) || CollectionUtils.isNotEmpty((Collection)req.getMetricIdList()) || StringUtils.isNotEmpty((CharSequence)req.getAppCode())) && !req.getMultiDialogue().booleanValue()) {
            req.setMultiDialogue(Boolean.valueOf(false));
        }
        if (event.getTenantConfig() != null) {
            req.setEnableDataRecommend(event.getTenantConfig().getEnableDataRecommend());
        }
        return req;
    }

    public static QuerySchemaReqDTO builderSchemaMetricDebugReq(AthenaMessageEvent event, QuerySchemaDebugDTO querySchemaDebugDTO) {
        QuerySchemaReqDTO req = event.getQuerySchemaReqDTO();
        req.setMessage(querySchemaDebugDTO.getQuestion());
        req.setDebugMode("5");
        req.setAppCode(querySchemaDebugDTO.getApplicationCode());
        req.setMultiDialogue(Boolean.valueOf(false));
        event.setDebug(true);
        return req;
    }

    public static QuerySchemaReqDTO builderSchemaParamReq(AthenaMessageEvent event, QuerySchemaDebugDTO querySchemaParamDTO) {
        QuerySchemaReqDTO req = event.getQuerySchemaReqDTO();
        String question2 = event.getQuestion();
        if (question2.contains("*param*")) {
            req.setDebugMode("1");
        }
        if (question2.contains("*pr-param*")) {
            req.setDebugMode("2");
        }
        if (StringUtils.isNotEmpty((CharSequence)querySchemaParamDTO.getSceneCode())) {
            req.setSceneCode(querySchemaParamDTO.getSceneCode());
        }
        req.setMessage(querySchemaParamDTO.getQuestion());
        req.setMultiDialogue(Boolean.valueOf(false));
        return req;
    }

    public static QuerySchemaReqDTO builderSchemaPPTAnalyzeReq(AthenaMessageEvent event) {
        QuerySchemaReqDTO req = event.getQuerySchemaReqDTO();
        if (StringUtils.isEmpty((CharSequence)req.getAppCode())) {
            req.setAppCode(MapUtils.getString((Map)event.getMsgExt(), (Object)"applicationCode"));
        }
        req.setQuestion(event.getQuestion());
        req.setCloseStream(false);
        return req;
    }

    public static QuerySchemaReqDTO builderSchemaAutoDataReportReq(AthenaMessageEvent event) {
        QuerySchemaReqDTO req = event.getQuerySchemaReqDTO();
        req.setSceneCode(MapUtils.getString((Map)event.getMsgExt(), (Object)"sceneCode"));
        req.setTargetId(MapUtils.getString((Map)event.getMsgExt(), (Object)"targetId"));
        req.setIntentConfirmResult(MapUtils.getMap((Map)event.getMsgExt(), (Object)"reportSpec"));
        if (StringUtils.isEmpty((CharSequence)req.getAppCode())) {
            req.setAppCode(MapUtils.getString((Map)event.getMsgExt(), (Object)"applicationCode"));
        }
        List metricIdListObj = CommonUtil.objConvertListString(event.getMsgExt().get("metricIdList"));
        String multiDialogue = MapUtils.getString((Map)event.getMsgExt(), (Object)"multiDialogue");
        if (StringUtils.isNotEmpty((CharSequence)multiDialogue)) {
            req.setMultiDialogue(Boolean.valueOf(multiDialogue));
        }
        if (CollectionUtils.isEmpty((Collection)req.getMetricIdList())) {
            req.setMetricIdList(metricIdListObj);
        }
        if (event.isDebug()) {
            req.setDebugMode("3");
            req.setMultiDialogue(Boolean.valueOf(false));
        }
        if ((StringUtils.isNotEmpty((CharSequence)req.getSceneCode()) || StringUtils.isNotEmpty((CharSequence)req.getTargetId()) || CollectionUtils.isNotEmpty((Collection)req.getMetricIdList()) || StringUtils.isNotEmpty((CharSequence)req.getAppCode())) && !req.getMultiDialogue().booleanValue()) {
            req.setMultiDialogue(Boolean.valueOf(false));
        }
        return req;
    }

    public String getMessage() {
        return this.message;
    }

    public String getQuestion() {
        return this.question;
    }

    public Boolean getMultiDialogue() {
        return this.multiDialogue;
    }

    public Boolean getExplain() {
        return this.explain;
    }

    public Boolean getTimeTrace() {
        return this.timeTrace;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getSceneCode() {
        return this.sceneCode;
    }

    public String getDebugMode() {
        return this.debugMode;
    }

    public List<String> getMetricIdList() {
        return this.metricIdList;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getCombinationMsg() {
        return this.combinationMsg;
    }

    public String getAsaCode() {
        return this.asaCode;
    }

    public boolean isCloseStream() {
        return this.closeStream;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public List<String> getDatasetIdList() {
        return this.datasetIdList;
    }

    public boolean isProbe() {
        return this.probe;
    }

    public String getSectionId() {
        return this.sectionId;
    }

    public String getMessageId4Ania() {
        return this.messageId4Ania;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public Map<String, Object> getIntentConfirmResult() {
        return this.intentConfirmResult;
    }

    public Map<String, Object> getParam() {
        return this.param;
    }

    public Boolean getEnableDataSearch() {
        return this.enableDataSearch;
    }

    public Boolean getEnableDataRecommend() {
        return this.enableDataRecommend;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setQuestion(String question2) {
        this.question = question2;
    }

    public void setMultiDialogue(Boolean multiDialogue) {
        this.multiDialogue = multiDialogue;
    }

    public void setExplain(Boolean explain) {
        this.explain = explain;
    }

    public void setTimeTrace(Boolean timeTrace) {
        this.timeTrace = timeTrace;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public void setSceneCode(String sceneCode) {
        this.sceneCode = sceneCode;
    }

    public void setDebugMode(String debugMode) {
        this.debugMode = debugMode;
    }

    public void setMetricIdList(List<String> metricIdList) {
        this.metricIdList = metricIdList;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setCombinationMsg(String combinationMsg) {
        this.combinationMsg = combinationMsg;
    }

    public void setAsaCode(String asaCode) {
        this.asaCode = asaCode;
    }

    public void setCloseStream(boolean closeStream) {
        this.closeStream = closeStream;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public void setDatasetIdList(List<String> datasetIdList) {
        this.datasetIdList = datasetIdList;
    }

    public void setProbe(boolean probe) {
        this.probe = probe;
    }

    public void setSectionId(String sectionId) {
        this.sectionId = sectionId;
    }

    public void setMessageId4Ania(String messageId4Ania) {
        this.messageId4Ania = messageId4Ania;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public void setIntentConfirmResult(Map<String, Object> intentConfirmResult) {
        this.intentConfirmResult = intentConfirmResult;
    }

    public void setParam(Map<String, Object> param) {
        this.param = param;
    }

    public void setEnableDataSearch(Boolean enableDataSearch) {
        this.enableDataSearch = enableDataSearch;
    }

    public void setEnableDataRecommend(Boolean enableDataRecommend) {
        this.enableDataRecommend = enableDataRecommend;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuerySchemaReqDTO)) {
            return false;
        }
        QuerySchemaReqDTO other = (QuerySchemaReqDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$question = this.getQuestion();
        String other$question = other.getQuestion();
        if (this$question == null ? other$question != null : !this$question.equals(other$question)) {
            return false;
        }
        Boolean this$multiDialogue = this.getMultiDialogue();
        Boolean other$multiDialogue = other.getMultiDialogue();
        if (this$multiDialogue == null ? other$multiDialogue != null : !((Object)this$multiDialogue).equals(other$multiDialogue)) {
            return false;
        }
        Boolean this$explain = this.getExplain();
        Boolean other$explain = other.getExplain();
        if (this$explain == null ? other$explain != null : !((Object)this$explain).equals(other$explain)) {
            return false;
        }
        Boolean this$timeTrace = this.getTimeTrace();
        Boolean other$timeTrace = other.getTimeTrace();
        if (this$timeTrace == null ? other$timeTrace != null : !((Object)this$timeTrace).equals(other$timeTrace)) {
            return false;
        }
        String this$sessionId = this.getSessionId();
        String other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
            return false;
        }
        String this$targetId = this.getTargetId();
        String other$targetId = other.getTargetId();
        if (this$targetId == null ? other$targetId != null : !this$targetId.equals(other$targetId)) {
            return false;
        }
        String this$sceneCode = this.getSceneCode();
        String other$sceneCode = other.getSceneCode();
        if (this$sceneCode == null ? other$sceneCode != null : !this$sceneCode.equals(other$sceneCode)) {
            return false;
        }
        String this$debugMode = this.getDebugMode();
        String other$debugMode = other.getDebugMode();
        if (this$debugMode == null ? other$debugMode != null : !this$debugMode.equals(other$debugMode)) {
            return false;
        }
        List this$metricIdList = this.getMetricIdList();
        List other$metricIdList = other.getMetricIdList();
        if (this$metricIdList == null ? other$metricIdList != null : !((Object)this$metricIdList).equals(other$metricIdList)) {
            return false;
        }
        String this$appCode = this.getAppCode();
        String other$appCode = other.getAppCode();
        if (this$appCode == null ? other$appCode != null : !this$appCode.equals(other$appCode)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$combinationMsg = this.getCombinationMsg();
        String other$combinationMsg = other.getCombinationMsg();
        if (this$combinationMsg == null ? other$combinationMsg != null : !this$combinationMsg.equals(other$combinationMsg)) {
            return false;
        }
        String this$asaCode = this.getAsaCode();
        String other$asaCode = other.getAsaCode();
        if (this$asaCode == null ? other$asaCode != null : !this$asaCode.equals(other$asaCode)) {
            return false;
        }
        if (this.isCloseStream() != other.isCloseStream()) {
            return false;
        }
        String this$productVersion = this.getProductVersion();
        String other$productVersion = other.getProductVersion();
        if (this$productVersion == null ? other$productVersion != null : !this$productVersion.equals(other$productVersion)) {
            return false;
        }
        List this$datasetIdList = this.getDatasetIdList();
        List other$datasetIdList = other.getDatasetIdList();
        if (this$datasetIdList == null ? other$datasetIdList != null : !((Object)this$datasetIdList).equals(other$datasetIdList)) {
            return false;
        }
        if (this.isProbe() != other.isProbe()) {
            return false;
        }
        String this$sectionId = this.getSectionId();
        String other$sectionId = other.getSectionId();
        if (this$sectionId == null ? other$sectionId != null : !this$sectionId.equals(other$sectionId)) {
            return false;
        }
        String this$messageId4Ania = this.getMessageId4Ania();
        String other$messageId4Ania = other.getMessageId4Ania();
        if (this$messageId4Ania == null ? other$messageId4Ania != null : !this$messageId4Ania.equals(other$messageId4Ania)) {
            return false;
        }
        String this$conversationId = this.getConversationId();
        String other$conversationId = other.getConversationId();
        if (this$conversationId == null ? other$conversationId != null : !this$conversationId.equals(other$conversationId)) {
            return false;
        }
        String this$appVersion = this.getAppVersion();
        String other$appVersion = other.getAppVersion();
        if (this$appVersion == null ? other$appVersion != null : !this$appVersion.equals(other$appVersion)) {
            return false;
        }
        Map this$intentConfirmResult = this.getIntentConfirmResult();
        Map other$intentConfirmResult = other.getIntentConfirmResult();
        if (this$intentConfirmResult == null ? other$intentConfirmResult != null : !((Object)this$intentConfirmResult).equals(other$intentConfirmResult)) {
            return false;
        }
        Map this$param = this.getParam();
        Map other$param = other.getParam();
        if (this$param == null ? other$param != null : !((Object)this$param).equals(other$param)) {
            return false;
        }
        Boolean this$enableDataSearch = this.getEnableDataSearch();
        Boolean other$enableDataSearch = other.getEnableDataSearch();
        if (this$enableDataSearch == null ? other$enableDataSearch != null : !((Object)this$enableDataSearch).equals(other$enableDataSearch)) {
            return false;
        }
        Boolean this$enableDataRecommend = this.getEnableDataRecommend();
        Boolean other$enableDataRecommend = other.getEnableDataRecommend();
        return !(this$enableDataRecommend == null ? other$enableDataRecommend != null : !((Object)this$enableDataRecommend).equals(other$enableDataRecommend));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QuerySchemaReqDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $question = this.getQuestion();
        result = result * 59 + ($question == null ? 43 : $question.hashCode());
        Boolean $multiDialogue = this.getMultiDialogue();
        result = result * 59 + ($multiDialogue == null ? 43 : ((Object)$multiDialogue).hashCode());
        Boolean $explain = this.getExplain();
        result = result * 59 + ($explain == null ? 43 : ((Object)$explain).hashCode());
        Boolean $timeTrace = this.getTimeTrace();
        result = result * 59 + ($timeTrace == null ? 43 : ((Object)$timeTrace).hashCode());
        String $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
        String $targetId = this.getTargetId();
        result = result * 59 + ($targetId == null ? 43 : $targetId.hashCode());
        String $sceneCode = this.getSceneCode();
        result = result * 59 + ($sceneCode == null ? 43 : $sceneCode.hashCode());
        String $debugMode = this.getDebugMode();
        result = result * 59 + ($debugMode == null ? 43 : $debugMode.hashCode());
        List $metricIdList = this.getMetricIdList();
        result = result * 59 + ($metricIdList == null ? 43 : ((Object)$metricIdList).hashCode());
        String $appCode = this.getAppCode();
        result = result * 59 + ($appCode == null ? 43 : $appCode.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $combinationMsg = this.getCombinationMsg();
        result = result * 59 + ($combinationMsg == null ? 43 : $combinationMsg.hashCode());
        String $asaCode = this.getAsaCode();
        result = result * 59 + ($asaCode == null ? 43 : $asaCode.hashCode());
        result = result * 59 + (this.isCloseStream() ? 79 : 97);
        String $productVersion = this.getProductVersion();
        result = result * 59 + ($productVersion == null ? 43 : $productVersion.hashCode());
        List $datasetIdList = this.getDatasetIdList();
        result = result * 59 + ($datasetIdList == null ? 43 : ((Object)$datasetIdList).hashCode());
        result = result * 59 + (this.isProbe() ? 79 : 97);
        String $sectionId = this.getSectionId();
        result = result * 59 + ($sectionId == null ? 43 : $sectionId.hashCode());
        String $messageId4Ania = this.getMessageId4Ania();
        result = result * 59 + ($messageId4Ania == null ? 43 : $messageId4Ania.hashCode());
        String $conversationId = this.getConversationId();
        result = result * 59 + ($conversationId == null ? 43 : $conversationId.hashCode());
        String $appVersion = this.getAppVersion();
        result = result * 59 + ($appVersion == null ? 43 : $appVersion.hashCode());
        Map $intentConfirmResult = this.getIntentConfirmResult();
        result = result * 59 + ($intentConfirmResult == null ? 43 : ((Object)$intentConfirmResult).hashCode());
        Map $param = this.getParam();
        result = result * 59 + ($param == null ? 43 : ((Object)$param).hashCode());
        Boolean $enableDataSearch = this.getEnableDataSearch();
        result = result * 59 + ($enableDataSearch == null ? 43 : ((Object)$enableDataSearch).hashCode());
        Boolean $enableDataRecommend = this.getEnableDataRecommend();
        result = result * 59 + ($enableDataRecommend == null ? 43 : ((Object)$enableDataRecommend).hashCode());
        return result;
    }

    public String toString() {
        return "QuerySchemaReqDTO(message=" + this.getMessage() + ", question=" + this.getQuestion() + ", multiDialogue=" + this.getMultiDialogue() + ", explain=" + this.getExplain() + ", timeTrace=" + this.getTimeTrace() + ", sessionId=" + this.getSessionId() + ", targetId=" + this.getTargetId() + ", sceneCode=" + this.getSceneCode() + ", debugMode=" + this.getDebugMode() + ", metricIdList=" + this.getMetricIdList() + ", appCode=" + this.getAppCode() + ", version=" + this.getVersion() + ", method=" + this.getMethod() + ", userId=" + this.getUserId() + ", userName=" + this.getUserName() + ", combinationMsg=" + this.getCombinationMsg() + ", asaCode=" + this.getAsaCode() + ", closeStream=" + this.isCloseStream() + ", productVersion=" + this.getProductVersion() + ", datasetIdList=" + this.getDatasetIdList() + ", probe=" + this.isProbe() + ", sectionId=" + this.getSectionId() + ", messageId4Ania=" + this.getMessageId4Ania() + ", conversationId=" + this.getConversationId() + ", appVersion=" + this.getAppVersion() + ", intentConfirmResult=" + this.getIntentConfirmResult() + ", param=" + this.getParam() + ", enableDataSearch=" + this.getEnableDataSearch() + ", enableDataRecommend=" + this.getEnableDataRecommend() + ")";
    }
}

