/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.domain.file;

import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataEngineFileDownModel;
import com.digiwin.athena.adt.domain.dto.FileParsingPPTRes;
import com.digiwin.athena.adt.domain.dto.autoData.AgileDataAutoDataReportDTO;
import com.digiwin.athena.adt.domain.file.FileParsingService;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class FileParsingServiceImpl
implements FileParsingService {
    private static final Logger log = LoggerFactory.getLogger(FileParsingServiceImpl.class);
    @Autowired(required=false)
    private RestTemplate restTemplate;
    @Value(value="${fileparsing.uri:}")
    private String fileParsingUrl;

    public AgileDataEngineFileDownModel getDmcShareUrl(String tenantId, String userToken, String locale, Map<String, Object> data) {
        LogDto logDto = new LogDto("\u8c03\u7528fileParsing \u83b7\u53d6url :{} ", JsonUtils.objectToString(data));
        Long startTime = System.currentTimeMillis();
        String url = this.fileParsingUrl + "/fileparsing/getDmcShareUrl";
        long getQuerySchemaTook = System.currentTimeMillis();
        log.info(logDto.toString());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", userToken);
        headers.set("userToken", userToken);
        headers.set("tenantId", tenantId);
        headers.set("locale", "zh_CN");
        HttpEntity httpEntity = new HttpEntity(data, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("\u8c03\u7528 fileParsing  \u8fd4\u53c2\uff1a{}, \u8017\u65f6:{}", (Object)JsonUtils.objectToString((Object)response), (Object)(getQuerySchemaTook - startTime + "\u6beb\u79d2"));
            return (AgileDataEngineFileDownModel)response.getBody();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public FileParsingPPTRes getFileParsingPPT(String tenantId, String userToken, String locale, Map<String, Object> data) {
        LogDto logDto = new LogDto("\u8c03\u7528fileParsing\u751f\u6210ppt \u83b7\u53d6url :{} ", JsonUtils.objectToString(data));
        Long startTime = System.currentTimeMillis();
        String url = this.fileParsingUrl + "/fileparsing/getPPTDmcShareUrl";
        long getQuerySchemaTook = System.currentTimeMillis();
        log.info(logDto.toString());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", userToken);
        headers.set("userToken", userToken);
        headers.set("tenantId", tenantId);
        headers.set("locale", "zh_CN");
        HttpEntity httpEntity = new HttpEntity(data, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("\u8c03\u7528 fileParsing  \u8fd4\u53c2\uff1a{}, \u8017\u65f6:{}", (Object)JsonUtils.objectToString((Object)response), (Object)(getQuerySchemaTook - startTime + "\u6beb\u79d2"));
            return (FileParsingPPTRes)response.getBody();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public AgileDataAutoDataReportDTO getFileParsingAutoDataReport(String tenantId, String userToken, String locale, Map<String, Object> data) {
        LogDto logDto = new LogDto("\u8c03\u7528fileParsing\u751f\u6210\u5206\u6790\u5e08\u62a5\u544a \u83b7\u53d6url :{} ", JsonUtils.objectToString(data));
        Long startTime = System.currentTimeMillis();
        String url = this.fileParsingUrl + "/fileparsing/getDmcUrlByMarkDown";
        long getQuerySchemaTook = System.currentTimeMillis();
        log.info(logDto.toString());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", userToken);
        headers.set("userToken", userToken);
        headers.set("tenantId", tenantId);
        headers.set("locale", "zh_CN");
        HttpEntity httpEntity = new HttpEntity(data, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("\u8c03\u7528 fileParsing\u751f\u6210\u5206\u6790\u5e08\u62a5\u544a  \u8fd4\u53c2\uff1a{}, \u8017\u65f6:{}", (Object)JsonUtils.objectToString((Object)response), (Object)(getQuerySchemaTook - startTime + "\u6beb\u79d2"));
            return (AgileDataAutoDataReportDTO)response.getBody();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

