/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.domain.repository.mongo.impl;

import com.digiwin.athena.adt.domain.dto.mongo.AgileDataChartSnapshot;
import com.digiwin.athena.adt.domain.repository.mongo.AgileDataChartSnapshotRepository;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Repository;

@Repository(value="agileDataChartSnapshotRepository")
public class AgileDataChartSnapshotRepositoryImpl
implements AgileDataChartSnapshotRepository {
    @Autowired
    @Qualifier(value="mongoAgileDataPageViewTemplate")
    private MongoTemplate mongoAgileDataPageViewTemplate;
    private static final String COLLECTION = "agile_data_chart_snapshot";

    public void saveOrUpdate(AgileDataChartSnapshot snapshot) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"snapshotId").is((Object)snapshot.getSnapshotId()).and("chartType").is((Object)snapshot.getChartType()));
        AgileDataChartSnapshot exist = (AgileDataChartSnapshot)this.mongoAgileDataPageViewTemplate.findOne(query, AgileDataChartSnapshot.class, COLLECTION);
        if (Objects.isNull(exist)) {
            this.mongoAgileDataPageViewTemplate.insert((Object)snapshot, COLLECTION);
        } else {
            Update update = new Update();
            update.set("chartType", (Object)snapshot.getChartType());
            update.set("snapshotContent", (Object)snapshot.getSnapshotContent());
            this.mongoAgileDataPageViewTemplate.upsert(query, (UpdateDefinition)update, AgileDataChartSnapshot.class, COLLECTION);
        }
    }

    public AgileDataChartSnapshot findBySnapshotIdAndChartType(String snapshotId, String chartType) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"snapshotId").is((Object)snapshotId).and("chartType").is((Object)chartType));
        return (AgileDataChartSnapshot)this.mongoAgileDataPageViewTemplate.findOne(query, AgileDataChartSnapshot.class, COLLECTION);
    }
}

