/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.domain.uibot.impl;

import com.digiwin.athena.adt.agileReport.constant.ErrorCodeEnum;
import com.digiwin.athena.adt.domain.uibot.UIBOTService;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class UIBOTServiceImpl
implements UIBOTService {
    private static final Logger log = LoggerFactory.getLogger(UIBOTServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;

    public Map<String, Object> compensateAgileData(Map<String, Object> pullData) {
        String url = this.envProperties.getUibotUri() + "/api/ai/v1/agile/report/compensate/data";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(pullData, (MultiValueMap)headers);
        try {
            log.info("\u8bf7\u6c42\u8865\u507f\u6570\u636e\uff0c\u6570\u636e\u4fe1\u606f:{}", (Object)JsonUtils.objectToString(pullData));
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            return (Map)((BaseResultDTO)response.getBody()).getResponse();
        }
        catch (Exception ex) {
            log.error("{}, \u8bf7\u6c42\u8865\u507f\u6307\u6807\u5361body\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{ErrorCodeEnum.UIBOT_DATA_AGILEDATA_FAIL.getErrCode(), JsonUtils.objectToString(pullData), ex});
            return null;
        }
    }
}

