/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.job;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.adt.agileReport.dao.SnapShotDataMapper;
import com.digiwin.athena.adt.domain.dmc.DmcService;
import com.digiwin.athena.adt.domain.po.SnapData;
import com.digiwin.athena.atmc.http.restful.iam.TenantService;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Component;

@Component
public class SnapShotTaskJob {
    private static final Logger log = LoggerFactory.getLogger(SnapShotTaskJob.class);
    private static final int LIMIT_AMOUNT = 1000;
    @Autowired
    private SnapShotDataMapper snapShotDataMapper;
    @Autowired
    private DmcService dmcService;
    @Autowired
    TenantService tenantService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    private static final String LOCK_KEY = "deleteRealtimeDataLock";
    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final long DELETE_FIXED_RATE = 300000L;
    private static final long LOCK_EXPIRE = 3L;
    private static final String DMC_ID = "dmcId";
    private static final String TENANT_ID = "tenantId";
    private static final String REQUEST_TIME = "requestTime";
    private static final String ENTRY = "entry";
    private static final String DELETE_FAILED = "deleteFailed";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XxlJob(value="deleteRealtimeDataJobHandler")
    public void deleteRealtimeData() {
        String lockValue = String.valueOf(System.currentTimeMillis() + 3000L);
        if (!this.tryAcquireLock(LOCK_KEY, lockValue, 3L)) {
            log.info("\u4efb\u52a1\u83b7\u53d6\u9501\u5931\u8d25");
            XxlJobHelper.log((String)"\u4efb\u52a1\u83b7\u53d6\u9501\u5931\u8d25", (Object[])new Object[0]);
            return;
        }
        try {
            LocalDateTime sevenDaysAgo = LocalDateTime.now().minusWeeks(1L);
            log.info("\u5220\u9664{}\u4e4b\u524d\u7684\u5b9e\u65f6\u6570\u636e", (Object)sevenDaysAgo.format(this.formatter));
            XxlJobHelper.log((String)"\u5220\u9664{}\u4e4b\u524d\u7684\u5b9e\u65f6\u6570\u636e", (Object[])new Object[]{sevenDaysAgo.format(this.formatter)});
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.select(new String[]{DMC_ID, TENANT_ID}).lt((Object)REQUEST_TIME, (Object)sevenDaysAgo)).eq((Object)ENTRY, (Object)"1")).le((Object)DELETE_FAILED, (Object)3)).orderByDesc((Object)REQUEST_TIME)).last(String.format("limit %d", 1000));
            List results = this.snapShotDataMapper.selectList((Wrapper)queryWrapper);
            if (results.isEmpty()) {
                log.info("\u6ca1\u6709\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e, \u672c\u6b21\u4efb\u52a1\u7ed3\u675f");
                XxlJobHelper.log((String)"\u6ca1\u6709\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e, \u672c\u6b21\u4efb\u52a1\u7ed3\u675f", (Object[])new Object[0]);
                return;
            }
            Map groupedByTenantId = results.stream().collect(Collectors.groupingBy(SnapData::getTenantId, Collectors.mapping(SnapData::getDmcId, Collectors.toList())));
            groupedByTenantId.forEach((tenantId, dmcIdList) -> {
                try {
                    QueryWrapper deleteWrapper = new QueryWrapper();
                    deleteWrapper.in((Object)DMC_ID, (Collection)dmcIdList);
                    this.snapShotDataMapper.delete((Wrapper)deleteWrapper);
                    String resultToken = this.tenantService.queryApiVirtualToken(tenantId).getString("token");
                    this.dmcService.deleteBatchAgileData(Collections.emptyList(), (Collection)dmcIdList, resultToken);
                }
                catch (Exception e) {
                    XxlJobHelper.log((String)"\u5220\u9664TenantId\u4e3a{}\u7684\u6570\u636e\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object[])new Object[]{tenantId, e.getMessage()});
                    log.error("\u5220\u9664TenantId\u4e3a{}\u7684\u6570\u636e\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", tenantId, (Object)e.getMessage());
                    this.updateDeleteFailedCount((Collection)dmcIdList);
                }
            });
        }
        catch (Exception ex) {
            XxlJobHelper.log((String)"\u5b9a\u65f6\u4efb\u52a1\u5220\u9664\u5b9e\u65f6\u6570\u636e\u5931\u8d25\uff1a{}, \u6b64\u6b21\u4efb\u52a1\u7ed3\u675f\u7b49\u5f85\u4e0b\u6b21\u7ee7\u7eed\u5220\u9664", (Object[])new Object[]{ex.getMessage(), ex});
            log.error("\u5b9a\u65f6\u4efb\u52a1\u5220\u9664\u5b9e\u65f6\u6570\u636e\u5931\u8d25\uff1a{}, \u6b64\u6b21\u4efb\u52a1\u7ed3\u675f\u7b49\u5f85\u4e0b\u6b21\u7ee7\u7eed\u5220\u9664", (Object)ex.getMessage(), (Object)ex);
        }
        finally {
            this.releaseLock(LOCK_KEY, lockValue);
        }
    }

    private void updateDeleteFailedCount(Collection<String> dmcIds) {
        if (dmcIds == null || dmcIds.isEmpty()) {
            XxlJobHelper.log((String)"No dmcIds provided for updating delete failed count.", (Object[])new Object[0]);
            log.info("No dmcIds provided for updating delete failed count.");
            return;
        }
        for (String dmcId : dmcIds) {
            try {
                this.snapShotDataMapper.incrementDeleteFailedCount(dmcId);
            }
            catch (Exception e) {
                XxlJobHelper.log((String)"Failed to increment deleteFailed for dmcId {}: {}", (Object[])new Object[]{dmcId, e.getMessage()});
                log.error("Failed to increment deleteFailed for dmcId {}: {}", (Object)dmcId, (Object)e.getMessage());
            }
        }
    }

    @XxlJob(value="deleteFailDataJobHandler")
    public void deleteFailData() {
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.select(new String[]{DMC_ID, TENANT_ID}).eq((Object)ENTRY, (Object)"1")).ge((Object)DELETE_FAILED, (Object)3)).orderByDesc((Object)REQUEST_TIME)).last("limit 10");
            List results = this.snapShotDataMapper.selectList((Wrapper)queryWrapper);
            if (results.isEmpty()) {
                log.info("\u6ca1\u6709\u627e\u5230\u7b26\u5408\u4e8c\u6b21\u5220\u9664\u6761\u4ef6\u7684\u6570\u636e, \u672c\u6b21\u4e8c\u6b21\u5220\u9664\u4efb\u52a1\u7ed3\u675f");
                XxlJobHelper.log((String)"\u6ca1\u6709\u627e\u5230\u7b26\u5408\u4e8c\u6b21\u5220\u9664\u6761\u4ef6\u7684\u6570\u636e, \u672c\u6b21\u4e8c\u6b21\u5220\u9664\u4efb\u52a1\u7ed3\u675f", (Object[])new Object[0]);
                return;
            }
            Map groupedByTenantId = results.stream().collect(Collectors.groupingBy(SnapData::getTenantId, Collectors.mapping(SnapData::getDmcId, Collectors.toList())));
            groupedByTenantId.forEach((tenantId, dmcIdList) -> {
                try {
                    QueryWrapper deleteWrapper = new QueryWrapper();
                    deleteWrapper.in((Object)DMC_ID, (Collection)dmcIdList);
                    this.snapShotDataMapper.delete((Wrapper)deleteWrapper);
                    String resultToken = this.tenantService.queryApiVirtualToken(tenantId).getString("token");
                    this.dmcService.deleteBatchAgileData(Collections.emptyList(), (Collection)dmcIdList, resultToken);
                    log.info("\u6210\u529f\u5220\u9664TenantId\u4e3a{}\u7684\u6570\u636e\uff0cDmcId\u5217\u8868\uff1a{}", tenantId, dmcIdList);
                    XxlJobHelper.log((String)"\u6210\u529f\u5220\u9664TenantId\u4e3a{}\u7684\u6570\u636e\uff0cDmcId\u5217\u8868\uff1a{}", (Object[])new Object[]{tenantId, dmcIdList});
                }
                catch (Exception e) {
                    XxlJobHelper.log((String)"\u5220\u9664TenantId\u4e3a{}\u7684\u6570\u636e\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object[])new Object[]{tenantId, e.getMessage()});
                    log.error("\u5220\u9664TenantId\u4e3a{}\u7684\u6570\u636e\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", tenantId, (Object)e.getMessage());
                    this.updateDeleteFailedCount((Collection)dmcIdList);
                }
            });
        }
        catch (Exception ex) {
            XxlJobHelper.log((String)"\u5b9a\u65f6\u4e8c\u6b21\u5220\u9664\u4efb\u52a1\u5b9e\u65f6\u6570\u636e\u5931\u8d25\uff1a{}, \u6b64\u6b21\u4efb\u52a1\u7ed3\u675f\u7b49\u5f85\u4e0b\u6b21\u7ee7\u7eed\u5220\u9664", (Object[])new Object[]{ex.getMessage(), ex});
            log.error("\u5b9a\u65f6\u4e8c\u6b21\u5220\u9664\u4efb\u52a1\u5b9e\u65f6\u6570\u636e\u5931\u8d25\uff1a{}, \u6b64\u6b21\u4efb\u52a1\u7ed3\u675f\u7b49\u5f85\u4e0b\u6b21\u7ee7\u7eed\u5220\u9664", (Object)ex.getMessage(), (Object)ex);
        }
    }

    private boolean tryAcquireLock(String lockKey, String lockValue, long lockExpire) {
        ValueOperations ops = this.stringRedisTemplate.opsForValue();
        Boolean acquired = ops.setIfAbsent((Object)lockKey, (Object)lockValue, lockExpire, TimeUnit.SECONDS);
        return Boolean.TRUE.equals(acquired);
    }

    private void releaseLock(String lockKey, String lockValue) {
        ValueOperations ops = this.stringRedisTemplate.opsForValue();
        String currentValue = (String)ops.get((Object)lockKey);
        if (lockValue.equals(currentValue)) {
            this.stringRedisTemplate.delete((Object)lockKey);
            XxlJobHelper.log((String)"Lock released successfully.", (Object[])new Object[0]);
            log.info("Lock released successfully.");
        } else {
            log.warn("Lock was already released or expired.");
            XxlJobHelper.log((String)"Lock was already released or expired.", (Object[])new Object[0]);
        }
    }
}

