/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.sse.listener;

import com.digiwin.athena.adt.agileReport.config.AgileDataHandlerProcessor;
import com.digiwin.athena.adt.agileReport.config.SchemaDataHandlerProcessor;
import com.digiwin.athena.adt.agileReport.service.AgileDataCalculateCostService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.sse.domain.EventData;
import com.digiwin.athena.adt.sse.domain.SseAniaEventEnum;
import com.digiwin.athena.adt.sse.dto.SSEBaseEvent;
import com.digiwin.athena.adt.sse.listener.SSEBaseListener;
import com.digiwin.athena.adt.sse.service.SSEOnEventService;
import com.digiwin.athena.adt.sse.utils.SseEmitterUtils;
import com.digiwin.athena.adt.sse.utils.SseEventUtils;
import com.digiwin.athena.adt.util.MessageUtil;
import com.digiwin.athena.appcore.util.SpringUtil;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public class SSEScrumListener
extends SSEBaseListener {
    private static final Logger log = LoggerFactory.getLogger(SSEScrumListener.class);
    private final SSEBaseEvent sseBaseEvent;
    private final SchemaDataHandlerProcessor schemaDataHandlerProcessor;
    private final AgileDataCalculateCostService agileDataCalculateCostService;
    private final AgileDataHandlerProcessor agileDataHandlerProcessor;
    private final AbsAgileDataProcess absAgileDataProcess;
    private final EchoService echoService;

    public SSEScrumListener(SSEBaseEvent sseBaseEvent, SchemaDataHandlerProcessor schemaDataHandlerProcessor, AgileDataCalculateCostService agileDataCalculateCostService, AgileDataHandlerProcessor agileDataHandlerProcessor, AbsAgileDataProcess absAgileDataProcess, EchoService echoService) {
        this.sseBaseEvent = sseBaseEvent;
        this.schemaDataHandlerProcessor = schemaDataHandlerProcessor;
        this.agileDataCalculateCostService = agileDataCalculateCostService;
        this.agileDataHandlerProcessor = agileDataHandlerProcessor;
        this.absAgileDataProcess = absAgileDataProcess;
        this.echoService = echoService;
    }

    public void onOpen(EventSource eventSource, Response response) {
        this.sseBaseEvent.setScrumEventSource(eventSource);
    }

    public void onEvent(EventSource eventSource, @Nullable String id, @Nullable String type, String data) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return;
        }
        String skillType = this.sseBaseEvent.getEvent().getSkillType();
        if (StringUtils.isEmpty((CharSequence)skillType)) {
            skillType = "0";
        }
        SSEOnEventService sseOnEventService = (SSEOnEventService)SpringUtil.getBean((String)(skillType + "_sseOnEvent"), SSEOnEventService.class);
        sseOnEventService.onEvent(this.sseBaseEvent, eventSource, type, data, this.schemaDataHandlerProcessor, this.agileDataCalculateCostService, this.agileDataHandlerProcessor, this.absAgileDataProcess);
    }

    public void onClosed(EventSource eventSource) {
        this.sseBaseEvent.setIsScrumOver(Boolean.valueOf(true));
        if (!SseEventUtils.noScrumTerminate((List)this.sseBaseEvent.getScrumEventDatas())) {
            SseEmitterUtils.sendChatErrorComplete((SseEmitter)this.sseBaseEvent.getAniaEmitter());
            SseEmitterUtils.sendAnswerDone((SseEmitter)this.sseBaseEvent.getAniaEmitter(), (boolean)false);
            this.sseBaseEvent.getAniaEmitter().complete();
        }
    }

    public void onFailure(EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
        String answer;
        log.info("\u8bed\u4e49\u76d1\u542c\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f:{}", (Object)t.getMessage());
        this.sseBaseEvent.setIsScrumOver(Boolean.valueOf(true));
        String errorMsg = MessageUtil.getMessageByLanguage((Object)"message.system.schema.error", (String)this.sseBaseEvent.getLang());
        if (Objects.isNull(response) || !response.isSuccessful()) {
            answer = errorMsg;
        } else {
            if (t instanceof IllegalStateException && t.getMessage().startsWith("ResponseBodyEmitter has already completed")) {
                return;
            }
            answer = errorMsg;
        }
        if (StringUtils.isNotBlank((CharSequence)answer)) {
            EventData eventData = new EventData(SseAniaEventEnum.MESSAGE_DELTA.getEvent());
            eventData.setData(new EventData.EventMessage(SseAniaEventEnum.SseEventDataTypeEnum.ANSWER.getType(), SseAniaEventEnum.EventDataMessageEnum.TEXT.getMessageType(), answer));
            SseEmitterUtils.sendChatErrorComplete((SseEmitter)this.sseBaseEvent.getAniaEmitter());
            SseEmitterUtils.sendAnswerDone((SseEmitter)this.sseBaseEvent.getAniaEmitter(), (boolean)false);
            this.sseBaseEvent.getAniaEmitter().complete();
        }
    }
}

