/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.sse.service.impl.onEvent;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.config.AgileDataHandlerProcessor;
import com.digiwin.athena.adt.agileReport.config.SchemaDataHandlerProcessor;
import com.digiwin.athena.adt.agileReport.constant.AgileDataEnum;
import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataCalculateCostService;
import com.digiwin.athena.adt.agileReport.service.impl.process.agileData.AbsAgileDataProcess;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.sse.domain.EventData;
import com.digiwin.athena.adt.sse.domain.SseAniaEventEnum;
import com.digiwin.athena.adt.sse.domain.SseScrumEventEnum;
import com.digiwin.athena.adt.sse.dto.SSEBaseEvent;
import com.digiwin.athena.adt.sse.service.SSEOnEventService;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.Objects;
import okhttp3.sse.EventSource;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Service(value="3_sseOnEvent")
public class SSEOnEventAIBoardQuestionServiceImpl
extends SSEOnEventService {
    private static final Logger log = LoggerFactory.getLogger(SSEOnEventAIBoardQuestionServiceImpl.class);

    public void onEvent(SSEBaseEvent sseBaseEvent, EventSource eventSource, String type, String data, SchemaDataHandlerProcessor schemaDataHandlerProcessor, AgileDataCalculateCostService agileDataCalculateCostService, AgileDataHandlerProcessor agileDataHandlerProcessor, AbsAgileDataProcess absAgileDataProcess) {
        SseEmitter sseEmitter = sseBaseEvent.getAniaEmitter();
        JSONObject res = JSONObject.parseObject((String)data);
        String message = res.getString("message");
        String status = res.getString("status");
        if (SseScrumEventEnum.SCRUMBI_RESULT.getEvent().equals(type)) {
            this.sseProcess(res, sseBaseEvent, schemaDataHandlerProcessor, agileDataCalculateCostService, agileDataHandlerProcessor, absAgileDataProcess);
        } else if (!SseScrumEventEnum.SCRUMBI_COMPLEATE.getEvent().equals(type)) {
            if (SseScrumEventEnum.SCRUMBI_DONE.getEvent().equals(type)) {
                eventSource.cancel();
            } else {
                EventData.EventMessage eventMessage = EventData.EventMessage.builderAnswerTextMessage((Object)message);
                this.sendEventDataMessage(SseAniaEventEnum.MESSAGE_DELTA.getEvent(), sseEmitter, eventMessage);
            }
        }
    }

    public void sseProcess(JSONObject res, SSEBaseEvent sseBaseEvent, SchemaDataHandlerProcessor schemaDataHandlerProcessor, AgileDataCalculateCostService agileDataCalculateCostService, AgileDataHandlerProcessor agileDataHandlerProcessor, AbsAgileDataProcess absAgileDataProcess) {
        AthenaMessageEvent event = sseBaseEvent.getEvent();
        event.setSseCallId(sseBaseEvent.getId());
        log.error("agiledata_ADT_{}_{}_{}_{}_{}_{}:\u83b7\u53d6\u7528\u6237\u63d0\u95ee\uff0c\u8bed\u4e49\u8bc6\u522b\uff0c\u8bed\u4e49\u51fa\u53c2\uff1a{},\u8017\u65f6\uff1a{}ms", new Object[]{event.getUser().getUserId(), event.getUser().getUserName(), event.getUser().getTenantId(), event.getUser().getTenantName(), event.getQuestion(), event.getPtxId(), JsonUtils.objectToString((Object)res), System.currentTimeMillis() - event.getGetQuerySchemaTook()});
        if (res == null || Objects.isNull(res.get((Object)"message"))) {
            return;
        }
        Pair result = schemaDataHandlerProcessor.getEnumServiceByType((Enum)SchemaDataEnum.queryTypeEnumByCode((String)sseBaseEvent.getSchemaEnum())).sseProcess(event, res);
        QuerySchemaResDTO schemaResDTO = (QuerySchemaResDTO)result.getRight();
        if (schemaResDTO == null || schemaResDTO.getData() == null) {
            return;
        }
        if (!((Boolean)result.getLeft()).booleanValue()) {
            return;
        }
        String router = String.valueOf(((QuerySchemaResDTO)result.getRight()).getRoute());
        String serviceName = absAgileDataProcess.getServiceNameByQuerySchema(router);
        agileDataHandlerProcessor.getEnumServiceByType((Enum)AgileDataEnum.queryTypeEnumByCode((String)serviceName)).process(event, schemaResDTO);
    }
}

