/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.sse.service.impl.process;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.agileReport.service.AgileDataMessageService;
import com.digiwin.athena.adt.domain.dto.autoData.AgileDataAutoDataDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.sse.domain.EventStreamClient;
import com.digiwin.athena.adt.sse.dto.SSEBaseEvent;
import com.digiwin.athena.adt.sse.listener.SSEScrumListener;
import com.digiwin.athena.adt.sse.service.SSEProcessService;
import com.digiwin.athena.adt.util.MessageUtil;
import java.util.Map;
import okhttp3.sse.EventSourceListener;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="2_sseProcess")
public class SSEProcessAutoDataReportServiceImpl
implements SSEProcessService {
    @Autowired
    private EchoService echoService;
    @Autowired
    private SemcService semcService;
    @Autowired
    private MessageUtil messageUtil;
    @Autowired
    private AgileDataMessageService agileDataMessageService;

    public void process(SSEScrumListener sseScrumListener, AthenaMessageEvent event, String url, Map<String, Object> req, SSEBaseEvent sseBaseEvent) {
        String action = event.getAction();
        if (StringUtils.isEmpty((CharSequence)action)) {
            return;
        }
        switch (action) {
            case "0": {
                this.agileDataMessageService.processAutoData(event, url, req, sseBaseEvent);
                break;
            }
            case "1": {
                AgileDataAutoDataDTO agileDataAutoDataDTO = this.buildAutoDataReport(event);
                if (agileDataAutoDataDTO == null) {
                    Map msgBody = event.getMsgBody();
                    msgBody.put("prompt", this.messageUtil.getMessageByLangNameWithFormat("message.adt.getReport.error", event.getLang(), new Object[0]));
                    this.semcService.sendMessageToGpt(event, req);
                    return;
                }
                this.echoService.updateAutoDataReport(event.getUser(), agileDataAutoDataDTO);
                EventStreamClient.executeSSE((AthenaMessageEvent)event, (String)url, (EventSourceListener)sseScrumListener, (JSONObject)new JSONObject(req), (SSEBaseEvent)sseBaseEvent);
                break;
            }
        }
    }

    private AgileDataAutoDataDTO buildAutoDataReport(AthenaMessageEvent event) {
        AgileDataAutoDataDTO autoDataDTO = new AgileDataAutoDataDTO();
        Map msgExt = event.getMsgExt();
        Long messageId = MapUtils.getLong((Map)msgExt, (Object)"autoDataMessageId");
        if (messageId == null) {
            return null;
        }
        autoDataDTO.setMessageId(messageId);
        autoDataDTO.setStatus("2");
        return autoDataDTO;
    }
}

