/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.sse.service.impl.process;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.domain.dto.echo.AgileDataFileDTO;
import com.digiwin.athena.adt.domain.echo.EchoService;
import com.digiwin.athena.adt.domain.semc.SemcService;
import com.digiwin.athena.adt.sse.domain.EventStreamClient;
import com.digiwin.athena.adt.sse.dto.SSEBaseEvent;
import com.digiwin.athena.adt.sse.listener.SSEScrumListener;
import com.digiwin.athena.adt.sse.service.SSEProcessService;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.sse.EventSourceListener;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="1_sseProcess")
public class SSEProcessPPTServiceImpl
implements SSEProcessService {
    @Autowired
    private EchoService echoService;
    @Autowired
    private SemcService semcService;

    public void process(SSEScrumListener sseScrumListener, AthenaMessageEvent event, String url, Map<String, Object> req, SSEBaseEvent sseBaseEvent) {
        String pptAction = event.getAction();
        if (StringUtils.isEmpty((CharSequence)pptAction)) {
            return;
        }
        switch (pptAction) {
            case "0": {
                EventStreamClient.executeSSE((AthenaMessageEvent)event, (String)url, (EventSourceListener)sseScrumListener, (JSONObject)new JSONObject(req), (SSEBaseEvent)sseBaseEvent);
                break;
            }
            case "1": {
                Long analyzeMessageId = MapUtils.getLong((Map)event.getMsgExt(), (Object)"analyzeMessageId");
                if (analyzeMessageId != null) {
                    AgileDataFileDTO.AgileDataFileGenerateDTO pptInfo;
                    Long generateSerialNo = SnowflakeIdWorker.getInstance().newId();
                    HashMap params = Maps.newHashMap();
                    params.put("messageId", analyzeMessageId);
                    AgileDataFileDTO agileDataFile = this.echoService.getAgileDataFile((Map)params, event.getUser().getToken(), event.getUser().getTenantId());
                    if (agileDataFile != null && (pptInfo = (AgileDataFileDTO.AgileDataFileGenerateDTO)agileDataFile.getPptInfo().stream().findFirst().orElse(null)) != null) {
                        generateSerialNo = pptInfo.getPptId();
                    }
                    AgileDataFileDTO agileDataFileDTO = new AgileDataFileDTO();
                    agileDataFileDTO.setMessageId(analyzeMessageId);
                    ArrayList pptInfo2 = Lists.newArrayList();
                    agileDataFileDTO.setPptInfo((List)pptInfo2);
                    AgileDataFileDTO.AgileDataFileGenerateDTO pptGenerateDTO = new AgileDataFileDTO.AgileDataFileGenerateDTO();
                    pptGenerateDTO.setPptId(generateSerialNo);
                    pptInfo2.add(pptGenerateDTO);
                    this.echoService.updateAgileDataFile(agileDataFileDTO, event.getUser().getToken(), event.getUser().getTenantId());
                    HashMap msgBody = Maps.newHashMap();
                    msgBody.put("pptId", generateSerialNo);
                    this.semcService.sendMessageToGpt(event, (Map)msgBody);
                    break;
                }
                this.semcService.sendMessageToGpt(event, (Map)Maps.newHashMap());
                break;
            }
        }
    }
}

