/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.util.agileData;

import com.digiwin.athena.adt.agileReport.eventbus.AthenaMessageEvent;
import com.digiwin.athena.adt.domain.dto.echo.AgileDataFileDTO;
import com.digiwin.athena.adt.domain.dto.schema.QuerySchemaResDTO;
import com.digiwin.athena.adt.util.LogUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class AgileDataAnalysisUtils {
    public static void transAnalysisParams(QuerySchemaResDTO responseData, Object adeResponse, AthenaMessageEvent event) {
        if (StringUtils.equals((CharSequence)"metric", (CharSequence)event.getMethod())) {
            HashMap analysisMap = Maps.newHashMap();
            analysisMap.put("aiParams", responseData.getData().getMetric().getDebug());
            analysisMap.put("analysisParams", adeResponse);
            LogUtils.buildAgileLog((String)"adt", (String)"getAnalysis", (String)"1", (String)JsonUtils.objectToString((Object)analysisMap), (String)"", (String)"");
        }
    }

    public static void getTransShowInfo(Map<String, Object> adeResult, Map<String, Object> sendMap, Integer sceneShowType) {
        Map showDefine;
        String transTips;
        Map context = MapUtils.getMap(adeResult, (Object)"context");
        if (MapUtils.isEmpty((Map)context)) {
            return;
        }
        Map bizParams = MapUtils.getMap((Map)context, (Object)"bizParams");
        if (MapUtils.isEmpty((Map)bizParams)) {
            return;
        }
        List transList = (List)bizParams.get("transIds");
        if (CollectionUtils.isNotEmpty((Collection)transList)) {
            sendMap.put("transIds", transList);
        }
        if (StringUtils.isNotEmpty((CharSequence)(transTips = MapUtils.getString((Map)bizParams, (Object)"transTips")))) {
            sendMap.put("dataTipMessage", transTips);
        }
        if (MapUtils.isNotEmpty((Map)(showDefine = (Map)MapUtils.getObject((Map)bizParams, (Object)"showDefine")))) {
            List typeList;
            List showTypeList = (List)MapUtils.getObject((Map)showDefine, (Object)"showType");
            if (CollectionUtils.isNotEmpty((Collection)showTypeList)) {
                Map showType = (Map)showTypeList.get(0);
                List typeList2 = (List)showType.get("type");
                if (CollectionUtils.isNotEmpty((Collection)showTypeList)) {
                    Map typeMap = (Map)typeList2.get(0);
                    sendMap.put("defaultShowType", MapUtils.getIntValue((Map)typeMap, (Object)"value"));
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(typeList = (List)MapUtils.getObject((Map)showDefine, (Object)"type")))) {
                Map typeMap = (Map)typeList.get(0);
                Integer showValue = MapUtils.getIntValue((Map)typeMap, (Object)"value");
                if (showValue == 1 && sceneShowType != null) {
                    showValue = sceneShowType;
                }
                sendMap.put("defaultShowType", showValue);
            }
        }
    }

    public static Integer getSceneDefaultShowType(Map<String, Object> adeResult) {
        List typeList;
        Integer sceneDefaultShowType = null;
        Map context = MapUtils.getMap(adeResult, (Object)"context");
        if (MapUtils.isEmpty((Map)context)) {
            return sceneDefaultShowType;
        }
        Map bizParams = MapUtils.getMap((Map)context, (Object)"bizParams");
        if (MapUtils.isEmpty((Map)bizParams)) {
            return sceneDefaultShowType;
        }
        Map showDefine = (Map)MapUtils.getObject((Map)bizParams, (Object)"showDefine");
        if (MapUtils.isNotEmpty((Map)showDefine) && CollectionUtils.isNotEmpty((Collection)(typeList = (List)MapUtils.getObject((Map)showDefine, (Object)"type")))) {
            Map typeMap = (Map)typeList.get(0);
            sceneDefaultShowType = MapUtils.getIntValue((Map)typeMap, (Object)"value");
        }
        return sceneDefaultShowType;
    }

    public static AgileDataFileDTO buildAgileDataFile(Long messageId, String appCode, QuerySchemaResDTO querySchemaResDTO) {
        AgileDataFileDTO agileDataFile = new AgileDataFileDTO();
        agileDataFile.setMessageId(messageId);
        agileDataFile.setAppCode(appCode);
        agileDataFile.setPptInfo((List)Lists.newArrayList());
        agileDataFile.setMessageStatus(Integer.valueOf(0));
        agileDataFile.setMessageTopic(querySchemaResDTO.getQuestionPlanningRes().getPlanningTopic());
        if (CollectionUtils.isNotEmpty((Collection)querySchemaResDTO.getQuestionPlanningRes().getPlanningQuestions())) {
            ArrayList questionInfo = Lists.newArrayList();
            querySchemaResDTO.getQuestionPlanningRes().getPlanningQuestions().stream().forEach(planningQuestion -> {
                AgileDataFileDTO.AgileDataFileQuestionDTO questionDTO = new AgileDataFileDTO.AgileDataFileQuestionDTO();
                questionDTO.setQuestionId(Long.valueOf(SnowflakeIdWorker.getInstance().newId()));
                questionDTO.setQuestion(planningQuestion.getQuestion());
                questionDTO.setDatasetIds(planningQuestion.getDatasetIds());
                questionDTO.setTitle(planningQuestion.getTitle());
                if (planningQuestion.getStatus() != null) {
                    questionDTO.setLock(Boolean.valueOf(0 == planningQuestion.getStatus()));
                } else {
                    questionDTO.setLock(Boolean.valueOf(false));
                }
                questionInfo.add(questionDTO);
            });
            agileDataFile.setQuestionInfo((List)questionInfo);
        }
        return agileDataFile;
    }
}

