/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.adt.util.message;

import com.digiwin.athena.adt.domain.dto.aim.AimBuildReqDTO;
import com.digiwin.athena.adt.domain.dto.aim.AimNewActionDTO;
import com.digiwin.athena.adt.domain.dto.aim.AimNewAdaParamsDTO;
import com.digiwin.athena.adt.domain.dto.aim.AimNewContentDTO;
import com.digiwin.athena.adt.domain.dto.aim.AimNewMessageDTO;
import com.digiwin.athena.adt.domain.po.SnapData;
import com.digiwin.athena.adt.util.Base64Utils;
import com.digiwin.athena.adt.util.message.MessageDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.digiwin.athena.atmc.http.domain.message.MessageBatchUserDTO;
import com.digiwin.athena.atmc.http.domain.message.MessageDO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class AgileDataMessageUtils {
    private static final Logger log = LoggerFactory.getLogger(AgileDataMessageUtils.class);
    private static final String MESSAGE_AIM_MSG_1 = "message.aim.msg1";
    private static final String MESSAGE_AIM_MSG_2 = "message.aim.msg2";
    private static final String MESSAGE_AIM_TITLE = "message.aim.title";
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy/MM/dd HH:mm:ss";
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    private static final String AIM_SOURCE_AGILE_DATA = "AGILE_DATA";
    private static final String AIM_TYPE_TEXT = "text";
    private static final String AIM_CATEGORY_NEW = "NEW";
    private static final Integer AIM_STATE = 0;
    private static final String AIM_ACTION_TYPE_DATA_SUBSCRIPTION = "AGILE_DATA_SUBSCRIPTION";
    private static final String AIM_SKILL_TYPE = "1";

    public static MessageDO buildDetectionMessage(SnapData snapData, AuthoredUser authoredUser) {
        MessageDTO messageDTO = MessageDTO.builderDetectionMessage((SnapData)snapData, (AuthoredUser)authoredUser);
        MessageDO messageDO = AgileDataMessageUtils.sendMessage((MessageDTO)messageDTO);
        JSONObject content = new JSONObject();
        content.put((Object)"id", (Object)messageDTO.getId());
        content.put((Object)"name", (Object)messageDTO.getName());
        content.put((Object)"alertTime", messageDTO.getAlertTime() != null ? TimeUtils.format((LocalDateTime)messageDTO.getAlertTime(), (String)"MM/dd") : null);
        content.put((Object)"title", (Object)messageDTO.getTitle());
        content.put((Object)"status", (Object)0);
        content.put((Object)"msg", (Object)messageDTO.getMessage());
        messageDO.setContent((Object)content);
        messageDO.setNoticeMobileApp(Boolean.valueOf(true));
        return messageDO;
    }

    public static MessageDO sendMessage(MessageDTO messageDTO) {
        MessageDO messageDO = new MessageDO();
        messageDO.setUserId(messageDTO.getAuthoredUser().getUserId());
        messageDO.setTenantId(messageDTO.getAuthoredUser().getTenantId());
        messageDO.setSource("athena");
        messageDO.setType(messageDTO.getMessageType());
        messageDO.setSubType(messageDTO.getMessageType());
        messageDO.setSubTypeCategory("ATHENA_REMIND");
        messageDO.setCategory(messageDO.getCategory());
        messageDO.setImportance(messageDTO.getImportance());
        messageDO.setState(messageDTO.getState());
        messageDO.setTitle("Athena");
        messageDO.setLangName(messageDTO.getLangName());
        return messageDO;
    }

    public static List<MessageBatchUserDTO> buildAgileSubscribeMessage(AimBuildReqDTO aimBuildReqDTO) {
        ArrayList messageBatchUserDTOS = Lists.newArrayList();
        MessageDO messageDO = AgileDataMessageUtils.builderAgileSubscribe((AimBuildReqDTO)aimBuildReqDTO);
        MessageBatchUserDTO messageBatchUserDTO = new MessageBatchUserDTO();
        ArrayList<String> userIdList = new ArrayList<String>();
        userIdList.add(aimBuildReqDTO.getAuthoredUser().getUserId());
        messageBatchUserDTO.setMessage(messageDO);
        messageBatchUserDTO.setUserIdList(userIdList);
        messageBatchUserDTO.setTenantId(aimBuildReqDTO.getAuthoredUser().getTenantId());
        messageBatchUserDTOS.add(messageBatchUserDTO);
        return messageBatchUserDTOS;
    }

    public static MessageDO builderAgileSubscribe(AimBuildReqDTO aimBuildReqDTO) {
        String msg1 = aimBuildReqDTO.getMessageUtil().getMessageByLangName("message.aim.msg1", aimBuildReqDTO.getUserLang());
        String msg2 = aimBuildReqDTO.getMessageUtil().getMessageByLangName("message.aim.msg2", aimBuildReqDTO.getUserLang());
        String title = aimBuildReqDTO.getMessageUtil().getMessageByLangName("message.aim.title", aimBuildReqDTO.getUserLang());
        LocalDateTime nowDate = LocalDateTime.now();
        DateTimeFormatter sdf = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
        String nowFormatDate = nowDate.format(sdf);
        AimNewMessageDTO aimNewMessageDO = new AimNewMessageDTO();
        aimNewMessageDO.setLocale(aimBuildReqDTO.getUserLang());
        aimNewMessageDO.setNoticeMobileApp(Boolean.valueOf(true));
        aimNewMessageDO.setNoticeOnlineUser(Boolean.valueOf(true));
        aimNewMessageDO.setLocale(aimBuildReqDTO.getUserLang());
        AimNewActionDTO aimNewActionDTO = AgileDataMessageUtils.getAimNewActionDTO((AimBuildReqDTO)aimBuildReqDTO, (String)nowFormatDate);
        aimNewMessageDO.setAction(aimNewActionDTO);
        aimNewMessageDO.setSource("AGILE_DATA");
        aimNewMessageDO.setType("text");
        aimNewMessageDO.setCategory("NEW");
        aimNewMessageDO.setState(AIM_STATE);
        aimNewMessageDO.setTitle(title);
        AimNewContentDTO aimNewContentDTO = new AimNewContentDTO();
        String pushMessage = StringUtils.isNotEmpty((CharSequence)aimBuildReqDTO.getChartTitle()) ? aimBuildReqDTO.getChartTitle() : aimBuildReqDTO.getQuestion();
        aimNewContentDTO.setMsg(msg1 + "\u3010" + pushMessage + "\u3011" + msg2);
        aimNewContentDTO.setTitle(title);
        aimNewMessageDO.setContent(aimNewContentDTO);
        aimNewMessageDO.setSendDate(nowDate);
        aimNewMessageDO.setStartTime(nowDate);
        aimNewMessageDO.setEndTime(nowDate);
        aimNewMessageDO.setCreateDate(nowDate);
        log.info("builderAgileSubscribe : {}", (Object)JsonUtils.objectToString((Object)aimNewMessageDO));
        return aimNewMessageDO;
    }

    private static AimNewActionDTO getAimNewActionDTO(AimBuildReqDTO aimBuildReqDTO, String nowFormatDate) {
        AimNewActionDTO aimNewActionDTO = new AimNewActionDTO();
        aimNewActionDTO.setTarget("AGILE_DATA");
        aimNewActionDTO.setAssistantCode(aimBuildReqDTO.getAsaCode());
        aimNewActionDTO.setSkillType("1");
        aimNewActionDTO.setType("AGILE_DATA_SUBSCRIPTION");
        AimNewAdaParamsDTO adaParams = new AimNewAdaParamsDTO();
        adaParams.setQuestion(aimBuildReqDTO.getQuestion());
        adaParams.setSnapshotId(aimBuildReqDTO.getSnapData().getSnapshotId());
        adaParams.setSendDate(nowFormatDate);
        adaParams.setMethod(aimBuildReqDTO.getMethod());
        adaParams.setUndeletable(Boolean.valueOf(aimBuildReqDTO.isUndeletable()));
        adaParams.setDataTipMessage(aimBuildReqDTO.getDataTipMessage());
        adaParams.setAssistantCode(aimBuildReqDTO.getAsaCode());
        adaParams.setRuleId(aimBuildReqDTO.getRuleId());
        adaParams.setStepFilterAnalysis(aimBuildReqDTO.getStepFilterAnalysis());
        adaParams.setStepAnalysis(aimBuildReqDTO.getStepAnalysis());
        adaParams.setChartTitle(aimBuildReqDTO.getChartTitle());
        List metricList = aimBuildReqDTO.getMetricList();
        ArrayList<String> metricIdList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)metricList)) {
            for (Map map : metricList) {
                Iterator<Object> metricIdObj;
                if (!map.containsKey("metricId") || !((metricIdObj = map.get("metricId")) instanceof String)) continue;
                metricIdList.add((String)((Object)metricIdObj));
            }
        }
        adaParams.setMetricIdList(metricIdList);
        List datasetList = aimBuildReqDTO.getDatasetList();
        ArrayList<String> datasetIdList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)datasetList)) {
            for (Map map : datasetList) {
                Object datasetIdObj;
                if (!map.containsKey("datasetId") || !((datasetIdObj = map.get("datasetId")) instanceof String)) continue;
                datasetIdList.add((String)datasetIdObj);
            }
        }
        adaParams.setDatasetIdList(datasetIdList);
        ArrayList urlParams = Lists.newArrayList();
        AimNewActionDTO.AimUrlParams redirectUrl = new AimNewActionDTO.AimUrlParams();
        redirectUrl.setKey("redirectUrl");
        redirectUrl.setValue("nanaSubscriptionDetail");
        AimNewActionDTO.AimUrlParams userId = new AimNewActionDTO.AimUrlParams();
        userId.setKey("userId");
        userId.setValue(aimBuildReqDTO.getAuthoredUser().getUserId());
        AimNewActionDTO.AimUrlParams tenantId = new AimNewActionDTO.AimUrlParams();
        tenantId.setKey("tenantId");
        tenantId.setValue(aimBuildReqDTO.getAuthoredUser().getTenantId());
        HashMap nanaMap = Maps.newHashMap();
        nanaMap.put("assistantCode", aimBuildReqDTO.getAsaCode());
        AimNewActionDTO.AimUrlParams nanaParams = new AimNewActionDTO.AimUrlParams();
        nanaParams.setKey("nanaParams");
        nanaParams.setValue(Base64Utils.encode((String)JsonUtils.objectToString((Object)nanaMap)));
        AimNewActionDTO.AimUrlParams snapshotId = new AimNewActionDTO.AimUrlParams();
        snapshotId.setKey("snapshotId");
        snapshotId.setValue(aimBuildReqDTO.getSnapData().getSnapshotId());
        AimNewActionDTO.AimUrlParams sendDate = new AimNewActionDTO.AimUrlParams();
        sendDate.setKey("sendDate");
        sendDate.setValue(nowFormatDate);
        AimNewActionDTO.AimUrlParams undeletable = new AimNewActionDTO.AimUrlParams();
        undeletable.setKey("undeletable");
        undeletable.setValue(Boolean.toString(aimBuildReqDTO.isUndeletable()));
        urlParams.add(redirectUrl);
        urlParams.add(tenantId);
        urlParams.add(userId);
        urlParams.add(nanaParams);
        urlParams.add(snapshotId);
        urlParams.add(sendDate);
        urlParams.add(undeletable);
        aimNewActionDTO.setUrlParams((List)urlParams);
        aimNewActionDTO.setAdaParams(adaParams);
        return aimNewActionDTO;
    }

    private AgileDataMessageUtils() {
    }
}

