package com.digiwin.athena.adt.agileReport.config;

import com.digiwin.athena.adt.agileReport.constant.SchemaDataEnum;
import com.digiwin.athena.adt.agileReport.interfaces.SchemaDataType;
import com.digiwin.athena.adt.agileReport.service.SchemaDataProcessService;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @Author: SunHong
 * @Date: 2024/7/1 13:18
 * @Description:
 */

@Component
public class HandlerSchemaProcessor implements ApplicationContextAware {

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        //获取所有策略注解的Bean
        Map<String, Object> map = applicationContext.getBeansWithAnnotation(SchemaDataType.class);
        map.forEach((k,v)->{
            Class<SchemaDataProcessService> strategyClass = (Class<SchemaDataProcessService>) v.getClass();
            SchemaDataEnum type = strategyClass.getAnnotation(SchemaDataType.class).value();
            //将class加入map中,type作为key
            SchemaDataHandlerProcessor.SERVICE_HAND_MAP.put(type,strategyClass);
        });
    }
}
