package com.digiwin.athena.adt.agileReport.constant;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * @Author: SunHong
 * @Date: 2024/7/1 13:19
 * @Description:
 */
@Getter
public enum SchemaDataEnum {

    DEBUG("debug", "debug","2"),

    PARAM("param", "param模式","4"),

    METRIC("metric", "多指标","6"),

    METRIC_APP("metric_app", "多应用","5"),

    DESIGNER("designer", "设计器","0"),

    MOCK("mock", "mock穿透","8"),

    SPECIAL("special", "生成式-年报","9"),

    SPECIAL_LITE("special_lite", "生成式-lite","10"),

    METRIC_DEBUG("metric_debug", "指标DEBUG模式","11"),

    DATASET("dataset", "数据集","12");

    /**
     * 类型
     */
    private final String code;

    /**
     * desc
     */
    private final String name;


    private final String value;

    SchemaDataEnum (String code, String name,String value) {
        this.code = code;
        this.name = name;
        this.value = value;
    }

    public static SchemaDataEnum queryTypeEnumByCode(String code){
        for (SchemaDataEnum typeEnum:values()){
            if (StringUtils.isNotEmpty(code) && typeEnum.code.equals(code)){
                return typeEnum;
            }
        }
        return null;
    }
}
