package com.digiwin.athena.adt.agileReport.constant.event;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

/**
 * 事件队列
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class EventMqConstants {
    /**
     * 事件交换机名称
     */
    public static final String EVENT_MQ_EXCHANGE_NAME = "athena.event.message";

    /**
     * 事件消息队列名称
     */
    public static final String EVENT_MQ_QUEUE_NAME = "athena.event.message.adt";

    /**
     * 订阅队列
     */
    public static final String EVENT_MQ_QUEUE_SUBSCRIBE = "athena.event.message.adt.subscribe";

    /**
     * 事件routingKey名称
     */
    public static final String EVENT_MQ_ROUTING_NAME = EVENT_MQ_QUEUE_NAME;

    public static final String EVENT_MQ_ROUTING_SUBSCRIBE = EVENT_MQ_QUEUE_SUBSCRIBE;

    /**
     * 项目卡/任务卡摘要、搜索项、历史资讯队列
     */
    public static final String EVENT_MQ_BUSINESS_MESSAGE_QUEUE = "athena.event.business.message";
    /**
     * 项目卡/任务卡摘要、搜索项、历史资讯路由
     */
    public static final String EVENT_MQ_BUSINESS_MESSAGE_ROUTING = EVENT_MQ_BUSINESS_MESSAGE_QUEUE;


    /**
     * 项目卡/任务卡bk队列
     */
    public static final String EVENT_MQ_BUSINESS_KEY_QUEUE = "athena.event.business.key";
    /**
     * 项目卡/任务卡bk路由
     */
    public static final String EVENT_MQ_BUSINESS_KEY_ROUTING = EVENT_MQ_BUSINESS_KEY_QUEUE;


    /**
     * 群聊队列
     */
    public static final String EVENT_MQ_GROUP_TEAM_QUEUE = "athena.event.group.team";
    /**
     * 群聊路由
     */
    public static final String EVENT_MQ_GROUP_TEAM_ROUTING = EVENT_MQ_GROUP_TEAM_QUEUE;


    /**
     * 发送消息通知队列
     */
    public static final String EVENT_MQ_TASK_OPERATE_SEND_MSG_QUEUE = "athena.event.task.operate.send.msg";

    /**
     * 发送消息通知路由
     */
    public static final String EVENT_MQ_TASK_OPREATE_SEND_MSG_ROUTING = EVENT_MQ_TASK_OPERATE_SEND_MSG_QUEUE;
}
