package com.digiwin.athena.adt.agileReport.controller.ania;

import com.digiwin.athena.adt.agileReport.service.AniaAssistantService;
import com.digiwin.athena.adt.domain.dto.ania.AniaAssistantReqDTO;
import com.digiwin.athena.adt.domain.dto.ania.AniaVersionReqDTO;
import com.digiwin.athena.adt.domain.dto.mongo.AgileDataCustomConfig;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @Author: SunHong
 * @Date: 2025/5/12 18:17
 * @Description: 敏数2.0 娜娜的初始化助理信息详情
 * 当前controller的 RequestMapping 地址和
 * AgileReportDataProcessController 一直 新增接口需注意
 */
@RestController
@RequestMapping(value = "/api/ai/agileData")
public class AniaAssistantController {

    @Autowired
    private AniaAssistantService aniaAssistantService;
    /**
     * 根据用户信息助理Id查询助理详情
     * 娜娜的初始化助理信息详情
     * @param user 用户信息
     * @return 助理详细数据
     */
    @PostMapping("/assistant/getPublishedInfo")
    public ResponseEntity<?> getPublishedInfo(@RequestBody AniaAssistantReqDTO req,
                                              @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false)
                                              AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(aniaAssistantService.getPublishedInfo(req,user));
    }

    @PostMapping("/mongo/saveCustomConfig")
    public ResponseEntity<?> saveCustomConfig(@RequestBody @Validated AgileDataCustomConfig agileDataCustomConfig,
                                         @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        aniaAssistantService.saveCustomConfig(agileDataCustomConfig,user);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping("/mongo/get/customConfig")
    public ResponseEntity<?> getMongoCustomConfig(@RequestBody @Validated AgileDataCustomConfig agileDataCustomConfig,
                                                            @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(aniaAssistantService.getMongoCustomConfig(agileDataCustomConfig,user));
    }

    @PostMapping("/mongo/deleteMongoCustomConfig")
    public ResponseEntity<?> deleteMongoCustomConfig(@RequestBody @Validated AgileDataCustomConfig agileDataCustomConfig,
                                                  @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        aniaAssistantService.deleteMongoCustomConfig(agileDataCustomConfig,user);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping("/assistant/getVersion")
    public ResponseEntity<?> getVersion(@RequestBody AniaVersionReqDTO req,
                                              @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false)
                                              AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(aniaAssistantService.getVersion(req,user));
    }

    @PostMapping("/assistant/getInspirationPhrases")
    public ResponseEntity<?> getInspirationPhrases(@RequestBody AniaAssistantReqDTO req,
                                              @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false)
                                              AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(aniaAssistantService.getInspirationPhrases(req,user));
    }

}
