package com.digiwin.athena.adt.agileReport.controller.log;

import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataAbnormalDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataFeedBackDTO;
import com.digiwin.athena.adt.agileReport.service.AgileReportAbnormalService;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 *  无法识别问答日志上报
 */
@RestController
@RequestMapping(value = "/api/ai/agileDataAbnormal")
public class AgileReportAbnormalController {

    @Autowired
    private AgileReportAbnormalService agileReportAbnormalService;


    /**
     * 日志上报
     * @param request
     * @param user
     * @param agileDataFeedBackDTO
     * @return
     */
    @PostMapping("/saveAbnormal")
    public ResponseEntity<?> saveAbnormal(HttpServletRequest request, @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user,
                                          @RequestBody AgileDataAbnormalDTO agileDataFeedBackDTO) {
        String clientAgent = request.getHeader("client-agent");
        return ResponseEntityWrapper.wrapperOk(agileReportAbnormalService.saveAbnormal(user,agileDataFeedBackDTO,clientAgent));
    }

}
