package com.digiwin.athena.adt.agileReport.controller.report;

import com.digiwin.athena.adt.agileReport.service.AgileDataConfigService;
import com.digiwin.athena.adt.domain.po.AgileDataConfig;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @Author: SunHong
 * @Date: 2024/6/3 15:37
 * @Description:
 */
@RestController
@RequestMapping(value = "/api/ai/agile")
public class AgileDataConfigController {

    @Autowired
    private AgileDataConfigService agileDataConfigService;

    @PostMapping("/config/insert")
    public ResponseEntity<?> insert(@RequestBody AgileDataConfig agileDataConfig,
                                             @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(agileDataConfigService.insert(agileDataConfig,user));
    }

    /**
     * 获取报表明细
     */
    @PostMapping("/config/update")
    public ResponseEntity<?> update(@RequestBody AgileDataConfig agileDataConfig,
                                                 @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(agileDataConfigService.update(agileDataConfig,user));
    }


    /**
     * 获取意图数据
     */
    @PostMapping("/config/delete")
    public ResponseEntity<?> delete(@RequestBody AgileDataConfig agileDataConfig,
                                                @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        //获取SD意图数据
        return ResponseEntityWrapper.wrapperOk(agileDataConfigService.delete(agileDataConfig,user));
    }

    /**
     * 获取配置字典value
     */
    @GetMapping("/config/getUserValue")
    public ResponseEntity<?> getUserValue(@RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        //获取SD意图数据
        return ResponseEntityWrapper.wrapperOk(agileDataConfigService.getUserValue(user));
    }

}
