package com.digiwin.athena.adt.agileReport.controller.report;

import com.digiwin.athena.adt.agileReport.controller.dto.AgileTransDataDTO;
import com.digiwin.athena.adt.agileReport.service.SnapShotDataService;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Objects;

@RestController
@RequestMapping(value = "/api/ai/agileData/trans")
public class AgileDataTransPresentController {

    @Autowired
    private SnapShotDataService snapShotDataService;

    /**
     * 获取快照数据
     * @param request
     * @param agileTransDataDTO
     * @return
     */
    @PostMapping("/agileData")
    public ResponseEntity<?> transAgileData(HttpServletRequest request,@RequestBody AgileTransDataDTO agileTransDataDTO,
                                            @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        Objects.requireNonNull(agileTransDataDTO, "传入的转换数据为空！");
        String locale = request.getHeader("locale");
        return ResponseEntityWrapper.wrapperOk(snapShotDataService.transAgileData(agileTransDataDTO, user, locale));
    }

    /**
     * 获取快照数据
     * @param request
     * @param agileTransDataDTO
     * @return
     */
    @PostMapping("/getTransList")
    public ResponseEntity<?> getTransList(HttpServletRequest request,@RequestBody AgileTransDataDTO agileTransDataDTO,
                                            @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        Objects.requireNonNull(agileTransDataDTO, "传入的转换快照为空！");
        String locale = request.getHeader("locale");
        return ResponseEntityWrapper.wrapperOk(snapShotDataService.getTransList(agileTransDataDTO, user, locale));
    }

}
