package com.digiwin.athena.adt.agileReport.controller.report;

import com.digiwin.athena.adt.agileReport.controller.dto.AgileDataMoreActionDTO;
import com.digiwin.athena.adt.agileReport.controller.dto.AgileReportDetailParamsDTO;
import com.digiwin.athena.adt.agileReport.service.SnapShotDataService;
import com.digiwin.athena.adt.domain.dto.agileReport.PageReqDTO;
import com.digiwin.athena.adt.domain.dto.SDScencDTO;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;


@RestController
@RequestMapping(value = "/api/ai/agile")
public class AgileReportDataController {

    @Autowired
    private SnapShotDataService snapShotDataService;


    /**
     * 获取报表明细
     */
    @PostMapping("/report/getDetail")
    public ResponseEntity<?> getReportDetail(@RequestBody AgileReportDetailParamsDTO agileReportDetailParamsDTO,
                                             @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(snapShotDataService.getSnapShotDetail(agileReportDetailParamsDTO,user));
    }

    /**
     * 获取报表明细
     */
    @PostMapping("/report/page/getDetail")
    public ResponseEntity<?> getReportPageDetail(@RequestBody AgileReportDetailParamsDTO agileReportDetailParamsDTO,
                                             @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(snapShotDataService.getSnapPageShotDetail(agileReportDetailParamsDTO,user));
    }


    /**
     * 获取意图数据
     */
    @PostMapping("/report/getIntentionData")
    public ResponseEntity<?> getIntentionReport(@RequestBody SDScencDTO sdScencDTO,
                                          @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        //获取SD意图数据
        return ResponseEntityWrapper.wrapperOk(snapShotDataService.getScencDetail(sdScencDTO,user));
    }

    /**
     * 查询快照列表
     */
    @PostMapping("/report/getData/list")
    public ResponseEntity<?> getSnapShotDataList(@RequestBody PageReqDTO pageReqDTO,
                                                @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {

        return ResponseEntityWrapper.wrapperOk(snapShotDataService.getSnapShotDataList(user.getTenantId(), user.getUserId(),pageReqDTO));
    }

    /**
     * 查询快照列表
     */
    @GetMapping("/report/getSnapData/{snapshotId}")
    public ResponseEntity<?> getSnapShotData(@PathVariable("snapshotId") String snapshotId,
                                             @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {

        return ResponseEntityWrapper.wrapperOk(snapShotDataService.getSnapDataInfoBySnapshotId(user.getTenantId(), user.getUserId(), snapshotId));
    }

    /**
     * 实时获取大屏数据
     * @param agileDataMoreActionDTO
     * @param user
     * @return
     */
    @PostMapping("/report/getSyncScreenSnapData")
    public ResponseEntity<?> getSyncScreenSnapData(HttpServletRequest request,@RequestBody AgileDataMoreActionDTO agileDataMoreActionDTO,
                                                   @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        String locale = request.getHeader("locale");
        return ResponseEntityWrapper.wrapperOk(snapShotDataService.getScreenSnapSyncData(user, agileDataMoreActionDTO,locale));
    }

    /**
     * 查询大屏快照
     * @param sceneCode
     * @param user
     * @return
     */
    @GetMapping("/report/getScreenSnapData")
    public ResponseEntity<?> getScreenSnapShotData(@RequestParam(value = "sceneCode",required = false) String sceneCode,
                                             @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {

        return ResponseEntityWrapper.wrapperOk(snapShotDataService.getScreenSnapData(user.getTenantId(), user.getUserId(), sceneCode));
    }


    /**
     * 通过snapshotId和userId查询快照信息
     */
    @GetMapping("/report/getData/{snapshotId}")
    public ResponseEntity<?> getReportInfoBysnapshotId(@PathVariable("snapshotId") String snapshotId,
                                               @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(snapShotDataService.getSnapShotData(snapshotId,user.getTenantId(),user.getUserId()));
    }

    /**
     * 更新读取次数
     */
    @GetMapping("/report/updateReadCount/{snapshotId}")
    public ResponseEntity<?> updateReadCount(@PathVariable("snapshotId") String snapshotId,
                                             @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){
        snapShotDataService.updateReadCount(snapshotId, user.getTenantId(), user.getUserId());
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 删除数据库数据库中snapshot数据
     */
    @PostMapping("/report/deleteSnap")
    public ResponseEntity<?> deleteSnap(@RequestBody Map<String, Object> map,
                                        @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){
        String snapshotId = MapUtils.getString(map,"snapshotId","");
        snapShotDataService.deleteSnap(snapshotId, user.getTenantId(), user.getUserId());
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 更新快照当前状态
     */
    @PostMapping("/report/updateSnapsStatue")
    public ResponseEntity<?> updateSnapsStatue(@RequestBody Map<String, Object> map,
                                        @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){
        String snapshotId = MapUtils.getString(map,"snapshotId","");
        return ResponseEntityWrapper.wrapperOk(snapShotDataService.updateSnapsStatue(snapshotId, user.getTenantId(), user.getUserId()));
    }

    /**
     * 通过snapshotId和userId查询快照信息
     */
    @GetMapping("/report/getAamData/{snapshotId}")
    public ResponseEntity<?> getAamDataBySnapshotId(@PathVariable("snapshotId") String snapshotId,
                                                       @RequestAttribute(value = GlobalConstant.AUTH_USER,
                                                               required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(snapShotDataService.
                getAamDataBySnapshotId(snapshotId,user.getTenantId(),user.getUserId()));
    }

    /**
     * 通过快照ID获取提供第三方敏数信息
     * @param snapshotId
     * @param user
     * @return
     */
    @GetMapping("/getThirdPartyAgileData/{snapshotId}")
    public ResponseEntity<?> getThirdPartyAgileData(@PathVariable("snapshotId") String snapshotId,
                                                       @RequestAttribute(value = GlobalConstant.AUTH_USER,
                                                               required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(snapShotDataService.getThirdPartyAgileData(snapshotId,user));
    }

    /**
     * 通过snapshotId和userId查询快照信息
     */
    @GetMapping("/report/getSolutionStep/{snapshotId}")
    public ResponseEntity<?> getSolutionStepBySnapshotId(@PathVariable("snapshotId") String snapshotId,
                                                       @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(snapShotDataService.getSolutionStepBySnapshotId(snapshotId,user.getTenantId(),user.getUserId()));
    }

}
