package com.digiwin.athena.adt.agileReport.controller.report;


import com.digiwin.athena.adt.agileReport.controller.dto.*;
import com.digiwin.athena.adt.agileReport.service.SnapShotCommonService;
import com.digiwin.athena.adt.agileReport.service.impl.process.schema.SchemaDataProcessSpecialLiteServiceImpl;
import com.digiwin.athena.adt.domain.dto.agileReport.SnapShotDTO;
import com.digiwin.athena.adt.domain.report.AgileReportDataService;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

import javax.servlet.http.HttpServletRequest;
import java.util.Objects;

/**
 * 问数主流程
 *  * 当前controller的 RequestMapping 地址和
 *  * AniaAssistantController 一直 新增接口需注意
 */
@RestController
@RequestMapping(value = "/api/ai/agileData")
public class AgileReportDataProcessController {

    @Autowired
    private SnapShotCommonService snapShotCommonService;

    @Autowired
    private AgileReportDataService agileReportDataService;

    @Autowired
    private SchemaDataProcessSpecialLiteServiceImpl schemaDataProcessSpecialLiteService;

    /**
     * 获取快照数据
     * @param snapShotDTO
     * @return
     */
    @PostMapping("/report/process")
    public ResponseEntity<?> getSnapShot(@RequestBody SnapShotDTO snapShotDTO,
                                         @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        Objects.requireNonNull(snapShotDTO, "传入的snapShotDTO为空！");
        String snapDataJsonString = JsonUtils.objectToString(snapShotDTO);
        snapShotCommonService.processAndSaveSnapShotData(snapDataJsonString,snapShotDTO,user);
        return ResponseEntityWrapper.wrapperOk("接收成功");
    }

    /**
     * B娜调用敏捷数据,将消息推送到敏捷数据接口
     * @param athenaMessageDTO
     * @return
     */
    @PostMapping("/snapData/processMessage")
    public ResponseEntity<?> getResultResponse(HttpServletRequest request, @RequestBody AthenaMessageDTO athenaMessageDTO,
                                               @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){

        Objects.requireNonNull(athenaMessageDTO, "传入的athenaMessageDTO为空！");
        return ResponseEntityWrapper.wrapperOk(agileReportDataService.processMessage(request,athenaMessageDTO,user));
    }

    /**
     * B娜调用敏捷数据,将消息推送到敏捷数据接口
     * @param req
     * @return
     */
    @PostMapping("dataPanel/processMessage")
    public ResponseEntity<?> panelFlagShipProcessMessage(HttpServletRequest request, @RequestBody AthenaMessageDTO req,
                                               @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){
        Objects.requireNonNull(req, "传入的agileDataPanelReqDTO为空！");
        return ResponseEntityWrapper.wrapperOk(agileReportDataService.panelProcessMessage(request,req,user));
    }

    @PostMapping("/v2/dataPanel/processMessage")
    public ResponseEntity<?> panelProcessMessage(HttpServletRequest request, @RequestBody AniaAssistantChatReqDTO req,
                                                 @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){

        Objects.requireNonNull(req, "传入的2.0看板请求入参为空！");
        return ResponseEntityWrapper.wrapperOk(agileReportDataService.panelFlagShipProcessMessage(request,req,user));
    }

    /**
     * 敏捷数据生成式lite版 上传附件解析入口
     * @param req
     * @return
     */
    @PostMapping("/lite/processMessage")
    public ResponseEntity<?> liteProcessMessage(@RequestBody AgileDataSpecialUploadReqDTO req,
                                                 @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){

        Objects.requireNonNull(req, "传入的AgileDataSpecialUploadReqDTO为空！");
        return ResponseEntityWrapper.wrapperOk(schemaDataProcessSpecialLiteService.liteUploadProcessMessage(req,user));
    }

    /**
     * 敏捷数据生成式lite版 上传附件解析入口
     * @param req
     * @return
     */
    @PostMapping("/lite/sendNanaMessage")
    public ResponseEntity<?> sendNanaMessage(@RequestBody AgileDataSendNanaReqDTO req,
                                                @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){

        Objects.requireNonNull(req, "传入的AgileDataSendNanaReqDTO为空！");
        schemaDataProcessSpecialLiteService.sendNanaMessage(req,user);
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 1.0 流式问句入口
     * @param athenaMessageDTO 入参集合
     * @return 流式响应
     */
    @PostMapping(value = "/sse/snapData/processMessage",produces = {MediaType.TEXT_EVENT_STREAM_VALUE})
    public SseEmitter sseProcessMessage(HttpServletRequest request, @RequestBody AthenaMessageDTO athenaMessageDTO,
                                        @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){

        Objects.requireNonNull(athenaMessageDTO, "传入的athenaMessageDTO为空！");
        return agileReportDataService.sseProcessMessage(request,athenaMessageDTO,user);
    }

    /**
     * 2.0 流式问句入口
     * @param aniaAssistantChatReqDTO 入参集合
     * @return 流式响应
     */
    @PostMapping(value = "/assistant/chat",produces = {MediaType.TEXT_EVENT_STREAM_VALUE})
    public SseEmitter sseProcessMessageV2(HttpServletRequest request, @RequestBody AniaAssistantChatReqDTO aniaAssistantChatReqDTO,
                                        @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){

        Objects.requireNonNull(aniaAssistantChatReqDTO, "传入的aniaAssistantChatReqDTO为空！");
        return agileReportDataService.sseProcessMessageV2(request,aniaAssistantChatReqDTO,user);
    }


    /**
     * 图表下载
     * @param request req
     * @param snapshotId 快照消息
     * @param user u
     * @return res
     */
    @GetMapping("/queryDetail/{snapshotId}")
    public ResponseEntity<?> getExceptionInfoByMessageId(HttpServletRequest request,
                                                         @PathVariable("snapshotId") String snapshotId,
                                                         @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        String locale = request.getHeader("locale");
        return ResponseEntityWrapper.wrapperOk(agileReportDataService.getDataDetailUrl(user, snapshotId, locale));
    }


    /**
     * 2.0 数据总结获取
     * @param agileDataSummarizeReqDTO 入参集合
     * @return 流式响应
     */
    @PostMapping(value = "/snapData/getAgileDataSummarize")
    public ResponseEntity<?> getAgileDataSummarize(@RequestBody AgileDataSummarizeReqDTO agileDataSummarizeReqDTO,
                                          @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user){

        Objects.requireNonNull(agileDataSummarizeReqDTO, "agileDataSummarizeReqDTO！");
        return ResponseEntityWrapper.wrapperOk(agileReportDataService.getAgileDataSummarize(agileDataSummarizeReqDTO,user));
    }

    /**
     * 根据appCode查询敏数版本V1 V2
     * @param appCode appCode
     * @param user u
     * @return res
     */
    @GetMapping("/getAppVersion/{appCode}")
    public ResponseEntity<?> getAppVersion(@PathVariable("appCode") String appCode,
                                                         @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(agileReportDataService.getAppVersion(user, appCode));
    }

}
